"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubFcmTokenService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubFcmTokenService = class OpHubFcmTokenService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(createOpHubFcmTokenDto) {
        if (!createOpHubFcmTokenDto.hospital_id) {
            return {
                "status": "failed",
                "messege": "enter hospital_id to post clinical notes"
            };
        }
        try {
            const [getStaffEmail] = await this.dynamicConnection.query(`select email from staff where id = ?`, [createOpHubFcmTokenDto.staff_id]);
            const staff_mail_id = await getStaffEmail.email;
            await this.connection.query(`update hospital_staffs set fcm_token = ? where username = ? and hospital_id = ?`, [
                createOpHubFcmTokenDto.fcm_token,
                staff_mail_id,
                createOpHubFcmTokenDto.hospital_id
            ]);
            return {
                "status": "success",
                "message": "fcm token updated successfully"
            };
        }
        catch (error) {
            return {
                "status": "failed",
                "message": "unable to update fcm token",
                "error": error
            };
        }
    }
};
exports.OpHubFcmTokenService = OpHubFcmTokenService;
exports.OpHubFcmTokenService = OpHubFcmTokenService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubFcmTokenService);
//# sourceMappingURL=op-hub-fcm-token.service.js.map