"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubEmrService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubEmrService = class OpHubEmrService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(recordEntity) {
        if (recordEntity.hospital_id) {
            try {
                const [HospatMob] = await this.dynamicConnection.query(`select mobileno from patients where id = ?`, [recordEntity.patient_id]);
                let mob = HospatMob.mobileno;
                let AdminTrimmedMobileno;
                if (mob.length > 10) {
                    AdminTrimmedMobileno = mob.startsWith('91') ? mob.slice(2) : mob;
                }
                else {
                    AdminTrimmedMobileno = mob;
                }
                const [getAdminPatId] = await this.connection.query(`select id from patients 
where mobileno = ? or mobileno = ?`, [mob, AdminTrimmedMobileno]);
                await this.connection.query(`insert into patient_records (
      patient_id,
      record_name,
      record_type_id,
      files,
      tags)
     values(?,?,?,?,?)`, [
                    getAdminPatId.id,
                    recordEntity.record_name,
                    recordEntity.record_type_id,
                    JSON.stringify(recordEntity.files),
                    JSON.stringify(recordEntity.tags)
                ]);
                return {
                    "status": "success",
                    "message": "Documents uploaded successfully"
                };
            }
            catch (error) {
                return {
                    "status": "failed",
                    "error": error
                };
            }
        }
        else {
            return {
                "status": "failed",
                "message": "Enter hospital_id to upload teh EMR"
            };
        }
    }
};
exports.OpHubEmrService = OpHubEmrService;
exports.OpHubEmrService = OpHubEmrService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubEmrService);
//# sourceMappingURL=op-hub-emr.service.js.map