"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubDoctorsController = exports.DoctorDto = void 0;
const common_1 = require("@nestjs/common");
const op_hub_doctors_service_1 = require("./op-hub-doctors.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_status_controller_1 = require("../op-hub-appointment-status/op-hub-appointment-status.controller");
const op_hub_appointment_entity_1 = require("../op-hub-appointment/entities/op-hub-appointment.entity");
class DoctorDto {
}
exports.DoctorDto = DoctorDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Dr. Matheshwari N',
        description: 'Name of the doctor',
    }),
    __metadata("design:type", String)
], DoctorDto.prototype, "doctor_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'matheswari@plenome.com',
        description: 'Email of the doctor',
    }),
    __metadata("design:type", String)
], DoctorDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 98, description: 'ID of the doctor' }),
    __metadata("design:type", Number)
], DoctorDto.prototype, "doctor_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Male', description: 'Gender of the doctor' }),
    __metadata("design:type", String)
], DoctorDto.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Screenshot from 2024-02-07 12-14-29.png_1709713145092',
        description: 'Image filename of the doctor',
    }),
    __metadata("design:type", String)
], DoctorDto.prototype, "image", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'MBBS', description: 'Qualification of the doctor' }),
    __metadata("design:type", String)
], DoctorDto.prototype, "qualification", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '10', description: 'Years of experience' }),
    __metadata("design:type", String)
], DoctorDto.prototype, "experience", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '4', description: 'Rating of the doctor' }),
    __metadata("design:type", String)
], DoctorDto.prototype, "rating", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'cardiologist',
        description: 'Specialization of the doctor',
    }),
    __metadata("design:type", String)
], DoctorDto.prototype, "specialist_names", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 100,
        description: 'Standard charge for the doctor consultation',
    }),
    __metadata("design:type", Number)
], DoctorDto.prototype, "standard_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Plenome Hospital',
        description: 'Name of the hospital where the doctor practices',
    }),
    __metadata("design:type", String)
], DoctorDto.prototype, "hospital_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '09:00:00 - 10:00:00',
        description: 'Hospital opening timings',
    }),
    __metadata("design:type", String)
], DoctorDto.prototype, "hospital_opening_timing", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 13,
        description: 'Charge ID associated with the doctor',
    }),
    __metadata("design:type", Number)
], DoctorDto.prototype, "charge_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '10.00%',
        description: 'Tax percentage applicable to the charge',
    }),
    __metadata("design:type", String)
], DoctorDto.prototype, "tax_percentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 10, description: 'Calculated tax amount' }),
    __metadata("design:type", Number)
], DoctorDto.prototype, "tax", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 110, description: 'Total amount to be paid' }),
    __metadata("design:type", Number)
], DoctorDto.prototype, "Totalamount", void 0);
let OpHubDoctorsController = class OpHubDoctorsController {
    constructor(doctorsService) {
        this.doctorsService = doctorsService;
    }
    findAll(search, hospital_id, date, gender) {
        return this.doctorsService.findAll(search, hospital_id, date, gender);
    }
    async findAllV2(search, hospital_id, date, gender, limit, page, specialist_id) {
        if (!hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.HOSPITAL_ID_ERR_V2,
            };
        }
        try {
            let final_out = await this.doctorsService.findAllV2(search, hospital_id, date, gender, specialist_id, +limit || 10, +page || 1);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findallv3(hospital_id, limit, page) {
        const asdf = await this.doctorsService.findallV3(hospital_id, limit || 10, page || 1);
        return asdf;
    }
    async getDocName(limit, page) {
        const docName = await this.doctorsService.getDocName(limit || 10, page || 1);
        return docName;
    }
};
exports.OpHubDoctorsController = OpHubDoctorsController;
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve list of doctors based on filters' }),
    (0, swagger_1.ApiQuery)({
        name: 'search',
        required: false,
        description: 'Search term to filter doctors by name or email',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        description: 'Hospital ID to filter doctors',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'date',
        required: false,
        description: 'Date to filter doctors based on availability',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'gender',
        required: false,
        description: 'Gender to filter doctors',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of doctors retrieved successfully.',
        type: [DoctorDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: op_hub_appointment_status_controller_1.ErrorResponse500,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Internal server error',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('gender')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Object, String]),
    __metadata("design:returntype", void 0)
], OpHubDoctorsController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('/v2'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve list of doctors based on filters' }),
    (0, swagger_1.ApiQuery)({
        name: 'search',
        required: false,
        description: 'Search term to filter doctors by name or email',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        description: 'Hospital ID to filter doctors',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'date',
        required: false,
        description: 'Date to filter doctors based on availability',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'gender',
        required: false,
        description: 'Gender to filter doctors',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of doctors retrieved successfully.',
        type: [DoctorDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: op_hub_appointment_status_controller_1.ErrorResponse500,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Internal server error',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('gender')),
    __param(4, (0, common_1.Query)('limit')),
    __param(5, (0, common_1.Query)('page')),
    __param(6, (0, common_1.Query)('specialist_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Object, String, String, String, Object]),
    __metadata("design:returntype", Promise)
], OpHubDoctorsController.prototype, "findAllV2", null);
__decorate([
    (0, common_1.Get)('/v3'),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number]),
    __metadata("design:returntype", Promise)
], OpHubDoctorsController.prototype, "findallv3", null);
__decorate([
    (0, common_1.Get)('/getDocName'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], OpHubDoctorsController.prototype, "getDocName", null);
exports.OpHubDoctorsController = OpHubDoctorsController = __decorate([
    (0, common_1.Controller)('op-hub-doctors'),
    __metadata("design:paramtypes", [op_hub_doctors_service_1.OpHubDoctorsService])
], OpHubDoctorsController);
//# sourceMappingURL=op-hub-doctors.controller.js.map