"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubDoctorSlotShiftServiceService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubDoctorSlotShiftServiceService = class OpHubDoctorSlotShiftServiceService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async getShift(Entity) {
        if (Entity.hospital_id) {
            try {
                let query = `select global_shift.name,global_shift.id shift_id,doctor_global_shift.staff_id
from doctor_global_shift left join global_shift 
on global_shift.id = doctor_global_shift.global_shift_id where staff_id = ? `;
                let values = [];
                if (Entity.staff_id) {
                    values.push(Entity.staff_id);
                    const getShifts = await this.dynamicConnection.query(query, values);
                    return getShifts;
                }
                else {
                    return {
                        "message": "Select Doctor to get Shifts"
                    };
                }
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                "message": "Enter hospital_id to get shift"
            };
        }
    }
    async getSlot(Entity) {
        if (Entity.hospital_id) {
            try {
                let query = `select doctor_shift.id shiftId, doctor_shift.start_time,
  doctor_shift.end_time,
  concat( doctor_shift.start_time," - ",doctor_shift.end_time) slot_timing ,
  doctor_shift.day,global_shift.name shiftName,
  doctor_shift.global_shift_id global_shift_id from doctor_shift
  left join global_shift on global_shift.id = doctor_shift.global_shift_id
   where staff_id = ?
  and day = dayname(?) `;
                let values = [];
                if (Entity.staff_id) {
                    values.push(Entity.staff_id);
                    if (Entity.date) {
                        values.push(Entity.date);
                        let getShifts = await this.dynamicConnection.query(query, values);
                        const [getS] = await this.dynamicConnection.query('select time(now()) as time ');
                        const currentDate = new Date();
                        const formattedDate = `${currentDate.getFullYear()}-${(currentDate.getMonth() + 1).toString().padStart(2, '0')}-${currentDate.getDate().toString().padStart(2, '0')}`;
                        if (Entity.date === formattedDate) {
                            getShifts = getShifts.filter(a => a.end_time >= getS.time);
                        }
                        return getShifts;
                    }
                    else {
                        return { "message": "Select date to get the slots" };
                    }
                }
                else {
                    return {
                        "message": "Select Doctor to get Shifts"
                    };
                }
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                "message": "Enter hospital_id to get shift"
            };
        }
    }
};
exports.OpHubDoctorSlotShiftServiceService = OpHubDoctorSlotShiftServiceService;
exports.OpHubDoctorSlotShiftServiceService = OpHubDoctorSlotShiftServiceService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubDoctorSlotShiftServiceService);
//# sourceMappingURL=op-hub-doctor-slot-shift-service.service.js.map