"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubDoctorSlotShiftServiceController = exports.SlotTimingResponse = void 0;
const common_1 = require("@nestjs/common");
const op_hub_doctor_slot_shift_service_service_1 = require("./op-hub-doctor-slot-shift-service.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_doctor_slot_shift_service_entity_1 = require("./entities/op-hub-doctor-slot-shift-service.entity");
class SlotTimingResponse {
}
exports.SlotTimingResponse = SlotTimingResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Unique identifier for the shift', example: 387 }),
    __metadata("design:type", Number)
], SlotTimingResponse.prototype, "shiftId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Timing of the slot', example: '10:19:00 - 10:47:00' }),
    __metadata("design:type", String)
], SlotTimingResponse.prototype, "slot_timing", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Day of the week for the shift', example: 'Monday' }),
    __metadata("design:type", String)
], SlotTimingResponse.prototype, "day", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Name of the shift', example: 'Morning' }),
    __metadata("design:type", String)
], SlotTimingResponse.prototype, "shiftName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Global identifier for the shift', example: 107 }),
    __metadata("design:type", Number)
], SlotTimingResponse.prototype, "global_shift_id", void 0);
let OpHubDoctorSlotShiftServiceController = class OpHubDoctorSlotShiftServiceController {
    constructor(doctorSlotShiftService) {
        this.doctorSlotShiftService = doctorSlotShiftService;
    }
    async getSlot(entity) {
        return this.doctorSlotShiftService.getSlot(entity);
    }
};
exports.OpHubDoctorSlotShiftServiceController = OpHubDoctorSlotShiftServiceController;
__decorate([
    (0, common_1.Post)('/slot'),
    (0, swagger_1.ApiOperation)({ summary: 'Get available slot timings for a doctor shift' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Available slot timings retrieved successfully.',
        type: [SlotTimingResponse],
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_doctor_slot_shift_service_entity_1.DoctorSlotShift]),
    __metadata("design:returntype", Promise)
], OpHubDoctorSlotShiftServiceController.prototype, "getSlot", null);
exports.OpHubDoctorSlotShiftServiceController = OpHubDoctorSlotShiftServiceController = __decorate([
    (0, common_1.Controller)('op-hub-doctor-slot-shift-service'),
    __metadata("design:paramtypes", [op_hub_doctor_slot_shift_service_service_1.OpHubDoctorSlotShiftServiceService])
], OpHubDoctorSlotShiftServiceController);
//# sourceMappingURL=op-hub-doctor-slot-shift-service.controller.js.map