"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubConsultationProcessController = exports.UpdateConsultationResponseDto = exports.ConsultationProcessDto = exports.StatusDto = exports.ConsultationProcessStatsDto = exports.ProcessDto = exports.ProcessTrackHistoryDto = void 0;
const common_1 = require("@nestjs/common");
const op_hub_consultation_process_service_1 = require("./op-hub-consultation-process.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_status_controller_1 = require("../op-hub-appointment-status/op-hub-appointment-status.controller");
const op_hub_appointment_entity_1 = require("../op-hub-appointment/entities/op-hub-appointment.entity");
const op_hub_consultation_process_entity_1 = require("./entities/op-hub-consultation-process.entity");
class ProcessTrackHistoryDto {
}
exports.ProcessTrackHistoryDto = ProcessTrackHistoryDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 45, description: 'The unique ID of the record' }),
    __metadata("design:type", Number)
], ProcessTrackHistoryDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 45, description: 'The consultation process tracking ID' }),
    __metadata("design:type", Number)
], ProcessTrackHistoryDto.prototype, "consultation_process_tracking_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 2, description: 'The ID of the consultation process color code' }),
    __metadata("design:type", Number)
], ProcessTrackHistoryDto.prototype, "consultation_process_color_code_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 405, description: 'The ID of the staff member associated with this record' }),
    __metadata("design:type", Number)
], ProcessTrackHistoryDto.prototype, "staff_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-06-29T05:32:59.000Z', description: 'The date and time the record was created' }),
    __metadata("design:type", String)
], ProcessTrackHistoryDto.prototype, "created_at", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-06-29T05:32:59.000Z', description: 'The date and time the record was last updated' }),
    __metadata("design:type", String)
], ProcessTrackHistoryDto.prototype, "updated_time", void 0);
class ProcessDto {
}
exports.ProcessDto = ProcessDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'The unique ID of the process' }),
    __metadata("design:type", Number)
], ProcessDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'X-RAY', description: 'The name of the process' }),
    __metadata("design:type", String)
], ProcessDto.prototype, "process_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'X-RAY description', description: 'A brief description of the process' }),
    __metadata("design:type", String)
], ProcessDto.prototype, "process_description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-05-06T13:19:07.000Z', description: 'The date and time the process was created' }),
    __metadata("design:type", String)
], ProcessDto.prototype, "created_at", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'The latitude associated with the process, if any' }),
    __metadata("design:type", Number)
], ProcessDto.prototype, "lattitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'The longitude associated with the process, if any' }),
    __metadata("design:type", Number)
], ProcessDto.prototype, "longitude", void 0);
class ConsultationProcessStatsDto {
}
exports.ConsultationProcessStatsDto = ConsultationProcessStatsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'The ID of the consultation process status' }),
    __metadata("design:type", Number)
], ConsultationProcessStatsDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Waiting', description: 'The name of the consultation process status' }),
    __metadata("design:type", String)
], ConsultationProcessStatsDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '#FFC52F', description: 'The color code associated with the process status' }),
    __metadata("design:type", String)
], ConsultationProcessStatsDto.prototype, "color_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-05-06T13:09:38.000Z', description: 'The date and time the status was created' }),
    __metadata("design:type", String)
], ConsultationProcessStatsDto.prototype, "created_at", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '0', description: 'The count of consultations in this process status' }),
    __metadata("design:type", String)
], ConsultationProcessStatsDto.prototype, "count", void 0);
class StatusDto {
}
exports.StatusDto = StatusDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'Unique identifier for the status' }),
    __metadata("design:type", Number)
], StatusDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Waiting', description: 'Name of the status' }),
    __metadata("design:type", String)
], StatusDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '#FFC52F', description: 'Color code associated with the status' }),
    __metadata("design:type", String)
], StatusDto.prototype, "color_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-05-06T13:09:38.000Z', description: 'Creation timestamp of the status' }),
    __metadata("design:type", String)
], StatusDto.prototype, "created_at", void 0);
class ConsultationProcessDto {
}
exports.ConsultationProcessDto = ConsultationProcessDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'The name of the doctor, if assigned' }),
    __metadata("design:type", String)
], ConsultationProcessDto.prototype, "doctor", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'X-RAY description', description: 'Description of the consultation process' }),
    __metadata("design:type", String)
], ConsultationProcessDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'X-RAY', description: 'Name of the consultation process' }),
    __metadata("design:type", String)
], ConsultationProcessDto.prototype, "Consultation_Process", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '#FFC52F', description: 'Color code associated with the consultation process' }),
    __metadata("design:type", String)
], ConsultationProcessDto.prototype, "color_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Waiting', description: 'Current status of the consultation process' }),
    __metadata("design:type", String)
], ConsultationProcessDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '12th Jul 2024 10:00 AM', description: 'Timing of the consultation process' }),
    __metadata("design:type", String)
], ConsultationProcessDto.prototype, "timing", void 0);
class UpdateConsultationResponseDto {
}
exports.UpdateConsultationResponseDto = UpdateConsultationResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success', description: 'The status of the operation' }),
    __metadata("design:type", String)
], UpdateConsultationResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Prescription updated successfully', description: 'The message indicating the result of the operation' }),
    __metadata("design:type", String)
], UpdateConsultationResponseDto.prototype, "message", void 0);
let OpHubConsultationProcessController = class OpHubConsultationProcessController {
    constructor(ConsultationService) {
        this.ConsultationService = ConsultationService;
    }
    async findAll(hospital_id) {
        return this.ConsultationService.findAllColorCode(hospital_id);
    }
    async findAllprocess(hospital_id) {
        return this.ConsultationService.findAllProcessList(hospital_id);
    }
    async findAllprocesstrack(hospital_id, appointment_id) {
        return this.ConsultationService.findAllProcessTrackList(hospital_id, appointment_id);
    }
    async findAllprocesstrackhistory(hospital_id) {
        return this.ConsultationService.ProcessTrackHistory(hospital_id);
    }
    async getConsultationProcessStats(hospital_id, appointment_id) {
        return this.ConsultationService.gettrackstats(hospital_id, appointment_id);
    }
    async updateOrCreateConsultation(updateConsultation) {
        return this.ConsultationService.update(updateConsultation);
    }
};
exports.OpHubConsultationProcessController = OpHubConsultationProcessController;
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all color codes based on hospital ID' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'ID of the hospital', type: Number }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'List of color codes retrieved successfully', type: [StatusDto] }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], OpHubConsultationProcessController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('process'),
    (0, swagger_1.ApiOperation)({ summary: 'Get the list of processes for a hospital' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'The ID of the hospital' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of processes for the specified hospital',
        type: [ProcessDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], OpHubConsultationProcessController.prototype, "findAllprocess", null);
__decorate([
    (0, common_1.Get)('tracking'),
    (0, swagger_1.ApiOperation)({ summary: 'Get the tracking details of consultation processes' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of consultation process tracking details',
        type: [ConsultationProcessDto],
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('appointment_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", Promise)
], OpHubConsultationProcessController.prototype, "findAllprocesstrack", null);
__decorate([
    (0, common_1.Get)('process-history'),
    (0, swagger_1.ApiOperation)({ summary: 'Get the consultation process track history' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'The ID of the hospital' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'The consultation process track history records',
        type: [ProcessTrackHistoryDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], OpHubConsultationProcessController.prototype, "findAllprocesstrackhistory", null);
__decorate([
    (0, common_1.Get)('stats'),
    (0, swagger_1.ApiOperation)({ summary: 'Get stats of consultation' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'The ID of the hospital' }),
    (0, swagger_1.ApiQuery)({ name: 'appointment_id', required: true, description: 'The appointment ID' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'The consultation process statistics',
        type: [ConsultationProcessStatsDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('appointment_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", Promise)
], OpHubConsultationProcessController.prototype, "getConsultationProcessStats", null);
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Consultation status add or update for an appointment' }),
    (0, swagger_1.ApiBody)({ type: op_hub_consultation_process_entity_1.Consultation, description: 'Data required to update or create a consultation' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'The consultation has been successfully updated or created',
        type: [UpdateConsultationResponseDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_consultation_process_entity_1.Consultation]),
    __metadata("design:returntype", Promise)
], OpHubConsultationProcessController.prototype, "updateOrCreateConsultation", null);
exports.OpHubConsultationProcessController = OpHubConsultationProcessController = __decorate([
    (0, common_1.Controller)('op-hub-consultation-process'),
    __metadata("design:paramtypes", [op_hub_consultation_process_service_1.OpHubConsultationProcessService])
], OpHubConsultationProcessController);
//# sourceMappingURL=op-hub-consultation-process.controller.js.map