import { OpHubConsultationProcessService } from './op-hub-consultation-process.service';
import { Consultation } from './entities/op-hub-consultation-process.entity';
export declare class ProcessTrackHistoryDto {
    id: number;
    consultation_process_tracking_id: number;
    consultation_process_color_code_id: number;
    staff_id: number | null;
    created_at: string;
    updated_time: string;
}
export declare class ProcessDto {
    id: number;
    process_name: string;
    process_description: string;
    created_at: string;
    lattitude: number | null;
    longitude: number | null;
}
export declare class ConsultationProcessStatsDto {
    id: number;
    name: string;
    color_code: string;
    created_at: string;
    count: string;
}
export declare class StatusDto {
    id: number;
    name: string;
    color_code: string;
    created_at: string;
}
export declare class ConsultationProcessDto {
    doctor: string | null;
    description: string;
    Consultation_Process: string;
    color_code: string;
    status: string;
    timing: string;
}
export declare class UpdateConsultationResponseDto {
    status: string;
    message: string;
}
export declare class OpHubConsultationProcessController {
    private readonly ConsultationService;
    constructor(ConsultationService: OpHubConsultationProcessService);
    findAll(hospital_id: number): Promise<any>;
    findAllprocess(hospital_id: number): Promise<any>;
    findAllprocesstrack(hospital_id: number, appointment_id: string): Promise<any>;
    findAllprocesstrackhistory(hospital_id: number): Promise<any>;
    getConsultationProcessStats(hospital_id: number, appointment_id: string): Promise<any>;
    updateOrCreateConsultation(updateConsultation: Consultation): Promise<any>;
}
