"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubClinicalNotesController = exports.GetclinicalNotesResponseDto = exports.CreateClinicalNotesResponseDto = void 0;
const common_1 = require("@nestjs/common");
const op_hub_clinical_notes_service_1 = require("./op-hub-clinical-notes.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_status_controller_1 = require("../op-hub-appointment-status/op-hub-appointment-status.controller");
const op_hub_appointment_entity_1 = require("../op-hub-appointment/entities/op-hub-appointment.entity");
const op_hub_clinical_note_entity_1 = require("./entities/op-hub-clinical-note.entity");
class CreateClinicalNotesResponseDto {
}
exports.CreateClinicalNotesResponseDto = CreateClinicalNotesResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success', description: 'The status of the response' }),
    __metadata("design:type", String)
], CreateClinicalNotesResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Prescription added successfully', description: 'The message describing the result' }),
    __metadata("design:type", String)
], CreateClinicalNotesResponseDto.prototype, "message", void 0);
class GetclinicalNotesResponseDto {
}
exports.GetclinicalNotesResponseDto = GetclinicalNotesResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Prescription....', description: 'The name of the record' }),
    __metadata("design:type", String)
], GetclinicalNotesResponseDto.prototype, "record_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '_6f07dad7-34e8-4c8f-b564-d27c69e218cf.jpeg_1709716024863', description: 'File name associated with the prescription' }),
    __metadata("design:type", String)
], GetclinicalNotesResponseDto.prototype, "files", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'Tags associated with the prescription, can be null', nullable: true }),
    __metadata("design:type", String)
], GetclinicalNotesResponseDto.prototype, "tags", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 405, description: 'Hospital outpatient department ID' }),
    __metadata("design:type", Number)
], GetclinicalNotesResponseDto.prototype, "hos_opd_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'Doctor’s name, can be null', nullable: true }),
    __metadata("design:type", String)
], GetclinicalNotesResponseDto.prototype, "doctorName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '12th Jul 2024,09:00 AM', description: 'The appointment date and time' }),
    __metadata("design:type", String)
], GetclinicalNotesResponseDto.prototype, "appointDate", void 0);
let OpHubClinicalNotesController = class OpHubClinicalNotesController {
    constructor(clinicalNotesService) {
        this.clinicalNotesService = clinicalNotesService;
    }
    create(createClinicalNoteDto) {
        return this.clinicalNotesService.create(createClinicalNoteDto);
    }
    findAll(createClinicalNoteDto) {
        return this.clinicalNotesService.findAll(createClinicalNoteDto);
    }
};
exports.OpHubClinicalNotesController = OpHubClinicalNotesController;
__decorate([
    (0, common_1.Post)('/post'),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new prescription' }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'The prescription has been successfully created.',
        type: CreateClinicalNotesResponseDto,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: op_hub_appointment_status_controller_1.ErrorResponse500,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Internal server error',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_clinical_note_entity_1.ClinicalNote]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('/get'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all prescriptions' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of all prescriptions retrieved successfully.',
        type: [GetclinicalNotesResponseDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: op_hub_appointment_status_controller_1.ErrorResponse500,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Internal server error',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_clinical_note_entity_1.ClinicalNote]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesController.prototype, "findAll", null);
exports.OpHubClinicalNotesController = OpHubClinicalNotesController = __decorate([
    (0, common_1.Controller)('op-hub-clinical-notes'),
    __metadata("design:paramtypes", [op_hub_clinical_notes_service_1.OpHubClinicalNotesService])
], OpHubClinicalNotesController);
//# sourceMappingURL=op-hub-clinical-notes.controller.js.map