"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubClinicalNotesWithAbhaService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubClinicalNotesWithAbhaService = class OpHubClinicalNotesWithAbhaService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(clinicalNotes) {
        if (!clinicalNotes.hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            if (clinicalNotes.chiefComplaintDetails &&
                clinicalNotes.chiefComplaintsBasic) {
                const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [
                    clinicalNotes.hospital_id,
                    clinicalNotes.chiefComplaintDetails.opd_id,
                ]);
                const insertDetails = await this.dynamicConnection.query(`insert into chief_complaint_details (opd_id,
    count,
    duration_limit,
    remarks,
    filled_using) values (?,?,?,?,?)`, [
                    clinicalNotes.chiefComplaintDetails.opd_id,
                    clinicalNotes.chiefComplaintDetails.count,
                    clinicalNotes.chiefComplaintDetails.duration_limit,
                    clinicalNotes.chiefComplaintDetails.remarks,
                    clinicalNotes.chiefComplaintDetails.filled_using,
                ]);
                const insertDetailsAdmin = await this.connection.query(`insert into chief_complaint_details (opd_id,
    count,
    duration_limit,
    remarks,
    filled_using,
    hospital_id,
    hos_chief_complaint_details_id) values (?,?,?,?,?,?,?)`, [
                    getOPDAdmin.id,
                    clinicalNotes.chiefComplaintDetails.count,
                    clinicalNotes.chiefComplaintDetails.duration_limit,
                    clinicalNotes.chiefComplaintDetails.remarks,
                    clinicalNotes.chiefComplaintDetails.filled_using,
                    clinicalNotes.hospital_id,
                    insertDetails.insertId,
                ]);
                for (const aa of clinicalNotes.chiefComplaintsBasic) {
                    const insertBasic = await this.dynamicConnection.query(`insert into chief_complaints_basic (opd_id,
    chief_complaints_detail_id,
    complaints_name,
    filled_using
    ) values (?,?,?,?)`, [
                        aa.opd_id,
                        insertDetails.insertId,
                        aa.complaint_name,
                        aa.filled_using,
                    ]);
                    await this.connection.query(`insert into chief_complaints_basic (opd_id,
        chief_complaints_detail_id,
        complaints_name,
        filled_using,
        hospital_id,
        hos_chief_complaints_basic_id
        ) values (?,?,?,?,?,?)`, [
                        getOPDAdmin.id,
                        insertDetailsAdmin.insertId,
                        aa.complaint_name,
                        aa.filled_using,
                        clinicalNotes.hospital_id,
                        insertBasic.insertId,
                    ]);
                }
            }
            if (clinicalNotes.pastTreatmentHistory &&
                clinicalNotes.pastTreatmentHistoryDocs) {
                const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [
                    clinicalNotes.hospital_id,
                    clinicalNotes.chiefComplaintDetails.opd_id,
                ]);
                const insertHistory = await this.dynamicConnection.query(`insert into past_history (opd_id,
    history,
    filled_using) values (?,?,?)`, [
                    clinicalNotes.pastTreatmentHistory.opd_id,
                    clinicalNotes.pastTreatmentHistory.history,
                    clinicalNotes.pastTreatmentHistory.filled_using,
                ]);
                const insertDetailsAdmin = await this.connection.query(`insert into past_history (opd_id,
    history,
    filled_using,
    hospital_id,
    hos_past_history_id) values (?,?,?,?,?)`, [
                    getOPDAdmin.id,
                    clinicalNotes.pastTreatmentHistory.history,
                    clinicalNotes.pastTreatmentHistory.filled_using,
                    clinicalNotes.hospital_id,
                    insertHistory.insertId,
                ]);
                for (const aa of clinicalNotes.pastTreatmentHistoryDocs) {
                    const insertBasic = await this.dynamicConnection.query(`insert into past_history_docs (opd_id,
    past_history_id,
    document,
    filled_using
    ) values (?,?,?,?)`, [aa.opd_id, insertHistory.insertId, aa.documents, aa.filled_using]);
                    await this.connection.query(`insert into past_history_docs (opd_id,
        past_history_id,
        document,
        filled_using,
        hospital_id,
        hos_past_history_docs_id
        ) values (?,?,?,?,?,?)`, [
                        getOPDAdmin.id,
                        insertDetailsAdmin.insertId,
                        aa.documents,
                        aa.filled_using,
                        clinicalNotes.hospital_id,
                        insertBasic.insertId,
                    ]);
                }
            }
            if (clinicalNotes.diagnosisReport) {
                for (const aa of clinicalNotes.diagnosisReport) {
                    const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [clinicalNotes.hospital_id, aa.opd_id]);
                    const insertBasic = await this.dynamicConnection.query(`insert into diagnosis_report (opd_id,
                test_categories,
                sub_category,
                laboratory,
                remarks,
                filled_using
                ) values (?,?,?,?,?,?)`, [
                        aa.opd_id,
                        aa.test_categories,
                        aa.sub_category,
                        aa.laboratory,
                        aa.remarks,
                        aa.filled_using,
                    ]);
                    await this.connection.query(`insert into diagnosis_report (opd_id,
                test_categories,
                sub_category,
                laboratory,
                remarks,
                    filled_using,
                    hospital_id,
                    hos_diagnosis_report_id
                    ) values (?,?,?,?,?,?,?,?)`, [
                        getOPDAdmin.id,
                        aa.test_categories,
                        aa.sub_category,
                        aa.laboratory,
                        aa.remarks,
                        aa.filled_using,
                        clinicalNotes.hospital_id,
                        insertBasic.insertId,
                    ]);
                }
            }
            if (clinicalNotes.dietPlan) {
                let aa = clinicalNotes.dietPlan;
                const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [clinicalNotes.hospital_id, aa.opd_id]);
                const insertBasic = await this.dynamicConnection.query(`insert into diet_plan (opd_id,
            diet_plan,
            filled_using
            ) values (?,?,?)`, [aa.opd_id, aa.diet_plan, aa.filled_using]);
                await this.connection.query(`insert into diet_plan (opd_id,
            diet_plan,
            filled_using,
                hospital_id,
                hos_diet_plan_id
                ) values (?,?,?,?,?)`, [
                    getOPDAdmin.id,
                    aa.diet_plan,
                    aa.filled_using,
                    clinicalNotes.hospital_id,
                    insertBasic.insertId,
                ]);
            }
            if (clinicalNotes.treatmentAdvice) {
                let aa = clinicalNotes.treatmentAdvice;
                const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [clinicalNotes.hospital_id, aa.opd_id]);
                const insertBasic = await this.dynamicConnection.query(`insert into treatment_advice (opd_id,
            treatment_advice,
            filled_using
            ) values (?,?,?)`, [aa.opd_id, aa.advice, aa.filled_using]);
                await this.connection.query(`insert into treatment_advice (opd_id,
            treatment_advice,
            filled_using,
                hospital_id,
                hos_treatment_advice_id
                ) values (?,?,?,?,?)`, [
                    getOPDAdmin.id,
                    aa.advice,
                    aa.filled_using,
                    clinicalNotes.hospital_id,
                    insertBasic.insertId,
                ]);
            }
            if (clinicalNotes.followUp) {
                let aa = clinicalNotes.followUp;
                const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [clinicalNotes.hospital_id, aa.opd_id]);
                const insertBasic = await this.dynamicConnection.query(`insert into follow_up (opd_id,
            count,
            duration,
            date,
            remarks,
            filled_using
            ) values (?,?,?,?,?,?)`, [
                    aa.opd_id,
                    aa.count,
                    aa.duration_limit,
                    aa.date,
                    aa.remarks,
                    aa.filled_using,
                ]);
                await this.connection.query(`insert into follow_up (opd_id,
            count,
            duration,
            date,
            remarks,
            filled_using,
                hospital_id,
                hos_follow_up_id
                ) values (?,?,?,?,?,?,?,?)`, [
                    getOPDAdmin.id,
                    aa.count,
                    aa.duration_limit,
                    aa.date,
                    aa.remarks,
                    aa.filled_using,
                    clinicalNotes.hospital_id,
                    insertBasic.insertId,
                ]);
            }
            return {
                status: 'success',
                messege: 'clinical notes added successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to post clinical-notes',
            };
        }
    }
    async findAll(opd_id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            const getComplaintBasic = await this.dynamicConnection.query(`select * from chief_complaints_basic where opd_id = ?`, [opd_id]);
            const [getComplaintdetails] = await this.dynamicConnection.query(`select * from chief_complaint_details where opd_id = ?`, [opd_id]);
            const [getPastTreatmentHis] = await this.dynamicConnection.query(`select * from past_history where opd_id = ?`, [opd_id]);
            const getPastHisDocs = await this.dynamicConnection.query(`select * from past_history_docs where opd_id = ?`, [opd_id]);
            const getDiagnosisReport = await this.dynamicConnection.query(`select * from diagnosis_report where opd_id = ?`, [opd_id]);
            const [getDietPlan] = await this.dynamicConnection.query(`select * from diet_plan where opd_id = ?`, [opd_id]);
            const [getTreatmentAdvice] = await this.dynamicConnection.query(`select * from treatment_advice where opd_id = ?`, [opd_id]);
            const [getFollowUp] = await this.dynamicConnection.query(`select * from follow_up where opd_id = ?`, [opd_id]);
            const [getOpdDetails] = await this.dynamicConnection.query(`
select DATE_FORMAT(visit_details.appointment_date, '%D %b %Y') date,
DATE_FORMAT(visit_details.appointment_date, '%h:%i %p') time,
concat("OPDN",visit_details.opd_details_id) opd_no,
concat(staff.name," ",staff.surname) consultant
from visit_details left join staff on staff.id = visit_details.cons_doctor where opd_details_id = ?
`, [opd_id]);
            let out = {
                OpdDetails: getOpdDetails,
            };
            if (getComplaintBasic.length > 0) {
                out['chiefComplaintsBasic'] = getComplaintBasic;
            }
            if (getComplaintdetails) {
                out['chiefComplaintDetails'] = getComplaintdetails;
            }
            if (getPastTreatmentHis) {
                out['pastTreatmentHistory'] = getPastTreatmentHis;
            }
            if (getPastHisDocs.length > 0) {
                out['pastTreatmentHistoryDocs'] = getPastHisDocs;
            }
            if (getDiagnosisReport.length > 0) {
                out['diagnosisReport'] = getDiagnosisReport;
            }
            if (getDietPlan) {
                out['dietPlan'] = getDietPlan;
            }
            if (getTreatmentAdvice) {
                out['treatmentAdvice'] = getTreatmentAdvice;
            }
            if (getFollowUp) {
                out['followUp'] = getFollowUp;
            }
            return {
                status: 'success',
                messege: 'clinical fetched  successfully',
                details: out,
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to fetch clinical-notes',
            };
        }
    }
    async update(clinicalNotes) {
        if (!clinicalNotes.hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            if (clinicalNotes.chiefComplaintDetails &&
                clinicalNotes.chiefComplaintsBasic) {
                if (clinicalNotes.chiefComplaintDetails.id) {
                    await this.dynamicConnection.query(`update chief_complaint_details set 
            count = ?, duration_limit = ?, remarks = ?, filled_using = ? where id = ?`, [
                        clinicalNotes.chiefComplaintDetails.count,
                        clinicalNotes.chiefComplaintDetails.duration_limit,
                        clinicalNotes.chiefComplaintDetails.remarks,
                        clinicalNotes.chiefComplaintDetails.filled_using,
                        clinicalNotes.chiefComplaintDetails.id,
                    ]);
                    await this.connection.query(`update chief_complaint_details set 
            count = ?, duration_limit = ?, remarks = ?, filled_using = ?
             where hospital_id = ? and hos_chief_complaint_details_id = ?`, [
                        clinicalNotes.chiefComplaintDetails.count,
                        clinicalNotes.chiefComplaintDetails.duration_limit,
                        clinicalNotes.chiefComplaintDetails.remarks,
                        clinicalNotes.chiefComplaintDetails.filled_using,
                        clinicalNotes.hospital_id,
                        clinicalNotes.chiefComplaintDetails.id,
                    ]);
                }
                else {
                    const insertDetail = await this.dynamicConnection.query(`insert into chief_complaint_details (count, duration_limit, remarks, filled_using) values (?,?,?,?)`, [
                        clinicalNotes.chiefComplaintDetails.count,
                        clinicalNotes.chiefComplaintDetails.duration_limit,
                        clinicalNotes.chiefComplaintDetails.remarks,
                        clinicalNotes.chiefComplaintDetails.filled_using,
                    ]);
                    await this.connection.query(`insert into chief_complaint_details (count, duration_limit, remarks, filled_using, hospital_id, hos_chief_complaint_details_id) values (?,?,?,?,?,?)`, [
                        clinicalNotes.chiefComplaintDetails.count,
                        clinicalNotes.chiefComplaintDetails.duration_limit,
                        clinicalNotes.chiefComplaintDetails.remarks,
                        clinicalNotes.chiefComplaintDetails.filled_using,
                        clinicalNotes.hospital_id,
                        insertDetail.insertId,
                    ]);
                    clinicalNotes.chiefComplaintDetails.id = insertDetail.insertId;
                }
                for (const aa of clinicalNotes.chiefComplaintsBasic) {
                    if (aa.id) {
                        await this.dynamicConnection.query(`update chief_complaints_basic set 
              complaints_name = ?, filled_using = ? where id = ?`, [aa.complaint_name, aa.filled_using, aa.id]);
                        await this.connection.query(`update chief_complaints_basic set 
              complaints_name = ?, filled_using = ? where hospital_id = ? and hos_chief_complaints_basic_id = ?`, [
                            aa.complaint_name,
                            aa.filled_using,
                            clinicalNotes.hospital_id,
                            aa.id,
                        ]);
                    }
                    else {
                        const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [clinicalNotes.hospital_id, aa.opd_id]);
                        const [getAdminId] = await this.connection.query(`select * from chief_complaint_details where hospital_id = ? and hos_chief_complaint_details_id = ?`, [
                            clinicalNotes.hospital_id,
                            clinicalNotes.chiefComplaintDetails.id,
                        ]);
                        const insertBasic = await this.dynamicConnection.query(`insert into chief_complaints_basic (opd_id, chief_complaints_detail_id, complaints_name, filled_using) values (?,?,?,?)`, [
                            aa.opd_id,
                            clinicalNotes.chiefComplaintDetails.id,
                            aa.complaint_name,
                            aa.filled_using,
                        ]);
                        await this.connection.query(`insert into chief_complaints_basic (opd_id, chief_complaints_detail_id, complaints_name, filled_using, hospital_id, hos_chief_complaints_basic_id) values (?,?,?,?,?,?)`, [
                            getOPDAdmin.id,
                            getAdminId.id,
                            aa.complaint_name,
                            aa.filled_using,
                            clinicalNotes.hospital_id,
                            insertBasic.insertId,
                        ]);
                    }
                }
            }
            if (clinicalNotes.pastTreatmentHistory &&
                clinicalNotes.pastTreatmentHistoryDocs) {
                if (clinicalNotes.pastTreatmentHistory.id) {
                    await this.dynamicConnection.query(`update past_history set 
            history = ?, filled_using = ? where id = ?`, [
                        clinicalNotes.pastTreatmentHistory.history,
                        clinicalNotes.pastTreatmentHistory.filled_using,
                        clinicalNotes.pastTreatmentHistory.id,
                    ]);
                    await this.connection.query(`update past_history set 
            history = ?, filled_using = ? where hospital_id = ? and hos_past_history_id = ?`, [
                        clinicalNotes.pastTreatmentHistory.history,
                        clinicalNotes.pastTreatmentHistory.filled_using,
                        clinicalNotes.hospital_id,
                        clinicalNotes.pastTreatmentHistory.id,
                    ]);
                }
                else {
                    const insertHistory = await this.dynamicConnection.query(`insert into past_history (history, filled_using) values (?,?)`, [
                        clinicalNotes.pastTreatmentHistory.history,
                        clinicalNotes.pastTreatmentHistory.filled_using,
                    ]);
                    await this.connection.query(`insert into past_history (history, filled_using, hospital_id, hos_past_history_id) values (?,?,?,?)`, [
                        clinicalNotes.pastTreatmentHistory.history,
                        clinicalNotes.pastTreatmentHistory.filled_using,
                        clinicalNotes.hospital_id,
                        insertHistory.insertId,
                    ]);
                    clinicalNotes.pastTreatmentHistory.id = insertHistory.insertId;
                }
                for (const aa of clinicalNotes.pastTreatmentHistoryDocs) {
                    if (aa.id) {
                        await this.dynamicConnection.query(`update past_history_docs set 
              document = ?, filled_using = ? where id = ?`, [aa.documents, aa.filled_using, aa.id]);
                        await this.connection.query(`update past_history_docs set 
              document = ?, filled_using = ? where hospital_id = ? and hos_past_history_docs_id = ?`, [aa.documents, aa.filled_using, clinicalNotes.hospital_id, aa.id]);
                    }
                    else {
                        const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [clinicalNotes.hospital_id, aa.opd_id]);
                        const [getAdminPastTreatmentHisID] = await this.connection.query(`select id from past_history where hospital_id = ? and hos_past_history_id = ?`, [
                            clinicalNotes.hospital_id,
                            clinicalNotes.pastTreatmentHistory.id,
                        ]);
                        const insertDoc = await this.dynamicConnection.query(`insert into past_history_docs (opd_id, past_history_id, document, filled_using) values (?,?,?,?)`, [
                            aa.opd_id,
                            clinicalNotes.pastTreatmentHistory.id,
                            aa.documents,
                            aa.filled_using,
                        ]);
                        await this.connection.query(`insert into past_history_docs (opd_id, past_history_id, document, filled_using, hospital_id, hos_past_history_docs_id) values (?,?,?,?,?,?)`, [
                            getOPDAdmin.id,
                            getAdminPastTreatmentHisID.id,
                            aa.documents,
                            aa.filled_using,
                            clinicalNotes.hospital_id,
                            insertDoc.insertId,
                        ]);
                    }
                }
            }
            if (clinicalNotes.diagnosisReport) {
                for (const aa of clinicalNotes.diagnosisReport) {
                    if (aa.id) {
                        await this.dynamicConnection.query(`update diagnosis_report set
              test_categories = ?, sub_category = ?, laboratory = ?, remarks = ?, filled_using = ? where id = ?`, [
                            aa.test_categories,
                            aa.sub_category,
                            aa.laboratory,
                            aa.remarks,
                            aa.filled_using,
                            aa.id,
                        ]);
                        await this.connection.query(`update diagnosis_report set
              test_categories = ?, sub_category = ?, laboratory = ?, remarks = ?, filled_using = ? where hospital_id = ? and hos_diagnosis_report_id = ?`, [
                            aa.test_categories,
                            aa.sub_category,
                            aa.laboratory,
                            aa.remarks,
                            aa.filled_using,
                            clinicalNotes.hospital_id,
                            aa.id,
                        ]);
                    }
                    else {
                        const [getOPDAdmin] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [clinicalNotes.hospital_id, aa.opd_id]);
                        const insertReport = await this.dynamicConnection.query(`insert into diagnosis_report (opd_id, test_categories, sub_category, laboratory, remarks, filled_using) values (?,?,?,?,?,?)`, [
                            aa.opd_id,
                            aa.test_categories,
                            aa.sub_category,
                            aa.laboratory,
                            aa.remarks,
                            aa.filled_using,
                        ]);
                        await this.connection.query(`insert into diagnosis_report (opd_id, test_categories, sub_category, laboratory, remarks, filled_using, hospital_id, hos_diagnosis_report_id) values (?,?,?,?,?,?,?,?)`, [
                            getOPDAdmin.id,
                            aa.test_categories,
                            aa.sub_category,
                            aa.laboratory,
                            aa.remarks,
                            aa.filled_using,
                            clinicalNotes.hospital_id,
                            insertReport.insertId,
                        ]);
                    }
                }
            }
            if (clinicalNotes.dietPlan) {
                let aa = clinicalNotes.dietPlan;
                if (aa.id) {
                    await this.dynamicConnection.query(`update diet_plan set diet_plan = ?, filled_using = ? where id = ?`, [aa.diet_plan, aa.filled_using, aa.id]);
                    await this.connection.query(`update diet_plan set diet_plan = ?, filled_using = ? where hospital_id = ? and hos_diet_plan_id = ?`, [aa.diet_plan, aa.filled_using, clinicalNotes.hospital_id, aa.id]);
                }
                else {
                    const insertDiet = await this.dynamicConnection.query(`insert into diet_plan (diet_plan, filled_using) values (?,?)`, [aa.diet_plan, aa.filled_using]);
                    await this.connection.query(`insert into diet_plan (diet_plan, filled_using, hospital_id, hos_diet_plan_id) values (?,?,?,?)`, [
                        aa.diet_plan,
                        aa.filled_using,
                        clinicalNotes.hospital_id,
                        insertDiet.insertId,
                    ]);
                }
            }
            if (clinicalNotes.treatmentAdvice) {
                let aa = clinicalNotes.treatmentAdvice;
                if (aa.id) {
                    await this.dynamicConnection.query(`update treatment_advice set treatment_advice = ?, filled_using = ? where id = ?`, [aa.advice, aa.filled_using, aa.id]);
                    await this.connection.query(`update treatment_advice set treatment_advice = ?, filled_using = ? where hospital_id = ? and hos_treatment_advice_id = ?`, [aa.advice, aa.filled_using, clinicalNotes.hospital_id, aa.id]);
                }
                else {
                    const insertAdvice = await this.dynamicConnection.query(`insert into treatment_advice (treatment_advice, filled_using) values (?,?)`, [aa.advice, aa.filled_using]);
                    await this.connection.query(`insert into treatment_advice (treatment_advice, filled_using, hospital_id, hos_treatment_advice_id) values (?,?,?,?)`, [
                        aa.advice,
                        aa.filled_using,
                        clinicalNotes.hospital_id,
                        insertAdvice.insertId,
                    ]);
                }
            }
            if (clinicalNotes.followUp) {
                let aa = clinicalNotes.followUp;
                if (aa.id) {
                    await this.dynamicConnection.query(`update follow_up set count = ?, duration = ?, date = ?, remarks = ?, filled_using = ? where id = ?`, [
                        aa.count,
                        aa.duration_limit,
                        aa.date,
                        aa.remarks,
                        aa.filled_using,
                        aa.id,
                    ]);
                    await this.connection.query(`update follow_up set count = ?, duration = ?, date = ?, remarks = ?, filled_using = ? where hospital_id = ? and hos_follow_up_id = ?`, [
                        aa.count,
                        aa.duration_limit,
                        aa.date,
                        aa.remarks,
                        aa.filled_using,
                        clinicalNotes.hospital_id,
                        aa.id,
                    ]);
                }
                else {
                    const insertFollow = await this.dynamicConnection.query(`insert into follow_up (count, duration, date, remarks, filled_using) values (?,?,?,?,?)`, [aa.count, aa.duration_limit, aa.date, aa.remarks, aa.filled_using]);
                    await this.connection.query(`insert into follow_up (count, duration, date, remarks, filled_using, hospital_id, hos_follow_up_id) values (?,?,?,?,?,?)`, [
                        aa.count,
                        aa.duration_limit,
                        aa.date,
                        aa.remarks,
                        aa.filled_using,
                        clinicalNotes.hospital_id,
                        insertFollow.insertId,
                    ]);
                }
            }
            return {
                status: 'success',
                messege: 'clinical notes updated successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to update clinical-notes',
            };
        }
    }
    async delCompBasic(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from chief_complaints_basic where id = ?`, [id]);
            this.connection.query(`delete from chief_complaints_basic where hospital_id = ? and hos_chief_complaints_basic_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'chief complaint basic deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete chief complaint basic',
            };
        }
    }
    async delCompDetail(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from chief_complaint_details where id = ?`, [id]);
            this.connection.query(`delete from chief_complaint_details where hospital_id = ? and hos_chief_complaint_details_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'chief complaint detail deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete chief complaint detail',
            };
        }
    }
    async delTreatHis(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from past_history where id = ?`, [id]);
            this.connection.query(`delete from past_history where hospital_id = ? and hos_past_history_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'past treatment history detail deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete past treatment history detail',
            };
        }
    }
    async delTreatHisDocs(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from past_history_docs where id = ?`, [id]);
            this.connection.query(`delete from past_history_docs where hospital_id = ? and hos_past_history_docs_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'past treatment history documents detail deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete past treatment history documents',
            };
        }
    }
    async delTreatmentAdvice(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from treatment_advice where id = ?`, [id]);
            this.connection.query(`delete from treatment_advice where hospital_id = ? and hos_treatment_advice_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'treatment advice detail deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete treatment advice',
            };
        }
    }
    async delDiagReport(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from diagnosis_report where id = ?`, [id]);
            this.connection.query(`delete from diagnosis_report where hospital_id = ? and hos_diagnosis_report_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'treatment advice detail deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete treatment advice',
            };
        }
    }
    async delDietPlan(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from diet_plan where id = ?`, [
                id,
            ]);
            this.connection.query(`delete from diet_plan where hospital_id = ? and hos_diet_plan_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'diet plan detail deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete diet plan',
            };
        }
    }
    async delFollowUp(id, hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                messege: 'enter hospital_id to post clinical notes',
            };
        }
        try {
            await this.dynamicConnection.query(`delete from follow_up where id = ?`, [
                id,
            ]);
            this.connection.query(`delete from follow_up where hospital_id = ? and hos_follow_up_id = ?`, [hospital_id, id]);
            return {
                status: 'success',
                messege: 'follow up detail deleted successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                messege: 'failed to delete follow up',
            };
        }
    }
};
exports.OpHubClinicalNotesWithAbhaService = OpHubClinicalNotesWithAbhaService;
exports.OpHubClinicalNotesWithAbhaService = OpHubClinicalNotesWithAbhaService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubClinicalNotesWithAbhaService);
//# sourceMappingURL=op-hub-clinical-notes-with-abha.service.js.map