import { EventEmitter2 } from '@nestjs/event-emitter';
import { DataSource } from 'typeorm';
import { ClinicalNotesWithAbha } from './entities/op-hub-clinical-notes-with-abha.entity';
export declare class OpHubClinicalNotesWithAbhaService {
    private readonly dynamicConnection;
    private readonly connection;
    private readonly eventEmitter;
    constructor(dynamicConnection: DataSource, connection: DataSource, eventEmitter: EventEmitter2);
    create(clinicalNotes: ClinicalNotesWithAbha): Promise<{
        status: string;
        messege: string;
    }>;
    findAll(opd_id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
        details?: undefined;
    } | {
        status: string;
        messege: string;
        details: {
            OpdDetails: any;
        };
    }>;
    update(clinicalNotes: any): Promise<{
        status: string;
        messege: string;
    }>;
    delCompBasic(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
    delCompDetail(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
    delTreatHis(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
    delTreatHisDocs(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
    delTreatmentAdvice(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
    delDiagReport(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
    delDietPlan(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
    delFollowUp(id: any, hospital_id: any): Promise<{
        status: string;
        messege: string;
    }>;
}
