"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubClinicalNotesWithAbhaController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_clinical_notes_with_abha_service_1 = require("./op-hub-clinical-notes-with-abha.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_clinical_notes_with_abha_entity_1 = require("./entities/op-hub-clinical-notes-with-abha.entity");
let OpHubClinicalNotesWithAbhaController = class OpHubClinicalNotesWithAbhaController {
    constructor(clinicalNotesWithAbhaService) {
        this.clinicalNotesWithAbhaService = clinicalNotesWithAbhaService;
    }
    create(createClinicalNotesWithAbhaDto) {
        return this.clinicalNotesWithAbhaService.create(createClinicalNotesWithAbhaDto);
    }
    findAll(opd_id, hospital_id) {
        return this.clinicalNotesWithAbhaService.findAll(opd_id, hospital_id);
    }
    update(summ) {
        return this.clinicalNotesWithAbhaService.update(summ);
    }
    remove(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delCompBasic(+id, hospital_id);
    }
    remove1(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delCompDetail(+id, hospital_id);
    }
    remove3(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delTreatHis(+id, hospital_id);
    }
    remove4(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delTreatHisDocs(+id, hospital_id);
    }
    remove5(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delTreatmentAdvice(+id, hospital_id);
    }
    remove6(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delDiagReport(+id, hospital_id);
    }
    remove7(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delDietPlan(+id, hospital_id);
    }
    remove8(id, hospital_id) {
        return this.clinicalNotesWithAbhaService.delCompBasic(+id, hospital_id);
    }
};
exports.OpHubClinicalNotesWithAbhaController = OpHubClinicalNotesWithAbhaController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create clinical notes with ABHA' }),
    (0, swagger_1.ApiBody)({ type: op_hub_clinical_notes_with_abha_entity_1.ClinicalNotesWithAbha }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'The clinical note has been successfully created.', type: op_hub_clinical_notes_with_abha_entity_1.postResp }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Bad Request.' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_clinical_notes_with_abha_entity_1.ClinicalNotesWithAbha]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all clinical notes' }),
    (0, swagger_1.ApiQuery)({ name: 'opd_id', required: true, type: Number, description: 'opd_id of the appointment' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully retrieved all clinical notes.', type: op_hub_clinical_notes_with_abha_entity_1.ClinicalNotesResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'No clinical notes found.' }),
    __param(0, (0, common_1.Query)('opd_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "findAll", null);
__decorate([
    (0, common_1.Patch)(),
    (0, swagger_1.ApiOperation)({ summary: 'Update a specific clinical note' }),
    (0, swagger_1.ApiBody)({ type: op_hub_clinical_notes_with_abha_entity_1.UpdateClinicalNotesWithAbha }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully updated the clinical note.', type: op_hub_clinical_notes_with_abha_entity_1.updateResp }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_clinical_notes_with_abha_entity_1.UpdateClinicalNotesWithAbha]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)('/chief-complaint-basic'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the chief complaint basic' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove", null);
__decorate([
    (0, common_1.Delete)('/chief-complaint-detail'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the chief complaint detail' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove1", null);
__decorate([
    (0, common_1.Delete)('/past-treatment-history'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the past treatment history' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove3", null);
__decorate([
    (0, common_1.Delete)('/past-treatment-history-documents'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the past treatment history documents' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove4", null);
__decorate([
    (0, common_1.Delete)('/treatment-advice'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the teeatment advice' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove5", null);
__decorate([
    (0, common_1.Delete)('/diagnosis-report'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the diagnosis report' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove6", null);
__decorate([
    (0, common_1.Delete)('/diet-plan'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the diet plan' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove7", null);
__decorate([
    (0, common_1.Delete)('/follow-up'),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the follow up' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a specific clinical note' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully deleted the clinical note.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Clinical note not found.' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubClinicalNotesWithAbhaController.prototype, "remove8", null);
exports.OpHubClinicalNotesWithAbhaController = OpHubClinicalNotesWithAbhaController = __decorate([
    (0, common_1.Controller)('op-hub-clinical-notes-with-abha'),
    __metadata("design:paramtypes", [op_hub_clinical_notes_with_abha_service_1.OpHubClinicalNotesWithAbhaService])
], OpHubClinicalNotesWithAbhaController);
//# sourceMappingURL=op-hub-clinical-notes-with-abha.controller.js.map