"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubCheckOldPatientService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubCheckOldPatientService = class OpHubCheckOldPatientService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async findAll(Entity) {
        if (Entity.hospital_id) {
            try {
                let query;
                let values = [];
                let getStatus;
                if (Entity.search_by == 'ABHA') {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.ABHA_number = ?`;
                    values.push(Entity.value);
                    getStatus = await this.dynamicConnection.query(query, values);
                }
                else if (Entity.search_by == 'mobile') {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.mobileno = ? or patients.mobileno = ?`;
                    let HosPatientMobileNo = Entity.value;
                    let HosTrimmedMobileno;
                    if (HosPatientMobileNo.length > 10) {
                        HosTrimmedMobileno = HosPatientMobileNo.startsWith('91')
                            ? HosPatientMobileNo.slice(2)
                            : HosPatientMobileNo;
                    }
                    else {
                        HosTrimmedMobileno = '91' + HosPatientMobileNo;
                    }
                    values.push(HosPatientMobileNo, HosTrimmedMobileno);
                    getStatus = await this.connection.query(query, values);
                }
                else if (Entity.search_by == 'patientId') {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.id = ?`;
                    values.push(Entity.value);
                    getStatus = await this.dynamicConnection.query(query, values);
                }
                else {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.mobileno like ? or 
            patients.id like ? or patients.patient_name like ? or patients.abha_address like ? or patients.ABHA_number like ? `;
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    getStatus = await this.connection.query(query, values);
                }
                if (getStatus[0]) {
                    return {
                        status: 'success',
                        message: 'patient details fetched successfully',
                        details: getStatus,
                    };
                }
                else {
                    return {
                        status: 'failed',
                        message: 'no patient details found create new patient',
                        details: [],
                    };
                }
            }
            catch (error) {
                return {
                    status: 'failed',
                    message: 'no patient details found create new patient',
                    error: error,
                };
            }
        }
        else {
            return [
                {
                    status: 'failed',
                    message: 'Enter hospital_id to get appointment status',
                },
            ];
        }
    }
    async findAllV2(Entity, limit, page) {
        const offset = limit * (page - 1);
        if (Entity.hospital_id) {
            try {
                let query;
                let values = [];
                let getStatus;
                if (Entity.search_by == 'ABHA') {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.ABHA_number = ?`;
                    values.push(Entity.value);
                    getStatus = await this.dynamicConnection.query(query, values);
                }
                else if (Entity.search_by == 'mobile') {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.mobileno = ? or patients.mobileno = ?`;
                    let HosPatientMobileNo = Entity.value;
                    let HosTrimmedMobileno;
                    if (HosPatientMobileNo.length > 10) {
                        HosTrimmedMobileno = HosPatientMobileNo.startsWith('91')
                            ? HosPatientMobileNo.slice(2)
                            : HosPatientMobileNo;
                    }
                    else {
                        HosTrimmedMobileno = '91' + HosPatientMobileNo;
                    }
                    values.push(HosPatientMobileNo, HosTrimmedMobileno);
                    getStatus = await this.connection.query(query, values);
                }
                else if (Entity.search_by == 'patientId') {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.id = ?`;
                    values.push(Entity.value);
                    getStatus = await this.dynamicConnection.query(query, values);
                }
                else {
                    query = `select
coalesce(patients.id,"") id ,
        concat("PT",patients.id) plenome_patient_id,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(concat(coalesce(patients.address,"")," ",coalesce(patients.state_name,"")," ",coalesce(patients.district_name,"")," ",coalesce(patients.pincode,"")),"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.mobileno like ? or 
            patients.id like ? or patients.patient_name like ? or patients.abha_address like ? or patients.ABHA_number like ?
             order by patients.created_at DESC
            limit ${limit} offset ${offset}`;
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    values.push('%' + Entity.value + '%');
                    getStatus = await this.connection.query(query, values);
                    for (const a of getStatus) {
                        const [getHosPat_id] = await this.dynamicConnection.query(`select id,ABHA_number from patients where aayush_unique_id = ?`, [a.aayush_unique_id]);
                        a.hos_patient_id = (await getHosPat_id?.id) || '';
                        a.ABHA_number = (await getHosPat_id?.ABHA_number) || '';
                    }
                }
                const searchValue = `%${Entity.value}%`;
                const [getCount] = await this.connection.query(`SELECT COUNT(*) AS total_count 
           FROM patients 
           WHERE patients.mobileno LIKE ? 
              OR patients.id LIKE ? 
              OR patients.patient_name LIKE ? 
              OR patients.abha_address LIKE ? 
              OR patients.ABHA_number LIKE ?`, [searchValue, searchValue, searchValue, searchValue, searchValue]);
                if (getStatus[0]) {
                    return {
                        status: 'success',
                        message: 'patient details fetched successfully',
                        details: getStatus,
                        count: getCount.total_count,
                    };
                }
                else {
                    return {
                        status: 'failed',
                        message: 'no patient details found create new patient',
                        details: [],
                    };
                }
            }
            catch (error) {
                return {
                    status: 'failed',
                    message: 'no patient details found create new patient',
                    error: error,
                };
            }
        }
        else {
            return [
                {
                    status: 'failed',
                    message: 'Enter hospital_id to get appointment status',
                },
            ];
        }
    }
    async findAllV3(Entity, limit, page) {
        const offset = limit * (page - 1);
        if (!Entity.hospital_id) {
            return [
                {
                    status: 'failed',
                    message: 'Enter hospital_id to get appointment status',
                },
            ];
        }
        let query = '';
        if (Entity.value) {
            query = `where patients.patient_name like '%${Entity.value}%' or patients.mobileno like '%${Entity.value}%' or patients.id like '%${Entity.value}%'`;
        }
        const getCount = await this.connection.query(`select count(id) as total_count from patients ${query}`);
        const getPatDetails = await this.connection.query(`select 
      id,patient_name,coalesce(dob,"") dob,coalesce(age,"") age,
      coalesce(image,"") image,mobileno,gender,dial_code,
      aayush_unique_id,is_kyc_verified
      from patients ${query} limit ${limit} offset ${offset}`);
        let out = {
            status: 'success',
            message: 'patient details fetched successfully',
            details: getPatDetails,
            count: getCount[0].total_count,
        };
        return out;
    }
    async hosfindAllV2(Entity, limit, page) {
        const offset = limit * (page - 1);
        if (Entity.hospital_id) {
            try {
                let query;
                let values = [];
                let getStatus;
                query = `select
coalesce(patients.id,"") id ,
concat('PT',patients.id,"") plenome_patient_id ,
coalesce(patients.patient_name,"") patient_name,
coalesce(date(patients.dob),"") dob,
coalesce(patients.age,"") age,
coalesce(patients.month,"") month,
coalesce(patients.day,"") day, 
coalesce(patients.image,"") image,
coalesce(patients.mobileno,"") mobileno,
coalesce(patients.email,"") email,
coalesce(patients.gender,"") gender,
coalesce(patients.marital_status,"") marital_status,
coalesce(patients.blood_group,"") blood_group,
coalesce(patients.address,"") address,
coalesce(patients.guardian_name,"") guardian_name,
coalesce(patients.state_name,"") state_name,
coalesce(patients.district_name,"") district_name,
coalesce(patients.pincode,"") pincode,
coalesce(patients.patient_type,"") patient_type,
coalesce(patients.ABHA_number,"") ABHA_number,
coalesce(patients.known_allergies,"") known_allergies,
coalesce(patients.insurance_id,"") insurance_id,
coalesce(patients.insurance_validity,"") insurance_validity,
coalesce(patients.is_active,"") is_active,
coalesce(patients.aayush_unique_id,"") aayush_unique_id,
coalesce(patients.abha_address,"") abha_address,
coalesce(patients.dial_code,"91") dial_code,
coalesce(patients.salutation,"") salutation,
coalesce(patients.emergency_dial_code,"") emergency_dial_code,
coalesce(patients.emergency_mobile_no,"") emergency_mobile_no,
coalesce(blood_bank_products.name,"") patient_blood_group,
patients.is_kyc_verified
from patients 
            left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id  where patients.mobileno like ? or 
            patients.id like ? or patients.patient_name like ? or patients.abha_address like ? or patients.ABHA_number like ? 
            order by patients.created_at desc
            limit ${limit} offset ${offset}
            `;
                values.push('%' + Entity.value + '%');
                values.push('%' + Entity.value + '%');
                values.push('%' + Entity.value + '%');
                values.push('%' + Entity.value + '%');
                values.push('%' + Entity.value + '%');
                getStatus = await this.dynamicConnection.query(query, values);
                console.log(getStatus);
                for (const list of getStatus) {
                    const [abha_address] = await this.dynamicConnection.query(`SELECT abhaAddress
FROM patient_abha_address
WHERE patient_id = ?
ORDER BY created_at DESC
LIMIT 1`, [list.id]);
                    console.log(abha_address, 'abha_address');
                    list.patient_abha_address = abha_address?.abhaAddress || '';
                }
                const searchValue = `%${Entity.value}%`;
                const [getCount] = await this.dynamicConnection.query(`SELECT COUNT(*) AS total_count 
           FROM patients 
           WHERE patients.mobileno LIKE ? 
              OR patients.id LIKE ? 
              OR patients.patient_name LIKE ? 
              OR patients.abha_address LIKE ? 
              OR patients.ABHA_number LIKE ?`, [searchValue, searchValue, searchValue, searchValue, searchValue]);
                if (getStatus[0]) {
                    return {
                        status: 'success',
                        message: 'patient details fetched successfully',
                        details: getStatus,
                        count: getCount.total_count,
                    };
                }
                else {
                    return {
                        status: 'failed',
                        message: 'no patient details found create new patient',
                        details: [],
                    };
                }
            }
            catch (error) {
                console.log(error, 'err');
                return {
                    status: 'failed',
                    message: 'no patient details found create new patient',
                    error: error,
                };
            }
        }
        else {
            return [
                {
                    status: 'failed',
                    message: 'Enter hospital_id to get appointment status',
                },
            ];
        }
    }
    async hosfindAllV3(Entity, limit, page) {
        const offset = limit * (page - 1);
        if (!Entity.hospital_id) {
            return [
                {
                    status: 'failed',
                    message: 'Enter hospital_id to get appointment status',
                },
            ];
        }
        let query = '';
        if (Entity.value) {
            query = `where patients.patient_name like '%${Entity.value}%' or patients.mobileno like '%${Entity.value}%' or patients.id like '%${Entity.value}%'`;
        }
        const getCount = await this.dynamicConnection.query(`select count(id) as total_count from patients ${query}`);
        const getPatDetails = await this.dynamicConnection.query(`select 
      id,patient_name,coalesce(dob,"") dob,coalesce(age,"") age,
      coalesce(image,"") image,mobileno,gender,dial_code,
      aayush_unique_id,is_kyc_verified
      from patients ${query} limit ${limit} offset ${offset}`);
        for (const list of getPatDetails) {
            const [abha_address] = await this.dynamicConnection.query(`SELECT abhaAddress
FROM patient_abha_address
WHERE patient_id = ?
ORDER BY created_at DESC
LIMIT 1`, [list.id]);
            list.patient_abha_address = abha_address || '';
        }
        let out = {
            status: 'success',
            message: 'patient details fetched successfully',
            details: getPatDetails,
            count: getCount[0].total_count,
        };
        return out;
    }
};
exports.OpHubCheckOldPatientService = OpHubCheckOldPatientService;
exports.OpHubCheckOldPatientService = OpHubCheckOldPatientService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubCheckOldPatientService);
//# sourceMappingURL=op-hub-check-old-patient.service.js.map