"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubCheckForDuplicateAppointmentService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubCheckForDuplicateAppointmentService = class OpHubCheckForDuplicateAppointmentService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(AppointmentEntity) {
        if (AppointmentEntity.Hospital_id) {
            try {
                const checkDuplicate = await this.dynamicConnection.query(`select * from appointment 
      where patient_id = ? and doctor = ? and shift_id = ? and date = ? and appointment_status_id <> 4`, [
                    AppointmentEntity.patient_id,
                    AppointmentEntity.doctor,
                    AppointmentEntity.shift_id,
                    AppointmentEntity.date
                ]);
                if (checkDuplicate.length > 0) {
                    return {
                        "status": "succes",
                        "message": "cannot book duplicate appointment",
                        "is_duplicate_appointment": true
                    };
                }
                else {
                    return {
                        "status": "succes",
                        "message": "can book appointment",
                        "is_duplicate_appointment": false
                    };
                }
            }
            catch (error) {
                return {
                    "status": "failed",
                    "message": "unable to check duplicate appointment",
                    "error": error
                };
            }
        }
        else {
            return {
                "status": "failed",
                "message": "Enter Hospital_id to check duplicate appointment"
            };
        }
    }
};
exports.OpHubCheckForDuplicateAppointmentService = OpHubCheckForDuplicateAppointmentService;
exports.OpHubCheckForDuplicateAppointmentService = OpHubCheckForDuplicateAppointmentService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubCheckForDuplicateAppointmentService);
//# sourceMappingURL=op-hub-check-for-duplicate-appointment.service.js.map