"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubBundleGenerationController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_bundle_generation_service_1 = require("./op-hub-bundle-generation.service");
const update_op_hub_bundle_generation_dto_1 = require("./dto/update-op-hub-bundle-generation.dto");
let OpHubBundleGenerationController = class OpHubBundleGenerationController {
    constructor(opHubBundleGenerationService) {
        this.opHubBundleGenerationService = opHubBundleGenerationService;
    }
    create(followupDetails, other_observations, Lifestyle, women_health, generalAssment, physicalActivity, vitalDetails, body_measurement, hospital_id, opd_id, abhaAddress) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.create(followupDetails, other_observations, Lifestyle, women_health, generalAssment, physicalActivity, vitalDetails, body_measurement, hospital_id, opd_id, abhaAddress);
    }
    createDischargeSummary(followupDetails, clinicalPresentation, investigationsPerformed, treatment_given, condition_at_discharge, discharge_advice, hospital_id, opd_id, abhaAddress) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.createDischargeSummary(followupDetails, clinicalPresentation, investigationsPerformed, treatment_given, condition_at_discharge, discharge_advice, hospital_id, opd_id, abhaAddress);
    }
    createPrescription(prescriptionDetails, hospital_id, opd_id, abhaAddress) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.createPrescription(prescriptionDetails, hospital_id, opd_id, abhaAddress);
    }
    createImmunization(immunizationDetails, hospital_id, opd_id, abhaAddress) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.createImmunization(immunizationDetails, hospital_id, opd_id, abhaAddress);
    }
    createlabResults(labResults, hospital_id, opd_id, abhaAddress) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.createLabresults(labResults, hospital_id, opd_id, abhaAddress);
    }
    createinvoiceDetails(invoiceDetails, hospital_id, opd_id, abhaAddress) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.createInvoice(invoiceDetails, hospital_id, opd_id, abhaAddress);
    }
    createOpConsultation(chiefComplaintsBasic, getPastTreatHis, followupDetails, file, hospital_id, opd_id, abhaAddress, diet_plan, treatmentAdvice) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        if (!file) {
            return {
                message: 'filename is required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.createOpConsultation(chiefComplaintsBasic, getPastTreatHis, followupDetails, hospital_id, opd_id, file, abhaAddress, diet_plan, treatmentAdvice);
    }
    createDiagnosisReport(prescriptionDetails, hospital_id, opd_id, abhaAddress) {
        if (!hospital_id || !opd_id) {
            return {
                message: 'hospital_id and opd_id are required',
                status: 'failed',
                statusCode: 400,
            };
        }
        return this.opHubBundleGenerationService.createDiagnosis(prescriptionDetails, hospital_id, opd_id, abhaAddress);
    }
    findOne(id) {
        return this.opHubBundleGenerationService.findOne(+id);
    }
    update(id, updateOpHubBundleGenerationDto) {
        return this.opHubBundleGenerationService.update(+id, updateOpHubBundleGenerationDto);
    }
    remove(id) {
        return this.opHubBundleGenerationService.remove(+id);
    }
};
exports.OpHubBundleGenerationController = OpHubBundleGenerationController;
__decorate([
    (0, common_1.Post)('/wellness'),
    __param(0, (0, common_1.Body)('followupDetails')),
    __param(1, (0, common_1.Body)('other_observations')),
    __param(2, (0, common_1.Body)('Lifestyle')),
    __param(3, (0, common_1.Body)('women_health')),
    __param(4, (0, common_1.Body)('generalAssment')),
    __param(5, (0, common_1.Body)('physicalActivity')),
    __param(6, (0, common_1.Body)('vitalDetails')),
    __param(7, (0, common_1.Body)('body_measurement')),
    __param(8, (0, common_1.Body)('hospital_id')),
    __param(9, (0, common_1.Body)('opd_id')),
    __param(10, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Object, Object, Number, Number, String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('/discharge_summary'),
    __param(0, (0, common_1.Body)('followupDetails')),
    __param(1, (0, common_1.Body)('clinicalPresentation')),
    __param(2, (0, common_1.Body)('investigationsPerformed')),
    __param(3, (0, common_1.Body)('treatment_given')),
    __param(4, (0, common_1.Body)('condition_at_discharge')),
    __param(5, (0, common_1.Body)('discharge_advice')),
    __param(6, (0, common_1.Body)('hospital_id')),
    __param(7, (0, common_1.Body)('opd_id')),
    __param(8, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Number, Number, String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "createDischargeSummary", null);
__decorate([
    (0, common_1.Post)('/prescription'),
    __param(0, (0, common_1.Body)('prescriptionDetails')),
    __param(1, (0, common_1.Body)('hospital_id')),
    __param(2, (0, common_1.Body)('opd_id')),
    __param(3, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number, Number, String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "createPrescription", null);
__decorate([
    (0, common_1.Post)('/immunization'),
    __param(0, (0, common_1.Body)('immunizationDetails')),
    __param(1, (0, common_1.Body)('hospital_id')),
    __param(2, (0, common_1.Body)('opd_id')),
    __param(3, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number, Number, String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "createImmunization", null);
__decorate([
    (0, common_1.Post)('/labresults'),
    __param(0, (0, common_1.Body)('labResults')),
    __param(1, (0, common_1.Body)('hospital_id')),
    __param(2, (0, common_1.Body)('opd_id')),
    __param(3, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number, Number, String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "createlabResults", null);
__decorate([
    (0, common_1.Post)('/invoiceDetails'),
    __param(0, (0, common_1.Body)('invoiceDetails')),
    __param(1, (0, common_1.Body)('hospital_id')),
    __param(2, (0, common_1.Body)('opd_id')),
    __param(3, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number, Number, String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "createinvoiceDetails", null);
__decorate([
    (0, common_1.Post)('/opConsultation'),
    __param(0, (0, common_1.Body)('chiefComplaintsBasic')),
    __param(1, (0, common_1.Body)('getPastTreatHis')),
    __param(2, (0, common_1.Body)('followupDetails')),
    __param(3, (0, common_1.Body)('filename')),
    __param(4, (0, common_1.Body)('hospital_id')),
    __param(5, (0, common_1.Body)('opd_id')),
    __param(6, (0, common_1.Body)('abhaAddress')),
    __param(7, (0, common_1.Body)('diet_plan')),
    __param(8, (0, common_1.Body)('treatmentAdvice')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Number, Number, String, Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "createOpConsultation", null);
__decorate([
    (0, common_1.Post)('/diagnosis_report'),
    __param(0, (0, common_1.Body)('diagnosisDetails')),
    __param(1, (0, common_1.Body)('hospital_id')),
    __param(2, (0, common_1.Body)('opd_id')),
    __param(3, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number, Number, String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "createDiagnosisReport", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_op_hub_bundle_generation_dto_1.UpdateOpHubBundleGenerationDto]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OpHubBundleGenerationController.prototype, "remove", null);
exports.OpHubBundleGenerationController = OpHubBundleGenerationController = __decorate([
    (0, common_1.Controller)('op-hub-bundle-generation'),
    __metadata("design:paramtypes", [op_hub_bundle_generation_service_1.OpHubBundleGenerationService])
], OpHubBundleGenerationController);
//# sourceMappingURL=op-hub-bundle-generation.controller.js.map