import { EventEmitter2 } from '@nestjs/event-emitter';
import { DataSource } from 'typeorm';
import { AddCharge, makepayment, makepaymentV3, UpdateCharge } from './entities/op-hub-billing.entity';
import { PatientBalanceDtoWithCount } from './dto/create-op-hub-billing.dto';
import { PatientTransactionDtoWithCount } from './dto/update-op-hub-billing.dto';
export declare class OpHubBillingService {
    private readonly dynamicConnection;
    private readonly connection;
    private readonly eventEmitter;
    constructor(dynamicConnection: DataSource, connection: DataSource, eventEmitter: EventEmitter2);
    create(Entity: AddCharge): Promise<any>;
    findAll(hospital_id: number, from_date: any, to_date: any, patient_id: any, payment_method: any, date: any): Promise<any>;
    getInvoice(transactionId: string, hospitalId: number): Promise<any>;
    private parseTransactionId;
    private getPaymentQuery;
    private getHospitalQuery;
    private getInvoiceQuery;
    private attachTempAppointmentPayment;
    findonePatCharge(hospital_id: number, pat_charge_id: any): Promise<any>;
    findOne(patient_id: number, hospital_id: number, filter?: string): Promise<any>;
    findpending(hospital_id: number): Promise<any>;
    findChargeType(hospital_id: number): Promise<any>;
    findChargeCategory(hospital_id: number, charge_type_id: any): Promise<any>;
    findChargeName(hospital_id: number, charge_category_id: any): Promise<any>;
    findChargeDetails(id: any, hospital_id: number): Promise<any>;
    makePayment(Entity: makepayment): Promise<any>;
    update(id: number, Entity: UpdateCharge): Promise<any>;
    findpendingV2(limit: number, page: number): Promise<PatientBalanceDtoWithCount>;
    findAllV2(from_date: any, to_date: any, patient_id: any, payment_method: any, date: any, limit: number, page: number): Promise<PatientTransactionDtoWithCount>;
    getpendingApptofPat(patient_id: number): Promise<any>;
    makePaymentV2(Entity: makepayment): Promise<any>;
    createV2(Entity: AddCharge): Promise<any>;
    findOnev2(patient_id: number, hospital_id: number, filter?: string): Promise<any>;
    findpendingV3(limit: number, page: number): Promise<any>;
    findAllV3(from_date: any, to_date: any, patient_id: any, payment_method: any, date: any, limit: number, page: number): Promise<PatientTransactionDtoWithCount>;
    makePaymentV3(Entity: makepaymentV3): Promise<any>;
}
