"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubBillingController = exports.GetPatientChargeResponse = exports.UpdateChargeResponse = exports.FindAllResponse = exports.PaymentResponse = exports.CreateBillingResponse = exports.InvoiceResponse = exports.InvoiceDetail = exports.HospitalDetails = exports.PatientDetails = exports.FindOneResponse = exports.FindAllPendingResponse = exports.ChargeTypeDto = exports.ChargeCategoryDto = exports.ChargeNameDto = exports.ChargeDetailsDto = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_entity_1 = require("../op-hub-appointment/entities/op-hub-appointment.entity");
const op_hub_billing_entity_1 = require("./entities/op-hub-billing.entity");
const op_hub_billing_service_1 = require("./op-hub-billing.service");
class ChargeDetailsDto {
}
exports.ChargeDetailsDto = ChargeDetailsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 156 }),
    __metadata("design:type", Number)
], ChargeDetailsDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'one' }),
    __metadata("design:type", String)
], ChargeDetailsDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'yyyy' }),
    __metadata("design:type", String)
], ChargeDetailsDto.prototype, "chargeCategoryName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 67 }),
    __metadata("design:type", Number)
], ChargeDetailsDto.prototype, "chargeCategoryId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'OPD' }),
    __metadata("design:type", String)
], ChargeDetailsDto.prototype, "chargeTypeName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 130 }),
    __metadata("design:type", Number)
], ChargeDetailsDto.prototype, "chargeTypeId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 90 }),
    __metadata("design:type", Number)
], ChargeDetailsDto.prototype, "standard_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 12 }),
    __metadata("design:type", Number)
], ChargeDetailsDto.prototype, "taxPercentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 10.8 }),
    __metadata("design:type", Number)
], ChargeDetailsDto.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 100.8 }),
    __metadata("design:type", Number)
], ChargeDetailsDto.prototype, "totalAmount", void 0);
class ChargeNameDto {
}
exports.ChargeNameDto = ChargeNameDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], ChargeNameDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], ChargeNameDto.prototype, "charge_type_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Appointment Charge Cate' }),
    __metadata("design:type", String)
], ChargeNameDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Appointment Charge Cate' }),
    __metadata("design:type", String)
], ChargeNameDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null }),
    __metadata("design:type", String)
], ChargeNameDto.prototype, "short_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'yes' }),
    __metadata("design:type", String)
], ChargeNameDto.prototype, "is_default", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null }),
    __metadata("design:type", Date)
], ChargeNameDto.prototype, "created_at", void 0);
class ChargeCategoryDto {
}
exports.ChargeCategoryDto = ChargeCategoryDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], ChargeCategoryDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], ChargeCategoryDto.prototype, "charge_category_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], ChargeCategoryDto.prototype, "tax_category_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], ChargeCategoryDto.prototype, "charge_unit_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Doctor Fee' }),
    __metadata("design:type", String)
], ChargeCategoryDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 700 }),
    __metadata("design:type", Number)
], ChargeCategoryDto.prototype, "standard_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-06-14T00:00:00.000Z', nullable: true }),
    __metadata("design:type", String)
], ChargeCategoryDto.prototype, "date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Doctor Fee' }),
    __metadata("design:type", String)
], ChargeCategoryDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'nothing' }),
    __metadata("design:type", String)
], ChargeCategoryDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-06-14T06:59:50.000Z' }),
    __metadata("design:type", String)
], ChargeCategoryDto.prototype, "created_at", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '9.00' }),
    __metadata("design:type", String)
], ChargeCategoryDto.prototype, "taxPercentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 63 }),
    __metadata("design:type", Number)
], ChargeCategoryDto.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 763 }),
    __metadata("design:type", Number)
], ChargeCategoryDto.prototype, "totalAmount", void 0);
class ChargeTypeDto {
}
exports.ChargeTypeDto = ChargeTypeDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], ChargeTypeDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], ChargeTypeDto.prototype, "charge_type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], ChargeTypeDto.prototype, "is_default", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], ChargeTypeDto.prototype, "is_active", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], ChargeTypeDto.prototype, "created_at", void 0);
class PatientDetaila {
}
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetaila.prototype, "patient_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetaila.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetaila.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetaila.prototype, "mobileno", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetaila.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetaila.prototype, "id", void 0);
class PendingDetails {
}
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetails.prototype, "patient_charge_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetails.prototype, "date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetails.prototype, "section", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetails.prototype, "section_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetails.prototype, "chargeDescription", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetails.prototype, "qty", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetails.prototype, "charges", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetails.prototype, "taxPercentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetails.prototype, "total", void 0);
class FindAllPendingResponse {
}
exports.FindAllPendingResponse = FindAllPendingResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [PatientDetaila] }),
    __metadata("design:type", Array)
], FindAllPendingResponse.prototype, "patientDetails", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [PendingDetails] }),
    __metadata("design:type", Array)
], FindAllPendingResponse.prototype, "pendingDetails", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], FindAllPendingResponse.prototype, "totalDue", void 0);
class PatientDetail {
}
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetail.prototype, "patient_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetail.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetail.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetail.prototype, "mobileno", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetail.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetail.prototype, "id", void 0);
class PendingDetail {
}
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetail.prototype, "patient_charge_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetail.prototype, "date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetail.prototype, "section", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetail.prototype, "section_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PendingDetail.prototype, "chargeDescription", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetail.prototype, "qty", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetail.prototype, "charges", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetail.prototype, "taxPercentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PendingDetail.prototype, "total", void 0);
class FindOneResponse {
}
exports.FindOneResponse = FindOneResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [PatientDetail] }),
    __metadata("design:type", Array)
], FindOneResponse.prototype, "patientDetails", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [PendingDetail] }),
    __metadata("design:type", Array)
], FindOneResponse.prototype, "pendingDetails", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], FindOneResponse.prototype, "totalDue", void 0);
class PatientDetails {
}
exports.PatientDetails = PatientDetails;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetails.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetails.prototype, "lang_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "patient_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "dob", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetails.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", Number)
], PatientDetails.prototype, "month", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", Number)
], PatientDetails.prototype, "day", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "image", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "mobileno", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "marital_status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "blood_group", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], PatientDetails.prototype, "blood_bank_product_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "address", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "guardian_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "patient_type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "ABHA_number", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "known_allergies", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "note", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "is_ipd", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "app_key", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "insurance_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "insurance_validity", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "is_dead", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "is_active", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "disable_at", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "created_at", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "pincode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "state_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "district_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "emergency_mobile_no", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "dial_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "salutation", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "emergency_dial_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "state_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], PatientDetails.prototype, "district_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], PatientDetails.prototype, "aayush_unique_id", void 0);
class HospitalDetails {
}
exports.HospitalDetails = HospitalDetails;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], HospitalDetails.prototype, "hospital_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], HospitalDetails.prototype, "contact_no", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], HospitalDetails.prototype, "address", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], HospitalDetails.prototype, "website", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true }),
    __metadata("design:type", String)
], HospitalDetails.prototype, "email", void 0);
class InvoiceDetail {
}
exports.InvoiceDetail = InvoiceDetail;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "qty", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "standard_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "taxPercentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "additional_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "discount_amount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "discount_percentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceDetail.prototype, "total", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], InvoiceDetail.prototype, "chargeName", void 0);
class InvoiceResponse {
}
exports.InvoiceResponse = InvoiceResponse;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], InvoiceResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], InvoiceResponse.prototype, "messege", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: PatientDetails }),
    __metadata("design:type", PatientDetails)
], InvoiceResponse.prototype, "patientDetails", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: HospitalDetails }),
    __metadata("design:type", HospitalDetails)
], InvoiceResponse.prototype, "hospitalDetails", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [InvoiceDetail] }),
    __metadata("design:type", Array)
], InvoiceResponse.prototype, "invoiceDetails", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], InvoiceResponse.prototype, "total", void 0);
class CreateBillingResponse {
}
exports.CreateBillingResponse = CreateBillingResponse;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Indicates the status of the operation',
        example: 'success',
    }),
    __metadata("design:type", String)
], CreateBillingResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Message detailing the result of the operation',
        example: 'charges added successfully.',
    }),
    __metadata("design:type", String)
], CreateBillingResponse.prototype, "message", void 0);
class PaymentResponse {
}
exports.PaymentResponse = PaymentResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], PaymentResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'payment done successfully' }),
    __metadata("design:type", String)
], PaymentResponse.prototype, "message", void 0);
class PaymentDetail {
}
__decorate([
    (0, swagger_1.ApiProperty)({ example: 3 }),
    __metadata("design:type", Number)
], PaymentDetail.prototype, "patientId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Elakkiya S' }),
    __metadata("design:type", String)
], PaymentDetail.prototype, "patient_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'TRID252' }),
    __metadata("design:type", String)
], PaymentDetail.prototype, "transaction_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-06-05' }),
    __metadata("design:type", String)
], PaymentDetail.prototype, "payment_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'cash' }),
    __metadata("design:type", String)
], PaymentDetail.prototype, "payment_mode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 13574.6 }),
    __metadata("design:type", Number)
], PaymentDetail.prototype, "amount", void 0);
class FindAllResponse {
}
exports.FindAllResponse = FindAllResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], FindAllResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'details fetched successfully.' }),
    __metadata("design:type", String)
], FindAllResponse.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [PaymentDetail] }),
    __metadata("design:type", Array)
], FindAllResponse.prototype, "details", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 2 }),
    __metadata("design:type", Number)
], FindAllResponse.prototype, "count", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 13574.6 }),
    __metadata("design:type", Number)
], FindAllResponse.prototype, "overallTotal", void 0);
class UpdateChargeResponse {
}
exports.UpdateChargeResponse = UpdateChargeResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], UpdateChargeResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'charges updated successfully.' }),
    __metadata("design:type", String)
], UpdateChargeResponse.prototype, "message", void 0);
class PatientChargeDetails {
}
__decorate([
    (0, swagger_1.ApiProperty)({ example: 58 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "patientCharge_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 200 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "standard_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 12 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "tax", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 24 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 0 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "discount_amount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 0 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "discount_percentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 0 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "additional_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null }),
    __metadata("design:type", String)
], PatientChargeDetails.prototype, "additional_charge_note", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "qty", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'charge_for_appointment' }),
    __metadata("design:type", String)
], PatientChargeDetails.prototype, "chargeName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 194 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "chargeId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'charge_category_appointment' }),
    __metadata("design:type", String)
], PatientChargeDetails.prototype, "chargeCategoryName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 139 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "chargeCategoryId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'charge_type_2024' }),
    __metadata("design:type", String)
], PatientChargeDetails.prototype, "chargeTypeName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 181 }),
    __metadata("design:type", Number)
], PatientChargeDetails.prototype, "chargeTypeId", void 0);
class GetPatientChargeResponse {
}
exports.GetPatientChargeResponse = GetPatientChargeResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], GetPatientChargeResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Details fetched successfully' }),
    __metadata("design:type", String)
], GetPatientChargeResponse.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: PatientChargeDetails }),
    __metadata("design:type", PatientChargeDetails)
], GetPatientChargeResponse.prototype, "details", void 0);
let OpHubBillingController = class OpHubBillingController {
    constructor(billingService) {
        this.billingService = billingService;
    }
    create(createBillingDto) {
        return this.billingService.create(createBillingDto);
    }
    createAdditional(hospital_id, patient_charge_id) {
        return this.billingService.findonePatCharge(hospital_id, patient_charge_id);
    }
    makePayment(createBillingDto) {
        if (!createBillingDto.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
            };
        }
        return this.billingService.makePayment(createBillingDto);
    }
    findAll(hospital_id, from_date, to_date, patient_id, payment_method, date) {
        if (hospital_id && (date || from_date || to_date)) {
            return this.billingService.findAll(hospital_id, from_date, to_date, patient_id, payment_method, date);
        }
        return {
            status: 'failed',
            message: 'enter hospital_id and date',
        };
    }
    findinvoice(hospital_id, transaction_id) {
        return this.billingService.getInvoice(transaction_id, hospital_id);
    }
    findOne(patient_id, hospital_id, filter) {
        return this.billingService.findOne(patient_id, hospital_id, filter);
    }
    findAllPending(hospital_id) {
        return this.billingService.findpending(hospital_id);
    }
    findchargeType(hospital_id) {
        return this.billingService.findChargeType(hospital_id);
    }
    findchargeCategory(hospital_id, charge_type_id) {
        return this.billingService.findChargeCategory(hospital_id, charge_type_id);
    }
    findchargeName(hospital_id, charge_category_id) {
        return this.billingService.findChargeName(hospital_id, charge_category_id);
    }
    findchargeDetails(id, hospital_id) {
        return this.billingService.findChargeDetails(id, hospital_id);
    }
    update(id, updateBillingDto) {
        return this.billingService.update(+id, updateBillingDto);
    }
    async findAllPendingV2(limit, page) {
        try {
            let final_out = await this.billingService.findpendingV2(limit || 10, page || 1);
            if (final_out?.PendingList.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.PendingList,
                    totalCount: final_out.Count,
                    totalAmount: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllV2(from_date, to_date, patient_id, payment_method, date, limit, page) {
        if (date || from_date || to_date) {
            try {
                let final_out = await this.billingService.findAllV2(from_date, to_date, patient_id, payment_method, date, limit || 10, page || 1);
                if (final_out?.details.length > 0) {
                    return {
                        status_code: process.env.SUCCESS_STATUS_CODE_V2,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.SUCCESS_MESSAGE_V2,
                        data: final_out.details,
                        totalCount: final_out.Totalcount,
                        totalAmount: final_out.TotalAmount,
                    };
                }
                else {
                    return {
                        status_code: process.env.SUCCESS_STATUS_CODE_V2,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.DATA_NOT_FOUND_V2,
                        data: [],
                    };
                }
            }
            catch (error) {
                return {
                    status_code: process.env.ERROR_STATUS_CODE_V2,
                    status: process.env.ERROR_STATUS_V2,
                    message: process.env.ERROR_MESSAGE_V2,
                };
            }
        }
        return {
            status: 'failed',
            message: 'enter hospital_id and date',
        };
    }
    async getOnePatChargeV2(patient_id) {
        if (!patient_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        try {
            let final_out = await this.billingService.getpendingApptofPat(patient_id);
            if (final_out?.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    makePaymentV2(createBillingDto) {
        if (!createBillingDto.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
            };
        }
        if (!createBillingDto.paymentDetails) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.billingService.makePaymentV2(createBillingDto);
    }
    createV2(createBillingDto) {
        try {
            if (!createBillingDto.Hospital_id ||
                !createBillingDto.patient_id ||
                !createBillingDto.sectionID) {
                return {
                    status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                    status: process.env.ERROR_STATUS,
                    message: process.env.ERROR_MESSAGE_PARAM_MISSING,
                };
            }
            return this.billingService.createV2(createBillingDto);
        }
        catch (error) {
            console.log(error, 'error');
        }
    }
    findOnev2(patient_id, hospital_id, filter) {
        if (!filter) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.billingService.findOnev2(patient_id, hospital_id, filter);
    }
    async findAllPendingV3(limit, page) {
        try {
            let final_out = await this.billingService.findpendingV3(limit || 10, page || 1);
            if (final_out?.PendingList.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.PendingList,
                    totalCount: final_out.Count,
                    totalAmount: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllV3(from_date, to_date, patient_id, payment_method, date, limit, page) {
        if (date || from_date || to_date) {
            try {
                let final_out = await this.billingService.findAllV3(from_date, to_date, patient_id, payment_method, date, limit || 10, page || 1);
                if (final_out?.details.length > 0) {
                    return {
                        status_code: process.env.SUCCESS_STATUS_CODE_V2,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.SUCCESS_MESSAGE_V2,
                        data: final_out.details,
                        totalCount: final_out.Totalcount,
                        totalAmount: final_out.TotalAmount,
                    };
                }
                else {
                    return {
                        status_code: process.env.SUCCESS_STATUS_CODE_V2,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.DATA_NOT_FOUND_V2,
                        data: [],
                    };
                }
            }
            catch (error) {
                return {
                    status_code: process.env.ERROR_STATUS_CODE_V2,
                    status: process.env.ERROR_STATUS_V2,
                    message: process.env.ERROR_MESSAGE_V2,
                };
            }
        }
        return {
            status: 'failed',
            message: 'enter hospital_id and date',
        };
    }
    makePaymentV3(createBillingDto) {
        if (!createBillingDto.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
            };
        }
        if (!createBillingDto.paymentDetails) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (!createBillingDto.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createBillingDto.payment_mode.toLocaleLowerCase() == 'card' &&
            !createBillingDto.card_division &&
            !createBillingDto.card_bank_name &&
            !createBillingDto.card_type &&
            !createBillingDto.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createBillingDto.payment_mode.toLocaleLowerCase() == 'net_banking' &&
            !createBillingDto.net_banking_division &&
            !createBillingDto.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createBillingDto.payment_mode.toLocaleLowerCase() == 'upi' &&
            !createBillingDto.upi_id &&
            !createBillingDto.upi_transaction_id &&
            !createBillingDto.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.billingService.makePaymentV3(createBillingDto);
    }
};
exports.OpHubBillingController = OpHubBillingController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new billing charge' }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'Charges added successfully.',
        type: CreateBillingResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_billing_entity_1.AddCharge]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('/getOnePatCharge'),
    (0, swagger_1.ApiOperation)({ summary: 'Fetch details of a specific patient charge' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Details fetched successfully.',
        type: GetPatientChargeResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('patient_charge_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "createAdditional", null);
__decorate([
    (0, common_1.Post)('/makePayment'),
    (0, swagger_1.ApiOperation)({ summary: 'Make a payment for a patient' }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'Payment made successfully.',
        type: PaymentResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_billing_entity_1.makepayment]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "makePayment", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Fetch billing details based on query parameters' }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'from_date',
        required: false,
        type: String,
        description: 'Start date for filtering',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'to_date',
        required: false,
        type: String,
        description: 'End date for filtering',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'patient_id',
        required: false,
        type: Number,
        description: 'ID of the patient',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'payment_method',
        required: false,
        type: String,
        description: 'Method of payment',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'date',
        required: false,
        type: String,
        description: 'Specific date for filtering',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Details fetched successfully.',
        type: FindAllResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('from_date')),
    __param(2, (0, common_1.Query)('to_date')),
    __param(3, (0, common_1.Query)('patient_id')),
    __param(4, (0, common_1.Query)('payment_method')),
    __param(5, (0, common_1.Query)('date')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object, Object, Object, Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('/getInvoice'),
    (0, swagger_1.ApiOperation)({
        summary: 'Fetch invoice details by transaction ID and hospital ID',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'transaction_id',
        required: true,
        type: String,
        description: 'Transaction ID of the invoice',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Invoice details fetched successfully.',
        type: InvoiceResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('transaction_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findinvoice", null);
__decorate([
    (0, common_1.Get)('/individualpending'),
    (0, swagger_1.ApiOperation)({
        summary: 'Fetch pending billing details for a specific patient and hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'patient_id',
        required: true,
        type: Number,
        description: 'ID of the patient',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Pending billing details fetched successfully.',
        type: FindOneResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __param(2, (0, common_1.Query)('filter')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findOne", null);
__decorate([
    (0, common_1.Get)('/pending'),
    (0, swagger_1.ApiOperation)({
        summary: 'Fetch all pending billing details for a specific hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Pending billing details fetched successfully.',
        type: FindAllPendingResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findAllPending", null);
__decorate([
    (0, common_1.Get)('/chargeType'),
    (0, swagger_1.ApiOperation)({ summary: 'Fetch all charge types for a specific hospital' }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Charge types fetched successfully.',
        type: [ChargeTypeDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findchargeType", null);
__decorate([
    (0, common_1.Get)('/chargeCategory'),
    (0, swagger_1.ApiOperation)({ summary: 'Find charge categories' }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        example: '1',
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'charge_type_id',
        required: true,
        example: '2',
        description: 'ID of the charge type',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'The charge categories have been successfully retrieved.',
        type: ChargeNameDto,
        isArray: true,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('charge_type_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findchargeCategory", null);
__decorate([
    (0, common_1.Get)('/chargeName'),
    (0, swagger_1.ApiOperation)({ summary: 'Find charge names by hospital and category' }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        example: '1',
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'charge_category_id',
        required: true,
        example: '1',
        description: 'ID of the charge category',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'The charge names have been successfully retrieved.',
        type: ChargeCategoryDto,
        isArray: true,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('charge_category_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findchargeName", null);
__decorate([
    (0, common_1.Get)('/chargeName/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get Charge Details by ID' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Charge details retrieved successfully',
        type: ChargeDetailsDto,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findchargeDetails", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update charges for a specific billing entry' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Charges updated successfully.',
        type: UpdateChargeResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, op_hub_billing_entity_1.UpdateCharge]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "update", null);
__decorate([
    (0, common_1.Get)('/pending/v2'),
    (0, swagger_1.ApiOperation)({
        summary: 'Fetch all pending billing details for a specific hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Pending billing details fetched successfully.',
        type: FindAllPendingResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], OpHubBillingController.prototype, "findAllPendingV2", null);
__decorate([
    (0, common_1.Get)('/v2/paid'),
    (0, swagger_1.ApiOperation)({ summary: 'Fetch billing details based on query parameters' }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'from_date',
        required: false,
        type: String,
        description: 'Start date for filtering',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'to_date',
        required: false,
        type: String,
        description: 'End date for filtering',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'patient_id',
        required: false,
        type: Number,
        description: 'ID of the patient',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'payment_method',
        required: false,
        type: String,
        description: 'Method of payment',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'date',
        required: false,
        type: String,
        description: 'Specific date for filtering',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Details fetched successfully.',
        type: FindAllResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('from_date')),
    __param(1, (0, common_1.Query)('to_date')),
    __param(2, (0, common_1.Query)('patient_id')),
    __param(3, (0, common_1.Query)('payment_method')),
    __param(4, (0, common_1.Query)('date')),
    __param(5, (0, common_1.Query)('limit')),
    __param(6, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Object]),
    __metadata("design:returntype", Promise)
], OpHubBillingController.prototype, "findAllV2", null);
__decorate([
    (0, common_1.Get)('v2/getPendingSectionList'),
    __param(0, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], OpHubBillingController.prototype, "getOnePatChargeV2", null);
__decorate([
    (0, common_1.Post)('/makePayment/v2'),
    (0, swagger_1.ApiOperation)({ summary: 'Make a payment for a patient' }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'Payment made successfully.',
        type: PaymentResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_billing_entity_1.makepayment]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "makePaymentV2", null);
__decorate([
    (0, common_1.Post)('/v2/addCharge'),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new billing charge' }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'Charges added successfully.',
        type: CreateBillingResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_billing_entity_1.AddCharge]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "createV2", null);
__decorate([
    (0, common_1.Get)('/individualpending/bySectionId'),
    (0, swagger_1.ApiOperation)({
        summary: 'Fetch pending billing details for a specific patient and hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'patient_id',
        required: true,
        type: Number,
        description: 'ID of the patient',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Pending billing details fetched successfully.',
        type: FindOneResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __param(2, (0, common_1.Query)('sectionId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, String]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "findOnev2", null);
__decorate([
    (0, common_1.Get)('/pending/v3'),
    (0, swagger_1.ApiOperation)({
        summary: 'Fetch all pending billing details for a specific hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Pending billing details fetched successfully.',
        type: FindAllPendingResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], OpHubBillingController.prototype, "findAllPendingV3", null);
__decorate([
    (0, common_1.Get)('/v3/paid'),
    (0, swagger_1.ApiOperation)({ summary: 'Fetch billing details based on query parameters' }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        type: Number,
        description: 'ID of the hospital',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'from_date',
        required: false,
        type: String,
        description: 'Start date for filtering',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'to_date',
        required: false,
        type: String,
        description: 'End date for filtering',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'patient_id',
        required: false,
        type: Number,
        description: 'ID of the patient',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'payment_method',
        required: false,
        type: String,
        description: 'Method of payment',
    }),
    (0, swagger_1.ApiQuery)({
        name: 'date',
        required: false,
        type: String,
        description: 'Specific date for filtering',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Details fetched successfully.',
        type: FindAllResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('from_date')),
    __param(1, (0, common_1.Query)('to_date')),
    __param(2, (0, common_1.Query)('patient_id')),
    __param(3, (0, common_1.Query)('payment_method')),
    __param(4, (0, common_1.Query)('date')),
    __param(5, (0, common_1.Query)('limit')),
    __param(6, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Object]),
    __metadata("design:returntype", Promise)
], OpHubBillingController.prototype, "findAllV3", null);
__decorate([
    (0, common_1.Post)('/makePayment/v3'),
    (0, swagger_1.ApiOperation)({ summary: 'Make a payment for a patient' }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'Payment made successfully.',
        type: PaymentResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_billing_entity_1.makepaymentV3]),
    __metadata("design:returntype", void 0)
], OpHubBillingController.prototype, "makePaymentV3", null);
exports.OpHubBillingController = OpHubBillingController = __decorate([
    (0, swagger_1.ApiTags)('op-hub-billing'),
    (0, common_1.Controller)('op-hub-billing'),
    __metadata("design:paramtypes", [op_hub_billing_service_1.OpHubBillingService])
], OpHubBillingController);
//# sourceMappingURL=op-hub-billing.controller.js.map