import { AddCharge, makepayment, makepaymentV3, UpdateCharge } from './entities/op-hub-billing.entity';
import { OpHubBillingService } from './op-hub-billing.service';
export declare class ChargeDetailsDto {
    id: number;
    name: string;
    chargeCategoryName: string;
    chargeCategoryId: number;
    chargeTypeName: string;
    chargeTypeId: number;
    standard_charge: number;
    taxPercentage: number;
    taxAmount: number;
    totalAmount: number;
}
export declare class ChargeNameDto {
    id: number;
    charge_type_id: number;
    name: string;
    description: string;
    short_code: string;
    is_default: string;
    created_at: Date;
}
export declare class ChargeCategoryDto {
    id: number;
    charge_category_id: number;
    tax_category_id: number;
    charge_unit_id: number;
    name: string;
    standard_charge: number;
    date: string | null;
    description: string;
    status: string;
    created_at: string;
    taxPercentage: string;
    taxAmount: number;
    totalAmount: number;
}
export declare class ChargeTypeDto {
    id: number;
    charge_type: string;
    is_default: string;
    is_active: string;
    created_at: string;
}
export declare class FindAllPendingResponse {
    patientDetails: PatientDetail[];
    pendingDetails: PendingDetail[];
    totalDue: number;
}
declare class PatientDetail {
    patient_name: string;
    age: number;
    gender: string;
    mobileno: string;
    email: string;
    id: number;
}
declare class PendingDetail {
    patient_charge_id: number;
    date: string;
    section: string;
    section_id: string;
    chargeDescription: string;
    qty: number;
    charges: number;
    taxPercentage: number;
    total: number;
}
export declare class FindOneResponse {
    patientDetails: PatientDetail[];
    pendingDetails: PendingDetail[];
    totalDue: number;
}
export declare class PatientDetails {
    id: number;
    lang_id: number;
    patient_name: string;
    dob: string;
    age: number;
    month: number | null;
    day: number | null;
    image: string | null;
    mobileno: string;
    email: string;
    gender: string;
    marital_status: string | null;
    blood_group: string;
    blood_bank_product_id: number;
    address: string;
    guardian_name: string | null;
    patient_type: string | null;
    ABHA_number: string | null;
    known_allergies: string | null;
    note: string | null;
    is_ipd: string | null;
    app_key: string | null;
    insurance_id: string | null;
    insurance_validity: string | null;
    is_dead: string;
    is_active: string;
    disable_at: string | null;
    created_at: string;
    pincode: string | null;
    state_code: string | null;
    district_code: string | null;
    emergency_mobile_no: string;
    dial_code: string;
    salutation: string;
    emergency_dial_code: string | null;
    state_name: string | null;
    district_name: string | null;
    aayush_unique_id: string;
}
export declare class HospitalDetails {
    hospital_name: string;
    contact_no: string;
    address: string;
    website: string;
    email: string;
}
export declare class InvoiceDetail {
    qty: number;
    standard_charge: number;
    taxPercentage: number;
    taxAmount: number;
    additional_charge: number;
    discount_amount: number;
    discount_percentage: number;
    total: number;
    chargeName: string;
}
export declare class InvoiceResponse {
    status: string;
    messege: string;
    patientDetails: PatientDetails;
    hospitalDetails: HospitalDetails;
    invoiceDetails: InvoiceDetail[];
    total: number;
}
export declare class CreateBillingResponse {
    status: string;
    message: string;
}
export declare class PaymentResponse {
    status: string;
    message: string;
}
declare class PaymentDetail {
    patientId: number;
    patient_name: string;
    transaction_id: string;
    payment_date: string;
    payment_mode: string;
    amount: number | null;
}
export declare class FindAllResponse {
    status: string;
    message: string;
    details: PaymentDetail[];
    count: number;
    overallTotal: number;
}
export declare class UpdateChargeResponse {
    status: string;
    message: string;
}
declare class PatientChargeDetails {
    patientCharge_id: number;
    standard_charge: number;
    tax: number;
    taxAmount: number;
    discount_amount: number;
    discount_percentage: number;
    additional_charge: number;
    additional_charge_note: string | null;
    qty: number;
    chargeName: string;
    chargeId: number;
    chargeCategoryName: string;
    chargeCategoryId: number;
    chargeTypeName: string;
    chargeTypeId: number;
}
export declare class GetPatientChargeResponse {
    status: string;
    message: string;
    details: PatientChargeDetails;
}
export declare class OpHubBillingController {
    private readonly billingService;
    constructor(billingService: OpHubBillingService);
    create(createBillingDto: AddCharge): Promise<any>;
    createAdditional(hospital_id: number, patient_charge_id: number): Promise<any>;
    makePayment(createBillingDto: makepayment): Promise<any> | {
        status_code: string;
        status: string;
        message: string;
    };
    findAll(hospital_id: number, from_date: any, to_date: any, patient_id: any, payment_method: any, date: any): Promise<any> | {
        status: string;
        message: string;
    };
    findinvoice(hospital_id: any, transaction_id: any): Promise<any>;
    findOne(patient_id: any, hospital_id: any, filter: any): Promise<any>;
    findAllPending(hospital_id: any): Promise<any>;
    findchargeType(hospital_id: any): Promise<any>;
    findchargeCategory(hospital_id: any, charge_type_id: any): Promise<any>;
    findchargeName(hospital_id: any, charge_category_id: any): Promise<any>;
    findchargeDetails(id: any, hospital_id: any): Promise<any>;
    update(id: string, updateBillingDto: UpdateCharge): Promise<any>;
    findAllPendingV2(limit: any, page: any): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/create-op-hub-billing.dto").PatientBalanceDto[];
        totalCount: number;
        totalAmount: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: any[];
        totalCount?: undefined;
        totalAmount?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        totalCount?: undefined;
        totalAmount?: undefined;
    }>;
    findAllV2(from_date: any, to_date: any, patient_id: any, payment_method: any, date: any, limit: any, page: any): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/update-op-hub-billing.dto").PatientTransactionDto[];
        totalCount: number;
        totalAmount: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: any[];
        totalCount?: undefined;
        totalAmount?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        totalCount?: undefined;
        totalAmount?: undefined;
    } | {
        status: string;
        message: string;
        status_code?: undefined;
        data?: undefined;
        totalCount?: undefined;
        totalAmount?: undefined;
    }>;
    getOnePatChargeV2(patient_id: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: any;
    }>;
    makePaymentV2(createBillingDto: makepayment): Promise<any> | {
        status_code: string;
        status: string;
        message: string;
    };
    createV2(createBillingDto: AddCharge): Promise<any> | {
        status_code: string;
        status: string;
        message: string;
    };
    findOnev2(patient_id: any, hospital_id: any, filter: string): Promise<any> | {
        status_code: string;
        status: string;
        message: string;
    };
    findAllPendingV3(limit: any, page: any): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: any;
        totalCount: any;
        totalAmount: any;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: any[];
        totalCount?: undefined;
        totalAmount?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        totalCount?: undefined;
        totalAmount?: undefined;
    }>;
    findAllV3(from_date: any, to_date: any, patient_id: any, payment_method: any, date: any, limit: any, page: any): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/update-op-hub-billing.dto").PatientTransactionDto[];
        totalCount: number;
        totalAmount: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: any[];
        totalCount?: undefined;
        totalAmount?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        totalCount?: undefined;
        totalAmount?: undefined;
    } | {
        status: string;
        message: string;
        status_code?: undefined;
        data?: undefined;
        totalCount?: undefined;
        totalAmount?: undefined;
    }>;
    makePaymentV3(createBillingDto: makepaymentV3): Promise<any> | {
        status_code: string;
        status: string;
        message: string;
    };
}
export {};
