import { EventEmitter2 } from '@nestjs/event-emitter';
import { DataSource } from 'typeorm';
import { PostAppointment, StatusChangePatch, UpdateAppointment, UpdateAppointmentcharge, CancelAppointment, AddAppointmentPayment } from './entities/op-hub-appointment.entity';
import { upcomingApptCountResponseDto } from './dto/create-op-hub-appointment.dto';
import { FaceAuthService } from 'src/face-auth/face-auth.service';
import { TransactionSplitService } from 'src/transaction_split/transaction_split.service';
export declare class OpHubAppointmentService {
    private readonly dynamicConnection;
    private readonly connection;
    private readonly eventEmitter;
    private readonly addAppointmentService;
    private readonly TransactionShareService;
    constructor(dynamicConnection: DataSource, connection: DataSource, eventEmitter: EventEmitter2, addAppointmentService: FaceAuthService, TransactionShareService: TransactionSplitService);
    TransferToSubmerchant(payment_id: any, getPaymentGatewayDetails: any, hospital_id: any, patient_aayush_id: any, admin_transaction_id: any, hos_transaction_id: any): Promise<void>;
    create(AppointmentEntity: PostAppointment): Promise<string | {
        status: string;
        message: string;
    } | {
        status: string;
        messege: string;
        inserted_details: any;
    }[] | {
        status: string;
        messege: string;
    }[]>;
    findAll(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string): Promise<any>;
    Today(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string): Promise<any>;
    findAllHistory(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, payment_status: string): Promise<any>;
    findOne(token: string, hospitalId: number): Promise<{
        status: string;
        message: string;
        QR_Type_ID?: undefined;
        QR_Type?: undefined;
        Appointment_details?: undefined;
        error?: undefined;
    } | {
        QR_Type_ID: number;
        QR_Type: string;
        Appointment_details: any;
        status?: undefined;
        message?: undefined;
        error?: undefined;
    } | {
        status: string;
        message: string;
        error: any;
        QR_Type_ID?: undefined;
        QR_Type?: undefined;
        Appointment_details?: undefined;
    }>;
    private getAppointmentQuery;
    private attachPaymentDetails;
    findQR(token: string, hospital_id: number): Promise<any>;
    updateStatus(id: string, Entity: StatusChangePatch): Promise<any[]>;
    reshedule(id: string, Entity: UpdateAppointment): Promise<{
        status: string;
        message: string;
    } | {
        status: string;
        message: string;
        transactionId: any;
        updated_value: any;
    }[] | {
        status: string;
        message: string;
        transactionId: any;
        updated_values: any;
    }[] | {
        error: any;
    }[] | {
        status: string;
        message: string;
    }[]>;
    updateChargeDetails(id: number, Entity: UpdateAppointmentcharge): Promise<{
        status: string;
        message: string;
    }[]>;
    cancelAppointment(id: string, Entity: CancelAppointment): Promise<any[]>;
    makepayment(paymentDetails: PostAppointment, transaction_id: any): Promise<{
        status: string;
        message: string;
        success?: undefined;
    } | {
        success: string;
        message: string;
        status?: undefined;
    }>;
    V2findAllUpcoming(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string, limit: number, page: number): Promise<upcomingApptCountResponseDto>;
    V2findAllHistory(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string, limit: number, page: number): Promise<upcomingApptCountResponseDto>;
    V2findAllToday(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string, limit: number, page: number): Promise<upcomingApptCountResponseDto>;
    V3findAllUpcoming(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string, limit: number, page: number): Promise<{
        details: any;
        count: any;
    }>;
    V3findAllHistory(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string, limit: number, page: number): Promise<{
        details: any;
        count: any;
    }>;
    V3findAllToday(fromDate: string, toDate: string, doctorId: number, appointStatus: string, hospital_id: number, paymentStatus: string, limit: number, page: number): Promise<{
        details: any;
        count: any;
    }>;
    updatePaymentDetails(appointment_id: string, Entity: AddAppointmentPayment): Promise<{
        status_code: number;
        status: string;
        message: string;
    }[] | {
        status_code: number;
        status: string;
        message: string;
    }>;
    specialityList(): Promise<{
        status_code: number;
        status: string;
        message: string;
        data?: undefined;
    } | {
        status_code: number;
        status: string;
        message: string;
        data: any;
    }>;
}
