"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubAppointmentController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_appointment_service_1 = require("./op-hub-appointment.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_entity_1 = require("./entities/op-hub-appointment.entity");
let OpHubAppointmentController = class OpHubAppointmentController {
    constructor(appointmentService) {
        this.appointmentService = appointmentService;
    }
    create(entity) {
        if (!entity.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.HOSPITAL_ID_ERR,
            };
        }
        return this.appointmentService.create(entity);
    }
    findAll(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id) {
        return this.appointmentService.findAll(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus);
    }
    findAllHistory(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id) {
        return this.appointmentService.findAllHistory(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus);
    }
    Today(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id) {
        return this.appointmentService.Today(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus);
    }
    findOne(token, hospital_id) {
        return this.appointmentService.findOne(token, hospital_id);
    }
    findQR(token, hospital_id) {
        return this.appointmentService.findQR(token, hospital_id);
    }
    updateStatus(id, entity) {
        return this.appointmentService.updateStatus(id, entity);
    }
    update(id, Entity) {
        if (!Entity.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.HOSPITAL_ID_ERR,
            };
        }
        return this.appointmentService.reshedule(id, Entity);
    }
    cancelAppointment(id, entity) {
        return this.appointmentService.cancelAppointment(id, entity);
    }
    remove(id, entity) {
        return this.appointmentService.updateChargeDetails(+id, entity);
    }
    makePayment(id, entity) {
        if (!entity.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.HOSPITAL_ID_ERR,
            };
        }
        return this.appointmentService.makepayment(entity, id);
    }
    async findAllUpcomingV2(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id, limit, page) {
        if (!hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.HOSPITAL_ID_ERR_V2,
            };
        }
        try {
            let final_out = await this.appointmentService.V2findAllUpcoming(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus, +limit || 10, +page || 1);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            console.log(error, 'error');
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllTodayV2(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id, limit, page) {
        if (!hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.HOSPITAL_ID_ERR_V2,
            };
        }
        try {
            let final_out = await this.appointmentService.V2findAllToday(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus, +limit || 10, +page || 1);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllhistoryV2(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id, limit, page) {
        if (!hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.HOSPITAL_ID_ERR_V2,
            };
        }
        try {
            let final_out = await this.appointmentService.V2findAllHistory(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus, +limit || 10, +page || 1);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllUpcomingV3(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id, limit, page) {
        if (!hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.HOSPITAL_ID_ERR_V2,
            };
        }
        try {
            let final_out = await this.appointmentService.V3findAllUpcoming(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus, +limit || 10, +page || 1);
            if (final_out?.details?.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            console.log(error, 'error');
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllHistoryV3(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id, limit, page) {
        if (!hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.HOSPITAL_ID_ERR_V2,
            };
        }
        try {
            let final_out = await this.appointmentService.V3findAllHistory(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus, +limit || 10, +page || 1);
            console.log(final_out?.details, 'final_out?.details');
            if (final_out?.details?.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            console.log(error, 'error');
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllTodayV3(fromDate, toDate, doctorId, appointStatus, paymentStatus, hospital_id, limit, page) {
        if (!hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.HOSPITAL_ID_ERR_V2,
            };
        }
        try {
            let final_out = await this.appointmentService.V3findAllToday(fromDate, toDate, doctorId, appointStatus, hospital_id, paymentStatus, +limit || 10, +page || 1);
            if (final_out?.details?.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: [],
                };
            }
        }
        catch (error) {
            console.log(error, 'error');
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async paymentUpdate(appointment_id, add_appointment_payment) {
        if (!appointment_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Appointment ID is required',
            };
        }
        appointment_id = appointment_id.replace(/[^\d]/g, '');
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() != 'cash' &&
            add_appointment_payment.payment_mode.toLocaleLowerCase() != 'card' &&
            add_appointment_payment.payment_mode.toLocaleLowerCase() !=
                'net_banking' &&
            add_appointment_payment.payment_mode.toLocaleLowerCase() != 'upi') {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Enter Correct Payment Method',
            };
        }
        if (!add_appointment_payment.Hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Enter Hospital ID',
            };
        }
        if (!add_appointment_payment.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() == 'card' &&
            !add_appointment_payment.card_division &&
            !add_appointment_payment.card_bank_name &&
            !add_appointment_payment.card_type &&
            !add_appointment_payment.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() ==
            'net_banking' &&
            !add_appointment_payment.net_banking_division &&
            !add_appointment_payment.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() == 'upi' &&
            !add_appointment_payment.upi_id &&
            !add_appointment_payment.upi_transaction_id &&
            !add_appointment_payment.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.appointmentService.updatePaymentDetails(appointment_id, add_appointment_payment);
    }
    async getList() {
        return this.appointmentService.specialityList();
    }
};
exports.OpHubAppointmentController = OpHubAppointmentController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new appointment' }),
    (0, swagger_1.ApiBody)({
        description: 'Details of the appointment to be created',
        type: op_hub_appointment_entity_1.PostAppointment,
    }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'The appointment has been successfully created.',
        type: op_hub_appointment_entity_1.SuccessResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_appointment_entity_1.PostAppointment]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('/history'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve appointment history based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Appointment history retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "findAllHistory", null);
__decorate([
    (0, common_1.Get)('/Today'),
    (0, swagger_1.ApiOperation)({
        summary: 'Retrieve appointment Today appointments based on filters',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Appointment Today appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "Today", null);
__decorate([
    (0, common_1.Get)('/info'),
    (0, swagger_1.ApiOperation)({
        summary: 'Retrieve appointment information based on token and hospital ID',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Appointment information retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    __param(0, (0, common_1.Query)('token')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "findOne", null);
__decorate([
    (0, common_1.Get)('/getQR'),
    (0, swagger_1.ApiOperation)({
        summary: 'Retrieve QR code information based on token and hospital ID',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'QR code information retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'QR code not found.',
    }),
    __param(0, (0, common_1.Query)('token')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "findQR", null);
__decorate([
    (0, common_1.Patch)('/status/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update the status of an appointment' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'The appointment status has been successfully updated.',
        type: op_hub_appointment_entity_1.UpdateStatusResponse200,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, op_hub_appointment_entity_1.StatusChangePatch]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "updateStatus", null);
__decorate([
    (0, common_1.Post)('/reshedule/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Resheduling appointment' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Appointment resheduleld successfully',
        type: op_hub_appointment_entity_1.UpdateAppointmentResponse,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, op_hub_appointment_entity_1.UpdateAppointment]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "update", null);
__decorate([
    (0, common_1.Patch)('/cancel/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Cancel an appointment' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'The appointment has been successfully canceled.',
        type: op_hub_appointment_entity_1.CancelAppointmentResponse200,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, op_hub_appointment_entity_1.CancelAppointment]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "cancelAppointment", null);
__decorate([
    (0, common_1.Patch)('/add-or-discount-charges/:id'),
    (0, swagger_1.ApiOperation)({
        summary: 'Add or update additional charges and discounts for an appointment',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Charges updated successfully.',
        type: op_hub_appointment_entity_1.chargeout,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, op_hub_appointment_entity_1.UpdateAppointmentcharge]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "remove", null);
__decorate([
    (0, common_1.Post)('/updatePaymentDetails'),
    (0, swagger_1.ApiOperation)({
        summary: 'Add or update additional charges and discounts for an appointment',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Charges updated successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_entity_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Query)('transaction_id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, op_hub_appointment_entity_1.PostAppointment]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentController.prototype, "makePayment", null);
__decorate([
    (0, common_1.Get)('v2/upcoming-appointment'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __param(6, (0, common_1.Query)('limit')),
    __param(7, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "findAllUpcomingV2", null);
__decorate([
    (0, common_1.Get)('v2/today-appointment'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __param(6, (0, common_1.Query)('limit')),
    __param(7, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "findAllTodayV2", null);
__decorate([
    (0, common_1.Get)('v2/history-appointment'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __param(6, (0, common_1.Query)('limit')),
    __param(7, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "findAllhistoryV2", null);
__decorate([
    (0, common_1.Get)('v3/upcoming-appointment'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __param(6, (0, common_1.Query)('limit')),
    __param(7, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "findAllUpcomingV3", null);
__decorate([
    (0, common_1.Get)('v3/history-appointment'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __param(6, (0, common_1.Query)('limit')),
    __param(7, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "findAllHistoryV3", null);
__decorate([
    (0, common_1.Get)('v3/today-appointment'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __param(0, (0, common_1.Query)('fromDate')),
    __param(1, (0, common_1.Query)('toDate')),
    __param(2, (0, common_1.Query)('doctorId')),
    __param(3, (0, common_1.Query)('appointStatus')),
    __param(4, (0, common_1.Query)('payment_status')),
    __param(5, (0, common_1.Query)('hospital_id')),
    __param(6, (0, common_1.Query)('limit')),
    __param(7, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, String, String, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "findAllTodayV3", null);
__decorate([
    (0, common_1.Post)('/update-appt-payment'),
    __param(0, (0, common_1.Query)('appointment_id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, op_hub_appointment_entity_1.AddAppointmentPayment]),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "paymentUpdate", null);
__decorate([
    (0, common_1.Get)('/speciality_list'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all appointments based on filters' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointments retrieved successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], OpHubAppointmentController.prototype, "getList", null);
exports.OpHubAppointmentController = OpHubAppointmentController = __decorate([
    (0, swagger_1.ApiTags)('appointment'),
    (0, common_1.Controller)('op-hub-appointment'),
    __metadata("design:paramtypes", [op_hub_appointment_service_1.OpHubAppointmentService])
], OpHubAppointmentController);
//# sourceMappingURL=op-hub-appointment.controller.js.map