"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddAppointmentPayment = exports.UpdateAppointmentResponse = exports.UpdatedValue = exports.UpdateAppointmentcharge = exports.chargeout = exports.charge = exports.CancelAppointmentResponse200 = exports.CancelAppointmentResponse = exports.CancelAppointment = exports.UpdateStatusResponse200 = exports.StatusChangePatch = exports.UpdateAppointment = exports.ErrorResponse500 = exports.ErrorResponse400 = exports.SuccessResponse = exports.PostAppointment = exports.Appointment = void 0;
const swagger_1 = require("@nestjs/swagger");
class Appointment {
}
exports.Appointment = Appointment;
class PostAppointment {
}
exports.PostAppointment = PostAppointment;
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'patient id',
        example: 4,
        type: Number,
    }),
    __metadata("design:type", Number)
], PostAppointment.prototype, "patient_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'date of appointment',
        example: '2024-09-09',
        type: Date,
        format: 'date',
    }),
    __metadata("design:type", Object)
], PostAppointment.prototype, "date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'staff name of the person who is creating the appointment',
        example: 'Elakkiya S',
        type: 'string',
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "received_by_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'Time of appointment',
        example: '11:11:11',
        format: 'time',
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "time", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'id of the doctor for whom the appointment was going to be sheduled',
        example: 98,
        type: Number,
    }),
    __metadata("design:type", Number)
], PostAppointment.prototype, "doctor", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'patient id',
        example: 4,
        enum: ['UPI', 'Cash', 'Offline', 'Paylater', 'cheque'],
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "payment_mode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'timestamp of payment',
        example: '2024-01-30 11:11:11',
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "payment_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'global shift id of doctors',
        example: 21,
        type: Number,
    }),
    __metadata("design:type", Number)
], PostAppointment.prototype, "global_shift_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'shift id of doctors (i.e) slot id',
        example: 4,
        type: Number,
    }),
    __metadata("design:type", Number)
], PostAppointment.prototype, "shift_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'live consultation',
        example: 'no',
        enum: ['yes', 'no'],
        type: 'string',
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "live_consult", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'hospital id which is received during login',
        example: 1,
        type: Number,
    }),
    __metadata("design:type", Number)
], PostAppointment.prototype, "Hospital_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
        description: 'txn id received after payment used only during payment gateway access',
        example: '20241671721130494230',
        type: 'string',
    }),
    (0, swagger_1.ApiHideProperty)(),
    __metadata("design:type", String)
], PostAppointment.prototype, "txn_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
        description: 'same as txn id',
        example: '20241671721130494230',
        type: 'string',
    }),
    (0, swagger_1.ApiHideProperty)(),
    __metadata("design:type", String)
], PostAppointment.prototype, "pg_ref_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
        description: 'same as txn id',
        example: '20241671721130494230',
        type: 'string',
    }),
    (0, swagger_1.ApiProperty)({ example: 'APPPN112' }),
    __metadata("design:type", String)
], PostAppointment.prototype, "amount_from_coins", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'APPPN112' }),
    __metadata("design:type", String)
], PostAppointment.prototype, "actual_amount_paid", void 0);
__decorate([
    (0, swagger_1.ApiHideProperty)(),
    __metadata("design:type", String)
], PostAppointment.prototype, "bank_ref_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'name of the payment gateway',
        example: 'razorpay',
        format: 'string',
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "payment_gateway", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'payment_id received from payment gateway',
        example: 'pay_0834jljfdh',
        format: 'string',
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "payment_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'reference number received from payment gateway response after capturing the payment',
        example: '654598326',
        format: 'string',
    }),
    __metadata("design:type", String)
], PostAppointment.prototype, "payment_reference_number", void 0);
class InsertedDetails {
}
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'APPN553',
        description: 'The unique ID of the appointment',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 3, description: 'The ID of the patient' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "patient_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Elakkiya S',
        description: 'The name of the patient',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "patient_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Female', description: 'The gender of the patient' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 24, description: 'The age of the patient' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '7339120466',
        description: 'The mobile number of the patient',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "mobileno", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'elakkiyas2806@gmail.com',
        description: 'The email of the patient',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'The ABHA number of the patient' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "ABHA_number", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Offline Consultation',
        description: 'Type of consultation',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "consultingType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Dr. Matheshwari N',
        description: 'The name of the doctor',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "doctorName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 98, description: 'The ID of the doctor' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "doctor_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'cardiologist',
        description: 'Specialization of the doctor',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "doctorSpecialist", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Offline',
        description: 'The source of the appointment',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "source", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 21, description: 'The global shift ID' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "global_shift_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 387, description: 'The shift ID' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "shift_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'APPN553', description: 'The appointment ID' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "appointment_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '1st Jun 2024',
        description: 'The date of the appointment in a human-readable format',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "appointmentDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '2024-06-01',
        description: 'The date of the appointment in ISO format',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '03:00 PM',
        description: 'The time of the appointment in a human-readable format',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "appointmentTime", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '15:00:00',
        description: 'The time of the appointment in 24-hour format',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "time", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '10:19 AM - 10:47 AM',
        description: 'The appointment slot',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "slot", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Reserved',
        description: 'The status of the appointment',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "appointment_status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '2',
        description: 'The ID of the appointment status',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "appointment_status_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 0,
        description: 'Indicates if the token has been verified',
    }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "is_token_verified", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 0,
        description: 'Indicates if the consultation has been closed',
    }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "is_consultation_closed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '#FFC52F',
        description: 'Color code representing the appointment status',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "color_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'The token number' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "tokenNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'Any additional messages' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 200, description: 'The consultation fees' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "consultFees", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 12, description: 'Tax percentage applicable' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "taxPercentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '24.00', description: 'The tax amount' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 224, description: 'The net amount to be paid' }),
    __metadata("design:type", Number)
], InsertedDetails.prototype, "netAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: null, description: 'Balance amount if any' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "balanceAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'TRID808', description: 'The transaction ID' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "transactionID", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'UPI', description: 'The payment mode used' }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "payment_mode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: '2024-01-30T05:41:11.000Z',
        description: 'The payment date in ISO format',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "payment_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Payment done.',
        description: 'The status of the payment',
    }),
    __metadata("design:type", String)
], InsertedDetails.prototype, "payment_status", void 0);
class SuccessResponse {
}
exports.SuccessResponse = SuccessResponse;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'success',
        description: 'The status of the response',
    }),
    __metadata("design:type", String)
], SuccessResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Appointment booked successfully',
        description: 'A message indicating the success of the operation',
    }),
    __metadata("design:type", String)
], SuccessResponse.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: InsertedDetails,
        description: 'Details of the inserted appointment',
    }),
    __metadata("design:type", InsertedDetails)
], SuccessResponse.prototype, "inserted_details", void 0);
class ErrorResponse400 {
}
exports.ErrorResponse400 = ErrorResponse400;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Unexpected end of JSON input',
        description: 'Description of the error that occurred',
    }),
    __metadata("design:type", String)
], ErrorResponse400.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Bad Request', description: 'General error type' }),
    __metadata("design:type", String)
], ErrorResponse400.prototype, "error", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 400, description: 'HTTP status code' }),
    __metadata("design:type", Number)
], ErrorResponse400.prototype, "statusCode", void 0);
class ErrorResponse500 {
}
exports.ErrorResponse500 = ErrorResponse500;
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Internal server error',
        description: 'Description of the error that occurred',
    }),
    __metadata("design:type", String)
], ErrorResponse500.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 500, description: 'HTTP status code' }),
    __metadata("design:type", Number)
], ErrorResponse500.prototype, "statusCode", void 0);
class UpdateAppointment {
}
exports.UpdateAppointment = UpdateAppointment;
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'patient id',
        example: 4,
        type: Number,
    }),
    __metadata("design:type", Number)
], UpdateAppointment.prototype, "patient_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'APPPN112' }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "amount_from_coins", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'APPPN112' }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "actual_amount_paid", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'date of appointment',
        example: '2024-09-09',
        type: Date,
        format: 'date',
    }),
    __metadata("design:type", Object)
], UpdateAppointment.prototype, "date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'Time of appointment',
        example: '11:11:11',
        format: 'time',
    }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "time", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'id of the doctor for whom the appointment was going to be sheduled',
        example: 98,
        type: Number,
    }),
    __metadata("design:type", Number)
], UpdateAppointment.prototype, "doctor", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'staff name of the person who is creating the appointment',
        example: 'Elakkiya S',
        type: 'string',
    }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "received_by_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'patient id',
        example: 4,
        enum: ['UPI', 'Cash', 'Offline', 'Paylater', 'cheque'],
    }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "payment_mode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'timestamp of payment',
        example: '2024-01-30 11:11:11',
    }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "payment_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The new status of the appointment',
        example: 'Confirmed',
    }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "appointment_status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The ID corresponding to the appointment status',
        example: 1,
    }),
    __metadata("design:type", Object)
], UpdateAppointment.prototype, "appointment_status_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'global shift id of doctors',
        example: 21,
        type: Number,
    }),
    __metadata("design:type", Number)
], UpdateAppointment.prototype, "global_shift_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'shift id of doctors (i.e) slot id',
        example: 4,
        type: Number,
    }),
    __metadata("design:type", Number)
], UpdateAppointment.prototype, "shift_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'live consultation',
        example: 'no',
        enum: ['yes', 'no'],
        type: 'string',
    }),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "live_consult", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: true,
        description: 'hospital id which is received during login',
        example: 1,
        type: Number,
    }),
    __metadata("design:type", Number)
], UpdateAppointment.prototype, "Hospital_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
        description: 'txn id received after payment used only during payment gateway access',
        example: '20241671721130494230',
        type: 'string',
    }),
    (0, swagger_1.ApiHideProperty)(),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "txn_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
        description: 'same as txn id',
        example: '20241671721130494230',
        type: 'string',
    }),
    (0, swagger_1.ApiHideProperty)(),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "pg_ref_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
        description: 'same as txn id',
        example: '20241671721130494230',
        type: 'string',
    }),
    (0, swagger_1.ApiHideProperty)(),
    __metadata("design:type", String)
], UpdateAppointment.prototype, "bank_ref_id", void 0);
class StatusChangePatch {
}
exports.StatusChangePatch = StatusChangePatch;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The new status of the appointment',
        example: 'Confirmed',
    }),
    __metadata("design:type", String)
], StatusChangePatch.prototype, "appointment_status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The ID corresponding to the appointment status',
        example: 1,
    }),
    __metadata("design:type", Object)
], StatusChangePatch.prototype, "appointment_status_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The ID of the hospital where the appointment is scheduled',
        example: 123,
    }),
    __metadata("design:type", Number)
], StatusChangePatch.prototype, "Hospital_id", void 0);
class UpdateStatusResponse200 {
}
exports.UpdateStatusResponse200 = UpdateStatusResponse200;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], UpdateStatusResponse200.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Appointment Status Updated successfully' }),
    __metadata("design:type", String)
], UpdateStatusResponse200.prototype, "message", void 0);
class CancelAppointment {
}
exports.CancelAppointment = CancelAppointment;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The ID of the hospital where the appointment was made.',
        type: Number,
    }),
    __metadata("design:type", Number)
], CancelAppointment.prototype, "Hospital_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The reason for cancelling the appointment.',
        type: String,
    }),
    __metadata("design:type", String)
], CancelAppointment.prototype, "cancellationReason", void 0);
class CancelAppointmentResponse {
}
exports.CancelAppointmentResponse = CancelAppointmentResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], CancelAppointmentResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Appointment Status Updated successfully' }),
    __metadata("design:type", String)
], CancelAppointmentResponse.prototype, "message", void 0);
class CancelAppointmentResponse200 {
}
exports.CancelAppointmentResponse200 = CancelAppointmentResponse200;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [CancelAppointmentResponse] }),
    __metadata("design:type", Array)
], CancelAppointmentResponse200.prototype, "data", void 0);
class charge {
}
exports.charge = charge;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], charge.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'charges modified successfully' }),
    __metadata("design:type", String)
], charge.prototype, "message", void 0);
class chargeout {
}
exports.chargeout = chargeout;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [charge] }),
    __metadata("design:type", Array)
], chargeout.prototype, "data", void 0);
class UpdateAppointmentcharge {
}
exports.UpdateAppointmentcharge = UpdateAppointmentcharge;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'ID of the hospital' }),
    __metadata("design:type", Number)
], UpdateAppointmentcharge.prototype, "Hospital_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 200, description: 'Additional charge amount' }),
    __metadata("design:type", Object)
], UpdateAppointmentcharge.prototype, "additional_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 'Late evening consult charge',
        description: 'Notes for the additional charge',
    }),
    __metadata("design:type", Object)
], UpdateAppointmentcharge.prototype, "additional_charge_note", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 10, description: 'Discount percentage to apply' }),
    __metadata("design:type", Object)
], UpdateAppointmentcharge.prototype, "discount_percentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 50, description: 'Total discount amount' }),
    __metadata("design:type", Object)
], UpdateAppointmentcharge.prototype, "discount_amount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        example: 500,
        description: 'Total amount after charges and discounts',
    }),
    __metadata("design:type", Object)
], UpdateAppointmentcharge.prototype, "total", void 0);
class UpdatedValue {
}
exports.UpdatedValue = UpdatedValue;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 3 }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "patient_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Elakkiya S' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "patient_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Female' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 24 }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '7339120466' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "mobileno", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'elakkiyas2806@gmail.com' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true, example: null }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "ABHA_number", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Offline Consultation' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "consultingType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Dr. Matheshwari N' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "doctorName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 98 }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "doctor_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'cardiologist' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "doctorSpecialist", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Offline' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "source", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'APPN554' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "appointment_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '16th May 2024' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "appointmentDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-05-15T18:30:00.000Z' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '11:11 AM' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "appointmentTime", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '10:19 AM - 10:47 AM' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "slot", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Requested' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "appointment_status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '1' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "appointment_status_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '#F59E0B' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "color_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true, example: null }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "tokenNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true, example: null }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 200 }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "consultFees", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 12 }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "taxPercentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '24.00' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 224 }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "netAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ nullable: true, example: null }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "balanceAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 809 }),
    __metadata("design:type", Number)
], UpdatedValue.prototype, "transactionID", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'UPI' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "payment_mode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-30T05:41:11.000Z' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "payment_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Payment done.' }),
    __metadata("design:type", String)
], UpdatedValue.prototype, "payment_status", void 0);
class UpdateAppointmentResponse {
}
exports.UpdateAppointmentResponse = UpdateAppointmentResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success' }),
    __metadata("design:type", String)
], UpdateAppointmentResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Appointment updated successfully.' }),
    __metadata("design:type", String)
], UpdateAppointmentResponse.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: UpdatedValue }),
    __metadata("design:type", UpdatedValue)
], UpdateAppointmentResponse.prototype, "updated_value", void 0);
class AddAppointmentPayment {
}
exports.AddAppointmentPayment = AddAppointmentPayment;
//# sourceMappingURL=op-hub-appointment.entity.js.map