export declare class Appointment {
    id: number;
    patient_id: number;
    case_reference_id: number;
    visit_details_id: number;
    date: any;
    time: string;
    priority: number;
    specialist: number;
    doctor: number;
    message: string;
    amount: string;
    appointment_status: string;
    source: string;
    is_opd: string;
    payment_mode: string;
    payment_date: string;
    is_ipd: string;
    global_shift_id: number;
    shift_id: number;
    is_queue: number;
    live_consult: string;
    Hospital_id: number;
    hos_appointment_id: number;
    txn_id: string;
    pg_ref_id: string;
    bank_ref_id: string;
    appointment_status_id: any;
    cancellationReason: any;
    additional_charge: any;
    additional_charge_note: any;
    discount_percentage: any;
    discount_amount: any;
    total: any;
    payment_gateway?: string;
    payment_id?: string;
    payment_reference_number?: string;
}
export declare class PostAppointment {
    patient_id: number;
    date: any;
    received_by_name: string;
    time: string;
    doctor: number;
    payment_mode: string;
    payment_date: string;
    global_shift_id: number;
    shift_id: number;
    live_consult: string;
    Hospital_id: number;
    txn_id: string;
    pg_ref_id: string;
    amount_from_coins: string;
    actual_amount_paid: string;
    bank_ref_id: string;
    payment_gateway?: string;
    payment_id?: string;
    payment_reference_number?: string;
}
declare class InsertedDetails {
    id: string;
    patient_id: number;
    patient_name: string;
    gender: string;
    age: number;
    mobileno: string;
    email: string;
    ABHA_number: string | null;
    consultingType: string;
    doctorName: string;
    doctor_id: number;
    doctorSpecialist: string;
    source: string;
    global_shift_id: number;
    shift_id: number;
    appointment_id: string;
    appointmentDate: string;
    date: string;
    appointmentTime: string;
    time: string;
    slot: string;
    appointment_status: string;
    appointment_status_id: string;
    is_token_verified: number;
    is_consultation_closed: number;
    color_code: string;
    tokenNumber: string | null;
    message: string | null;
    consultFees: number;
    taxPercentage: number;
    taxAmount: string;
    netAmount: number;
    balanceAmount: string | null;
    transactionID: string;
    payment_mode: string;
    payment_date: string;
    payment_status: string;
}
export declare class SuccessResponse {
    status: string;
    message: string;
    inserted_details: InsertedDetails;
}
export declare class ErrorResponse400 {
    message: string;
    error: string;
    statusCode: number;
}
export declare class ErrorResponse500 {
    message: string;
    statusCode: number;
}
export declare class UpdateAppointment {
    patient_id: number;
    amount_from_coins: string;
    actual_amount_paid: string;
    date: any;
    time: string;
    doctor: number;
    received_by_name: string;
    payment_mode: string;
    payment_date: string;
    appointment_status: string;
    appointment_status_id: any;
    global_shift_id: number;
    shift_id: number;
    live_consult: string;
    Hospital_id: number;
    txn_id: string;
    pg_ref_id: string;
    bank_ref_id: string;
}
export declare class StatusChangePatch {
    appointment_status: string;
    appointment_status_id: any;
    Hospital_id: number;
}
export declare class UpdateStatusResponse200 {
    status: string;
    message: string;
}
export declare class CancelAppointment {
    Hospital_id: number;
    cancellationReason: string;
}
export declare class CancelAppointmentResponse {
    status: string;
    message: string;
}
export declare class CancelAppointmentResponse200 {
    data: CancelAppointmentResponse[];
}
export declare class charge {
    status: string;
    message: string;
}
export declare class chargeout {
    data: charge[];
}
export declare class UpdateAppointmentcharge {
    Hospital_id: number;
    additional_charge: any;
    additional_charge_note: any;
    discount_percentage: any;
    discount_amount: any;
    total: any;
}
export declare class UpdatedValue {
    patient_id: number;
    patient_name: string;
    gender: string;
    age: number;
    mobileno: string;
    email: string;
    ABHA_number: string | null;
    consultingType: string;
    doctorName: string;
    doctor_id: number;
    doctorSpecialist: string;
    source: string;
    appointment_id: string;
    appointmentDate: string;
    date: string;
    appointmentTime: string;
    slot: string;
    appointment_status: string;
    appointment_status_id: string;
    color_code: string;
    tokenNumber: string | null;
    message: string | null;
    consultFees: number;
    taxPercentage: number;
    taxAmount: string;
    netAmount: number;
    balanceAmount: number | null;
    transactionID: number;
    payment_mode: string;
    payment_date: string;
    payment_status: string;
}
export declare class UpdateAppointmentResponse {
    status: string;
    message: string;
    updated_value: UpdatedValue;
}
export declare class AddAppointmentPayment {
    payment_mode: string;
    Hospital_id: number;
    payment_method: string;
    card_division: string;
    card_bank_name: string;
    card_type: string;
    card_transaction_id: string;
    net_banking_division: string;
    net_banking_transaction_id: string;
    upi_id: string;
    upi_transaction_id: string;
    upi_bank_name: string;
    cash_transaction_id: string;
    amount_from_coins: string;
    actual_amount_paid: string;
}
export {};
