"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubAppointmentStatusController = exports.AppointmentStatusResponse = exports.ErrorResponse500 = void 0;
const common_1 = require("@nestjs/common");
const op_hub_appointment_status_service_1 = require("./op-hub-appointment-status.service");
const swagger_1 = require("@nestjs/swagger");
class ErrorResponse500 {
}
exports.ErrorResponse500 = ErrorResponse500;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 500 }),
    __metadata("design:type", Number)
], ErrorResponse500.prototype, "statusCode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Internal server error' }),
    __metadata("design:type", String)
], ErrorResponse500.prototype, "message", void 0);
class AppointmentStatusResponse {
}
exports.AppointmentStatusResponse = AppointmentStatusResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1 }),
    __metadata("design:type", Number)
], AppointmentStatusResponse.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Requested' }),
    __metadata("design:type", String)
], AppointmentStatusResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-04-25T05:23:23.000Z' }),
    __metadata("design:type", String)
], AppointmentStatusResponse.prototype, "create_time", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '#F59E0B' }),
    __metadata("design:type", String)
], AppointmentStatusResponse.prototype, "color_code", void 0);
let OpHubAppointmentStatusController = class OpHubAppointmentStatusController {
    constructor(appointmentStatusService) {
        this.appointmentStatusService = appointmentStatusService;
    }
    findAll(hospital_id) {
        return this.appointmentStatusService.findAll(hospital_id);
    }
    getStatusTracking(hospital_id, appointment_id) {
        return this.appointmentStatusService.appointment_status_tracking(hospital_id, appointment_id);
    }
    listForTracking(hospital_id) {
        return this.appointmentStatusService.findAllForTracking(hospital_id);
    }
};
exports.OpHubAppointmentStatusController = OpHubAppointmentStatusController;
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get all appointment statuses for a hospital' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of appointment statuses.',
        type: [AppointmentStatusResponse]
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentStatusController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('/tracking'),
    (0, swagger_1.ApiOperation)({ summary: 'Track the status of a specific appointment' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Appointment status tracking details.',
        type: [AppointmentStatusResponse]
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('appointment_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentStatusController.prototype, "getStatusTracking", null);
__decorate([
    (0, common_1.Get)('/statusList'),
    (0, swagger_1.ApiOperation)({ summary: 'Get a list of statuses for tracking' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of statuses for tracking.',
        type: [AppointmentStatusResponse]
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Appointment not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OpHubAppointmentStatusController.prototype, "listForTracking", null);
exports.OpHubAppointmentStatusController = OpHubAppointmentStatusController = __decorate([
    (0, common_1.Controller)('op-hub-appointment-status'),
    __metadata("design:paramtypes", [op_hub_appointment_status_service_1.OpHubAppointmentStatusService])
], OpHubAppointmentStatusController);
//# sourceMappingURL=op-hub-appointment-status.controller.js.map