"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NurseNotesIpdController = void 0;
const common_1 = require("@nestjs/common");
const nurse_notes_ipd_entity_1 = require("./entities/nurse_notes_ipd.entity");
const nurse_notes_ipd_service_1 = require("./nurse_notes_ipd.service");
const auth_guard_1 = require("../auth/auth.guard");
let NurseNotesIpdController = class NurseNotesIpdController {
    constructor(nurseNotesIpdService) {
        this.nurseNotesIpdService = nurseNotesIpdService;
    }
    create(NurseNotesIpdmodule) {
        return this.nurseNotesIpdService.create(NurseNotesIpdmodule);
    }
    createNurseComment(NurseNotesCommentIpdmodule) {
        return this.nurseNotesIpdService.createNurseComment(NurseNotesCommentIpdmodule);
    }
    async removeNurseNote(id, Hospital_id) {
        await this.nurseNotesIpdService.remove(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async removeNurseNoteComment(id, Hospital_id) {
        await this.nurseNotesIpdService.removeComment(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    findOne(id) {
        return this.nurseNotesIpdService.findOne(id);
    }
    update(id, NurseNotesIpdmodule) {
        return this.nurseNotesIpdService.update(id, NurseNotesIpdmodule);
    }
    async findNurseNotesIpdDetails(ipd_id, search, limit, page) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            const final_out = await this.nurseNotesIpdService.findNurseNotesIpdDetails(ipd_id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findNurseNotesIpdDetail(ipd_id, search, limit, page) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            const final_out = await this.nurseNotesIpdService.findNurseNotesIpdDetail(ipd_id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.NurseNotesIpdController = NurseNotesIpdController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [nurse_notes_ipd_entity_1.NurseNotesIpd]),
    __metadata("design:returntype", void 0)
], NurseNotesIpdController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/comment'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [nurse_notes_ipd_entity_1.NurseNotesIpd]),
    __metadata("design:returntype", void 0)
], NurseNotesIpdController.prototype, "createNurseComment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], NurseNotesIpdController.prototype, "removeNurseNote", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteComment/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], NurseNotesIpdController.prototype, "removeNurseNoteComment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], NurseNotesIpdController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, nurse_notes_ipd_entity_1.NurseNotesIpd]),
    __metadata("design:returntype", void 0)
], NurseNotesIpdController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_nurse_notes_ipd_details'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], NurseNotesIpdController.prototype, "findNurseNotesIpdDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v3/get_nurse_notes_ipd_details'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], NurseNotesIpdController.prototype, "findNurseNotesIpdDetail", null);
exports.NurseNotesIpdController = NurseNotesIpdController = __decorate([
    (0, common_1.Controller)('nurse-notes-ipd'),
    __metadata("design:paramtypes", [nurse_notes_ipd_service_1.NurseNotesIpdService])
], NurseNotesIpdController);
//# sourceMappingURL=nurse_notes_ipd.controller.js.map