"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewBillingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const nanoid_1 = require("nanoid");
let NewBillingService = class NewBillingService {
    constructor(connection, dynamicConnection, ServiceModel) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.ServiceModel = ServiceModel;
    }
    async create(createNewBillingDto, patient_id) {
        try {
            const [getAayushUniqueId] = await this.dynamicConnection.query(`select aayush_unique_id from patients where id = ?`, [patient_id]);
            const [getAdminPat_id] = await this.connection.query(`select id from patients where aayush_unique_id = ?`, [getAayushUniqueId.aayush_unique_id]);
            for (const charges_entity of createNewBillingDto) {
                const letters = charges_entity.department_id.match(/[A-Za-z]+/)?.[0] ?? '';
                let numbers = charges_entity.department_id.match(/\d+/)?.[0] ?? '';
                let adminNumbers;
                let query_key;
                switch (letters) {
                    case 'IPDN':
                        const [getAdminIpd] = await this.connection.query(`select id from ipd_details where hospital_id = ? and hospital_ipd_details_id = ?`, [charges_entity.Hospital_id, numbers]);
                        adminNumbers = getAdminIpd.id;
                        query_key = 'ipd_id';
                        break;
                    case 'OPDN':
                        const [getAdminOpd] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [charges_entity.Hospital_id, numbers]);
                        adminNumbers = getAdminOpd.id;
                        query_key = 'opd_id';
                        break;
                    case 'APPN':
                        const [getOpd_id] = await this.dynamicConnection.query(`select opd_details_id from visit_details left join appointment on visit_details.id = appointment.visit_details_id where appointment.id = ?`, [numbers]);
                        numbers = getOpd_id.opd_details_id;
                        const [AdminOpd] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [charges_entity.Hospital_id, numbers]);
                        adminNumbers = AdminOpd.id;
                        query_key = 'opd_id';
                        break;
                    default:
                        query_key = 'opd_id';
                        numbers = null;
                        adminNumbers = null;
                }
                const result = await this.dynamicConnection.query(`INSERT INTO patient_charges
  (date, ${query_key},  qty, charge_id, standard_charge,
   tpa_charge, tax, apply_charge, amount, note, patient_id, payment_status, total)
   VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                    charges_entity.date,
                    numbers,
                    charges_entity.qty,
                    charges_entity.charge_id,
                    charges_entity.standard_charge,
                    charges_entity.tpa_charge,
                    charges_entity.tax,
                    charges_entity.apply_charge,
                    charges_entity.amount,
                    charges_entity.note,
                    patient_id,
                    'unpaid',
                    charges_entity.amount,
                ]);
                const [charges] = await this.connection.query(`SELECT id FROM charges WHERE Hospital_id = ? AND hospital_charges_id = ?`, [charges_entity.Hospital_id, charges_entity.charge_id]);
                await this.connection.query(`INSERT INTO patient_charges
          (date, ${query_key},  qty, charge_id, standard_charge,
          tpa_charge, tax, apply_charge, amount, note, patient_id, Hospital_id,
          hos_patient_charges_id, payment_status, total)
         VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                    charges_entity.date,
                    adminNumbers,
                    charges_entity.qty,
                    charges.id,
                    charges_entity.standard_charge,
                    charges_entity.tpa_charge,
                    charges_entity.tax,
                    charges_entity.apply_charge,
                    charges_entity.amount,
                    charges_entity.note,
                    getAdminPat_id.id,
                    charges_entity.Hospital_id,
                    result.insertId,
                    'unpaid',
                    charges_entity.amount,
                ]);
            }
            console.log('admiin');
            return {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.PATIENT_CHARGES,
            };
        }
        catch (error) {
            console.log('error', error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll(patient_id, payment_module, bill_type, limit, page, search_text) {
        const sanitizedLimit = Number(limit);
        const sanitizedPage = Number(page);
        const offset = sanitizedLimit * (sanitizedPage - 1);
        const [patient_data] = await this.dynamicConnection.query(`
    SELECT 
      p.id, p.image, p.patient_name, p.gender, p.age, p.dob, p.mobileno, 
      p.guardian_name, p.emergency_mobile_no, p.marital_status, 
      p.aayush_unique_id, p.ABHA_number, p.email, 
      p.employer_name, p.employer_id, p.employee_id, 
      p.insurance_provider, bbp.name AS blood_bank_product_name, 
      p.communication_address, p.address 
    FROM patients p
    LEFT JOIN blood_bank_products bbp 
      ON bbp.id = p.blood_bank_product_id
    WHERE p.id = ?
    `, [patient_id]);
        const [abhaResult] = await this.connection.query(`
    SELECT abhaAddress 
    FROM patient_abha_address 
    WHERE patient_id = ? 
    ORDER BY created_at DESC 
    LIMIT 1
    `, [patient_id]);
        patient_data.pat_abha_address = abhaResult?.abhaAddress ?? '';
        const baseBillingQuery = `
    FROM appointment a
    LEFT JOIN visit_details vd ON vd.id = a.visit_details_id
    LEFT JOIN opd_details opd ON opd.id = vd.opd_details_id
    LEFT JOIN ipd_details ipd ON ipd.case_reference_id = a.case_reference_id
    LEFT JOIN staff s ON s.id = a.doctor
    LEFT JOIN patient_charges pc ON (
      pc.opd_id = opd.id OR pc.ipd_id = ipd.id
    )
    LEFT JOIN transactions ON transactions.patient_charges_id = pc.id
    LEFT JOIN charges c ON c.id = pc.charge_id
    LEFT JOIN charge_categories cc ON cc.id = c.charge_category_id
    LEFT JOIN charge_type_master ctm ON ctm.id = cc.charge_type_id
    WHERE pc.patient_id = ?
  `;
        const queryParams = [patient_id];
        const countParams = [patient_id];
        const filters = [];
        if (bill_type === 'due') {
            filters.push(`pc.payment_status <> 'paid'`);
        }
        else if (bill_type === 'paid') {
            filters.push(`pc.payment_status = 'paid'`);
        }
        if (payment_module) {
            const module = payment_module.toUpperCase();
            if (['OPD', 'IPD', 'APPOINTMENT'].includes(module)) {
                filters.push(`a.module = '${module}'`);
            }
            else {
                filters.push(`a.module = 'ABCD'`);
            }
        }
        if (search_text && search_text.trim() !== '') {
            const search = `%${search_text.trim()}%`;
            filters.push(`
      (
        CONCAT('APPN', a.id) LIKE ?
        OR s.name LIKE ?
        OR s.surname LIKE ?
      )
    `);
            queryParams.push(search, search, search);
            countParams.push(search, search, search);
        }
        const whereClause = filters.length ? ` AND ${filters.join(' AND ')}` : '';
        const billingQuery = `
    SELECT 
      CONCAT('APPN', a.id) AS appointment_id,
      a.module,
      CASE 
        WHEN a.module = 'OPD' THEN CONCAT('OPDN', opd.id)
        WHEN a.module = 'IPD' THEN CONCAT('IPDN', ipd.id)
        WHEN a.module = 'APPOINTMENT' THEN CONCAT('APPN', a.id)
        ELSE '-' 
      END AS department_id,
      ctm.charge_type,
      cc.name AS charge_category,
      s.name,
      s.surname,
      s.id AS doctor_id,
      a.case_reference_id AS case_id,
      pc.id AS patient_charge_id,
      DATE(pc.date) AS billed_date,
      TIME(pc.date) AS billed_time,
       pc.qty as Qty,
pc.standard_charge as standard, 
pc.apply_charge as Apply,
pc.discount_amount as Discount,
pc.discount_percentage,
pc.amount as sub_total,
pc.tax as TAX,
pc.total as Billed,
COALESCE(transactions.amount, 0) AS paid,
(pc.total - COALESCE(transactions.amount, 0)) as Due
    ${baseBillingQuery}
    ${whereClause}
    ORDER BY pc.date DESC
    LIMIT ? OFFSET ?
  `;
        const countQuery = `
    SELECT COUNT(pc.id) AS totalcount
    ${baseBillingQuery}
    ${whereClause}
  `;
        queryParams.push(sanitizedLimit);
        queryParams.push(offset);
        const billing_summary = await this.dynamicConnection.query(billingQuery, queryParams);
        const [count] = await this.dynamicConnection.query(countQuery, countParams);
        return {
            status: 'success',
            status_code: 200,
            message: 'data fetched successfully',
            data: {
                patient_data,
                billing_summary,
            },
            count: count.totalcount,
        };
    }
    async findtransactiondetails(patient_id, payment_module, limit, page) {
        try {
            const offset = limit * (page - 1);
            const [getAayushUniqueId] = await this.dynamicConnection.query(`select aayush_unique_id from patients where id = ${patient_id}`);
            console.log(getAayushUniqueId, 'getAayushUniqueId');
            const [getAdminPatientId] = await this.connection.query(`select id from patients where aayush_unique_id = ?`, [getAayushUniqueId.aayush_unique_id]);
            console.log(getAdminPatientId.id, 'getHosPatientId');
            let query = `select
  date(patient_charges.date) as billed_date,
  time(patient_charges.date) as billed_time,
    patient_charges.id as patient_charge_id,
date(transactions.payment_date) paid_date,
time(transactions.payment_date) paid_time,
            concat(COALESCE(transactions.net_banking_transaction_id,""),COALESCE(transactions.card_transaction_id,""),COALESCE(transactions.upi_transaction_id,""),
            COALESCE(transactions.payment_reference_number,""),
            COALESCE(transactions.cash_transaction_id,"")) payment_transaction_id,
            transactions.id plenome_transaction_id,
            transactions.hos_transaction_id hos_transaction_id,
            transactions.payment_mode,
            transactions.amount amount_paid
            from appointment
left join visit_details on visit_details.id = appointment.visit_details_id
left join opd_details on opd_details.id = visit_details.opd_details_id
left join ipd_details on ipd_details.case_reference_id = appointment.case_reference_id
left join patient_charges on (patient_charges.opd_id = opd_details.id or patient_charges.ipd_id = ipd_details.id)
left join transactions on transactions.id = patient_charges.transaction_id where transactions.patient_id = ${getAdminPatientId.id} `;
            let countquery = `select count(appointment.id) total from appointment
       left join visit_details on visit_details.id = appointment.visit_details_id
left join opd_details on opd_details.id = visit_details.opd_details_id
left join ipd_details on ipd_details.case_reference_id = appointment.case_reference_id
left join patient_charges on (patient_charges.opd_id = opd_details.id or patient_charges.ipd_id = ipd_details.id)
left join transactions on transactions.id = patient_charges.transaction_id where transactions.patient_id = ${getAdminPatientId.id}`;
            if (payment_module) {
                switch (payment_module) {
                    case 'opd':
                        query += ` and appointment.module = 'OPD'`;
                        countquery += ` and appointment.module = 'OPD'`;
                        break;
                    case 'ipd':
                        query += ` and appointment.module = 'IPD'`;
                        countquery += ` and appointment.module = 'IPD'`;
                        break;
                    case 'appointment':
                        query += ` and appointment.module = 'APPOINTMENT'`;
                        countquery += ` and appointment.module = 'APPOINTMENT'`;
                        break;
                    default:
                        query += ` and appointment.module = 'ABCD'`;
                        countquery += ` and appointment.module = 'ABCD'`;
                        break;
                }
            }
            console.log('lkjhgfdsa');
            let [count] = await this.connection.query(countquery);
            const transaction_data = await this.connection.query(query + `limit ${limit} offset ${offset}`);
            return {
                status: 'success',
                status_code: 200,
                message: 'data fetched successfully',
                data: transaction_data,
                count: count.total,
            };
        }
        catch (error) {
            console.log(error, 'lkjhgfd');
        }
    }
    async patient_wallet(patient_id) {
        const [patient_mobile_num] = await this.connection.query(`select mobileno from patients WHERE id = ?`, [patient_id]);
        const [value_per_coin] = await this.connection.query(`select * from coin_value order by created_at desc limit 1`);
        if (!patient_mobile_num || !patient_mobile_num.mobileno) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'No mobile number found for given patient_id',
            };
        }
        let num = patient_mobile_num.mobileno;
        if (num.length === 10) {
            num = `91${num}`;
        }
        const [existing_user] = await this.connection.query(`select id from users where username = ?`, [num]);
        if (existing_user) {
            console.log('User exists with number:', num);
            const aayush_coins = await this.connection.query(`select coalesce(sum(total_coins_remaining), 0) coins_remaining from aayush_coins where user_id = ${existing_user.id} and coins_usage <> 'fully_used'  and is_expired = 0`);
            aayush_coins[0].value_per_coin_details = value_per_coin;
            if (aayush_coins.length === 0) {
                return {
                    status: 'failed',
                    status_code: 201,
                    message: 'No Aayush coins available for the patient',
                };
            }
            return aayush_coins;
        }
        else {
            return {
                status: 'failed',
                status_code: 400,
                message: 'No user found with mobile number',
            };
        }
    }
    async coins_used(patient_id, coins_used) {
        coins_used = Number(coins_used);
        const [patient_mobile_num] = await this.dynamicConnection.query(`select mobileno from patients WHERE id = ?`, [patient_id]);
        if (!patient_mobile_num || !patient_mobile_num.mobileno) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'No mobile number found for given patient_id',
            };
        }
        let num = patient_mobile_num.mobileno;
        if (num.length === 10) {
            num = `91${num}`;
        }
        const [existing_user] = await this.connection.query(`select id from users where username = ?`, [num]);
        if (existing_user) {
            console.log('User exists with number:', num);
            const [total_aayush_coins] = await this.connection.query(`select coalesce(sum(total_coins_remaining), 0) coins_remaining from aayush_coins where user_id = ${existing_user.id} and coins_usage <> 'fully_used'  and is_expired = 0`);
            console.log(total_aayush_coins.coins_remaining, coins_used);
            console.log('total_aayush_coins.coins_remaining', total_aayush_coins.coins_remaining);
            if (Number(total_aayush_coins.coins_remaining) < coins_used) {
                return {
                    status: 'failed',
                    status_code: 400,
                    message: 'coins_used must be lesser than or equal to available coins',
                };
            }
            const aayush_coins = await this.connection.query(`select * from aayush_coins where user_id = ${existing_user.id} and coins_usage <> 'fully_used'  and is_expired = 0 order by created_at asc`);
            console.log(aayush_coins, 'aayush_coins');
            if (aayush_coins.length === 0) {
                return {
                    status: 'failed',
                    status_code: 201,
                    message: 'No Aayush coins available for the patient',
                };
            }
            console.log(typeof coins_used), 'coins_used';
            for (const a of aayush_coins) {
                if (coins_used > 0) {
                    if (Number(a.total_coins_remaining) <= coins_used) {
                        let total_coins_used = Number(a.total_coins_used) + Number(a.total_coins_remaining);
                        const query = await this.connection.query(`update aayush_coins set total_coins_remaining = 0, total_coins_used = ${total_coins_used}, coins_usage= 'fully_used' where id = ?`, [Number(a.id)]);
                        coins_used = coins_used - Number(a.total_coins_remaining);
                    }
                    else {
                        let total_coins_remaining = Number(a.total_coins_remaining) - coins_used;
                        let total_coins_used = Number(a.total_coins_used) + Number(coins_used);
                        const query = await this.connection.query(`update aayush_coins set total_coins_remaining = ${total_coins_remaining}, total_coins_used = ${total_coins_used}, coins_usage= 'partially_used' where id = ?`, [Number(a.id)]);
                        coins_used = coins_used - Number(a.total_coins_remaining);
                    }
                }
            }
            return aayush_coins;
        }
        else {
            return {
                status: 'failed',
                status_code: 400,
                message: 'No user found with mobile number',
            };
        }
    }
    async mongodata(Entity) {
        const response = new this.ServiceModel({
            hospital_id: Entity.hospital_id,
            patient_aayush_id: Entity.patient_aayush_id,
            plenome_transaction_id: Entity.plenome_transaction_id,
            hos_transaction_id: Entity.hos_transaction_id,
            transaction_details: Entity.transaction_details,
            patient_details: Entity.patient_details,
            primary_cons_doctor: Entity.primary_cons_doctor,
            last_cons_doctor: Entity.last_cons_doctor,
            amount_paid: Entity.amount_paid,
            payment_mode: Entity.payment_mode,
            payment_status: Entity.payment_status,
            payment_transaction_id: Entity.payment_transaction_id,
            created_at: new Date(),
        });
        let result = await response.save();
        return result;
    }
    async makePaymentV3(Entity) {
        if (Entity.payment_mode == 'online') {
            if (!Entity.payment_gateway) {
                return {
                    status: process.env.ERROR_STATUS,
                    message: process.env.PAYMENT_GATEWAY,
                };
            }
            if (Entity.payment_gateway.toLocaleLowerCase() == 'razorpay') {
                if (!Entity.payment_reference_number || !Entity.payment_id) {
                    if (!Entity.payment_reference_number) {
                        Entity.payment_reference_number = 'NA';
                    }
                    if (!Entity.payment_id) {
                        Entity.payment_id = 'NA';
                    }
                    return {
                        status: process.env.ERROR_STATUS,
                        message: process.env.PAYMENT_REFERENCE,
                    };
                }
            }
        }
        let getVal = Entity.paymentDetails;
        const ids = getVal.map((item) => item.patient_charge_id);
        console.log(ids, 'patient_charge_id');
        let amount = Number(Entity.totalDue);
        console.log(amount, 'amount');
        let calculated_amt = 0;
        for (const a of ids) {
            const [new_amt] = await this.dynamicConnection.query(`select (amount - temp_amount) amt from patient_charges where id = ${a}`);
            calculated_amt = calculated_amt + Number(new_amt.amt);
        }
        console.log(calculated_amt, 'calculated_amt');
        if (calculated_amt > amount) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'due amount exceeds the given amount',
            };
        }
        if (Entity.payment_mode.toLocaleLowerCase() == 'cash') {
            const generateUpperAlphaNumId = (0, nanoid_1.customAlphabet)('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', 10);
            Entity.cash_transaction_id = generateUpperAlphaNumId();
        }
        const firstSectionId = getVal[0]?.department_id;
        const allSameSectionId = getVal.every((charge) => charge.department_id === firstSectionId);
        const letters = firstSectionId.match(/[A-Za-z]+/)?.[0] ?? '';
        let numbers = firstSectionId.match(/\d+/)?.[0] ?? '';
        let sectionIdName;
        let idkey;
        let adminKey;
        if (!allSameSectionId) {
            sectionIdName = 'Payment';
            idkey = 'appointment_id';
            adminKey = null;
            numbers = null;
        }
        else {
            switch (letters) {
                case 'APPN':
                    sectionIdName = 'Appointment';
                    idkey = 'appointment_id';
                    const [getAdminAppId] = await this.connection.query(`select id from appointment where Hospital_id = ? and hos_appointment_id = ?`, [Entity.Hospital_id, numbers]);
                    console.log(getAdminAppId, 'getAdminAppId');
                    adminKey = getAdminAppId.id;
                    break;
                case 'OPDN':
                    sectionIdName = 'OPD';
                    idkey = 'opd_id';
                    const [getAdminOpdId] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [Entity.Hospital_id, numbers]);
                    adminKey = getAdminOpdId.id;
                    break;
                case 'IPDN':
                    sectionIdName = 'IPD';
                    idkey = 'ipd_id';
                    const [getAdminIpdId] = await this.connection.query(`select id from ipd_details where hospital_id = ? and hospital_ipd_details_id = ?`, [Entity.Hospital_id, numbers]);
                    adminKey = getAdminIpdId.id;
                    break;
            }
        }
        try {
            if (!Entity.txn_id) {
                Entity.txn_id = 'NA';
            }
            if (!Entity.bank_ref_id) {
                Entity.bank_ref_id = 'NA';
            }
            if (!Entity.pg_ref_id) {
                Entity.pg_ref_id = 'NA';
            }
            try {
                console.log('ccccc');
                await this.dynamicConnection.query(`ALTER TABLE \`transactions\` 
    ADD COLUMN \`payment_method\`            VARCHAR(45)  NULL AFTER \`received_by_name\`,
    ADD COLUMN \`card_division\`             VARCHAR(255) NULL AFTER \`payment_method\`,
    ADD COLUMN \`card_type\`                 VARCHAR(255) NULL AFTER \`card_division\`,
    ADD COLUMN \`card_transaction_id\`       VARCHAR(255) NULL AFTER \`card_type\`,
    ADD COLUMN \`card_bank_name\`            VARCHAR(255) NULL AFTER \`card_transaction_id\`,
    ADD COLUMN \`net_banking_division\`      VARCHAR(255) NULL AFTER \`card_bank_name\`,
    ADD COLUMN \`net_banking_transaction_id\` VARCHAR(255) NULL AFTER \`net_banking_division\`,
    ADD COLUMN \`upi_id\`                    VARCHAR(255) NULL AFTER \`net_banking_transaction_id\`,
    ADD COLUMN \`upi_bank_name\`             VARCHAR(255) NULL AFTER \`upi_id\`,
    ADD COLUMN \`upi_transaction_id\`        VARCHAR(255) NULL AFTER \`upi_bank_name\`,
      ADD COLUMN \`cash_transaction_id\`     VARCHAR(255) NULL AFTER \`upi_transaction_id\`,
  ;`);
                console.log('ggggg');
            }
            catch (error) {
                console.log('error in adding new columns to transactions table');
            }
            try {
                console.log('oiuytre');
                await this.connection.query(`ALTER TABLE \`transactions\` 
    ADD COLUMN \`payment_method\`            VARCHAR(45)  NULL AFTER \`received_by_name\`,
    ADD COLUMN \`card_division\`             VARCHAR(255) NULL AFTER \`payment_method\`,
    ADD COLUMN \`card_type\`                 VARCHAR(255) NULL AFTER \`card_division\`,
    ADD COLUMN \`card_transaction_id\`       VARCHAR(255) NULL AFTER \`card_type\`,
    ADD COLUMN \`card_bank_name\`            VARCHAR(255) NULL AFTER \`card_transaction_id\`,
    ADD COLUMN \`net_banking_division\`      VARCHAR(255) NULL AFTER \`card_bank_name\`,
    ADD COLUMN \`net_banking_transaction_id\` VARCHAR(255) NULL AFTER \`net_banking_division\`,
    ADD COLUMN \`upi_id\`                    VARCHAR(255) NULL AFTER \`net_banking_transaction_id\`,
    ADD COLUMN \`upi_bank_name\`             VARCHAR(255) NULL AFTER \`upi_id\`,
    ADD COLUMN \`upi_transaction_id\`        VARCHAR(255) NULL AFTER \`upi_bank_name\`,
      ADD COLUMN \`cash_transaction_id\`     VARCHAR(255) NULL AFTER \`upi_transaction_id\`,
  ;`);
                console.log('lkjhgfds');
            }
            catch (error) {
                console.log('error in adding new columns to transactions table');
            }
            const insertTransaction = await this.dynamicConnection.query(`insert into transactions (
          txn_id,
          pg_ref_id,
          bank_ref_id,
          type,
          patient_id,
          amount,
          payment_mode,
          section,
          payment_date,
          received_by_name,
          payment_method,
          card_division,
          card_type,
          card_transaction_id,
          card_bank_name,
          net_banking_division,
          net_banking_transaction_id,
          upi_id,
          upi_bank_name,
          upi_transaction_id,
          payment_reference_number,
          payment_gateway,
          payment_id,
          actual_paid_amount,
          wallet_paid_amount,
          ${idkey}
          ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                Entity.txn_id,
                Entity.pg_ref_id,
                Entity.bank_ref_id,
                'payment',
                Entity.patient_id,
                amount,
                Entity.payment_mode,
                sectionIdName,
                Entity.payment_date,
                Entity.received_by_name,
                Entity.payment_method,
                Entity.card_division,
                Entity.card_type,
                Entity.card_transaction_id,
                Entity.card_bank_name,
                Entity.net_banking_division,
                Entity.net_banking_transaction_id,
                Entity.upi_id,
                Entity.upi_bank_name,
                Entity.upi_transaction_id,
                Entity.payment_reference_number,
                Entity.payment_gateway,
                Entity.payment_id,
                Entity.actual_amount_paid,
                Entity.amount_from_coins,
                numbers,
            ]);
            const [getPatMobileno] = await this.dynamicConnection.query(`select aayush_unique_id from patients where id = ?`, [Entity.patient_id]);
            const [getAdminPatientId] = await this.connection.query(`select id from patients where aayush_unique_id = ?`, [getPatMobileno.aayush_unique_id]);
            const AdmininsertTransaction = await this.connection.query(`insert into transactions (
        txn_id,
        pg_ref_id,
        bank_ref_id,
        type,
        patient_id,
        amount,
        payment_mode,
        Hospital_id,
        hos_transaction_id,
        section,
        payment_date,
        received_by_name,
        payment_method,
          card_division,
          card_type,
          card_transaction_id,
          card_bank_name,
          net_banking_division,
          net_banking_transaction_id,
          upi_id,
          upi_bank_name,
          upi_transaction_id,
          payment_reference_number,
          payment_gateway,
          payment_id,
          actual_paid_amount,
          wallet_paid_amount,
        ${idkey}
          ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                Entity.txn_id,
                Entity.pg_ref_id,
                Entity.bank_ref_id,
                'payment',
                getAdminPatientId.id,
                amount,
                Entity.payment_mode,
                Entity.Hospital_id,
                insertTransaction.insertId,
                sectionIdName,
                Entity.payment_date,
                Entity.received_by_name,
                Entity.payment_method,
                Entity.card_division,
                Entity.card_type,
                Entity.card_transaction_id,
                Entity.card_bank_name,
                Entity.net_banking_division,
                Entity.net_banking_transaction_id,
                Entity.upi_id,
                Entity.upi_bank_name,
                Entity.upi_transaction_id,
                Entity.payment_reference_number,
                Entity.payment_gateway,
                Entity.payment_id,
                Entity.actual_amount_paid,
                Entity.amount_from_coins,
                adminKey,
            ]);
            for (const id of ids) {
                try {
                    let [getAdminChargeId] = await this.connection.query(`select id from patient_charges where Hospital_id = ? and hos_patient_charges_id = ?`, [Entity.Hospital_id, id]);
                    await this.dynamicConnection.query(`update patient_charges set payment_status = ?,transaction_id = ? where id = ?`, ['paid', insertTransaction.insertId, id]);
                    this.connection.query(`update patient_charges set payment_status = ?,transaction_id = ? where id = ?`, ['paid', AdmininsertTransaction.insertId, getAdminChargeId.id]);
                }
                catch (error) {
                    console.log(error, 'error');
                }
            }
            const [getLastConsDoctor] = await this.dynamicConnection.query(`select staff.name, staff.surname, staff.employee_id from staff
         left join appointment on appointment.doctor = staff.id where appointment.patient_id = ${Entity.patient_id}
          and date(appointment.date) < date(now()) and  appointment.doctor order by appointment.date desc, appointment.time desc limit 1`);
            const [FrequentVisitDoctorId] = await this.dynamicConnection.query(`select count(id) count,doctor from appointment where patient_id = ? and doctor group by doctor order by count desc limit 1`, [Entity.patient_id]);
            const [getPrimaryConsDoctor] = await this.dynamicConnection.query(`select staff.name, staff.surname, staff.employee_id from staff  where id = ?`, [FrequentVisitDoctorId.doctor]);
            const mongoBody = {
                hospital_id: Entity.Hospital_id,
                patient_aayush_id: getPatMobileno.aayush_unique_id,
                hos_transaction_id: insertTransaction.insertId,
                plenome_transaction_id: AdmininsertTransaction.insertId,
                transaction_details: Entity.paymentDetails,
                patient_details: Entity.patient_details,
                primary_cons_doctor: getPrimaryConsDoctor,
                last_cons_doctor: getLastConsDoctor,
                amount_paid: amount,
                payment_mode: Entity.payment_mode,
                payment_status: 'success',
                payment_transaction_id: Entity.upi_transaction_id +
                    Entity.net_banking_transaction_id +
                    Entity.card_transaction_id +
                    Entity.cash_transaction_id +
                    Entity.payment_reference_number,
            };
            this.mongodata(mongoBody);
            return {
                status: 'success',
                message: 'payment done successfully',
                transactionId: 'TRID' + insertTransaction.insertId,
            };
        }
        catch (error) {
            console.log(error, 'error');
            return error;
        }
    }
    async get_transaction_details(hospital_id, hos_transaction_id) {
        try {
            const data = await this.ServiceModel.find({
                hospital_id: hospital_id,
                hos_transaction_id: hos_transaction_id,
            });
            return {
                status: 'success',
                status_code: 200,
                message: 'data fetched successfully',
                data: data,
            };
        }
        catch (error) {
            return {
                status: 'failed',
                status_code: 500,
                message: 'API SERVICE UNAVAILABLE TEMPORARYILY',
            };
        }
    }
    async add_overall_charges(aayush_unique_id, hospital_id, body) {
        if (!body.due_amount) {
            body.due_amount = null;
        }
        if (!body.overall_subtotal_amount) {
            body.overall_subtotal_amount = null;
        }
        if (!body.total_billed_amount) {
            body.total_billed_amount = null;
        }
        if (!body.total_tax_amount) {
            body.total_tax_amount = null;
        }
        try {
            const [hos_pat_id] = await this.dynamicConnection.query(`select id from patients where aayush_unique_id= ?`, [aayush_unique_id]);
            const [admin_pat_id] = await this.connection.query(`select id, mobileno from patients where aayush_unique_id = ?`, [aayush_unique_id]);
            const [admin_user_id] = await this.connection.query(`select id from users where username = ?`, [91 + admin_pat_id.mobileno]);
            console.log(admin_user_id, 'admin_user_id');
            let user_id;
            const hospital_patient_id = hos_pat_id.id;
            const admin_patient_id = admin_pat_id.id;
            if (!admin_user_id) {
                console.log('if');
                const user = await this.connection.query(`insert into users (username,role) values (?, ?)`, [91 + admin_pat_id.mobileno, 'patient']);
                user_id = user.insertId;
            }
            else {
                console.log('ifif');
                user_id = admin_user_id.id;
            }
            console.log('summa');
            const [check_user_payment_summary] = await this.connection.query(`select id from user_payment_summary where user_id = ?`, [user_id]);
            console.log('sum');
            let user_payment_summary_id;
            if (!check_user_payment_summary) {
                const insert_ad = await this.connection.query(`insert into user_payment_summary (user_id, wallet_amount_paid, paid_amount, due_amount, actual_amount_paid,total_online_payments, total_offline_payments, total_billed_amount, total_tax_amount, overall_subtotal_amount) values (?, 0,0,0,0,0,0,0,0,0)`, [user_id]);
                user_payment_summary_id = insert_ad.insertId;
            }
            else {
                user_payment_summary_id = check_user_payment_summary.id;
            }
            console.log('use', user_payment_summary_id);
            const [getExisting] = await this.connection.query(`select * from user_payment_summary where id = ?`, [user_payment_summary_id]);
            console.log('jjj');
            const existingDueAmt = Number(getExisting.due_amount) || 0;
            console.log(existingDueAmt, 'existingDueAmt');
            const existingTotalBilledAmt = Number(getExisting.total_billed_amount) || 0;
            console.log(existingTotalBilledAmt, 'existingTotalBilledAmt');
            const existingTotalTaxAmt = Number(getExisting.total_tax_amount) || 0;
            console.log(existingTotalTaxAmt, 'existingTotalTaxAmt');
            const existingOverallSubtotalAmt = Number(getExisting.overall_subtotal_amount) || 0;
            console.log(existingOverallSubtotalAmt, 'existingOverallSubtotalAmt');
            const NewDueAmt = existingDueAmt + Number(body.due_amount);
            console.log(NewDueAmt, 'NewDueAmt');
            const NewTotalBilledAmt = existingTotalBilledAmt + Number(body.total_billed_amount);
            console.log(NewTotalBilledAmt, 'NewTotalBilledAmt');
            const NewTotalTaxAmt = existingTotalTaxAmt + Number(body.total_tax_amount);
            console.log(NewTotalTaxAmt, 'NewTotalTaxAmt');
            const NewOverallSubtotalAmt = existingOverallSubtotalAmt + Number(body.overall_subtotal_amount);
            console.log(NewOverallSubtotalAmt, 'NewOverallSubtotalAmt');
            const updated_data = await this.connection.query(`update user_payment_summary set due_amount = ?,total_billed_amount = ?,total_tax_amount = ?,overall_subtotal_amount = ? where id = ?`, [
                NewDueAmt,
                NewTotalBilledAmt,
                NewTotalTaxAmt,
                NewOverallSubtotalAmt,
                user_payment_summary_id,
            ]);
            let patient_id = admin_patient_id;
            const [check_patient_payment_summary] = await this.connection.query(`select id from patient_payment_summary where patient_id = ?`, [patient_id]);
            let patient_payment_summary_id;
            if (!check_patient_payment_summary) {
                const insert_ad = await this.connection.query(`insert into patient_payment_summary (patient_id, wallet_amount_paid, paid_amount, due_amount, actual_amount_paid,total_online_payments, total_offline_payments, total_billed_amount, total_tax_amount, overall_subtotal_amount) values (?, 0,0,0,0,0,0,0,0,0)`, [patient_id]);
                patient_payment_summary_id = insert_ad.insertId;
            }
            else {
                patient_payment_summary_id = check_patient_payment_summary.id;
            }
            const [getExistingPat] = await this.connection.query(`select * from patient_payment_summary where id = ?`, [patient_payment_summary_id]);
            const existingDueAmt1 = Number(getExistingPat.due_amount) || 0;
            const existingTotalBilledAmt1 = Number(getExistingPat.total_billed_amount) || 0;
            const existingTotalTaxAmt1 = Number(getExistingPat.total_tax_amount) || 0;
            const existingOverallSubtotalAmt1 = Number(getExistingPat.overall_subtotal_amount) || 0;
            const NewDueAmt1 = existingDueAmt1 + Number(body.due_amount);
            const NewTotalBilledAmt1 = existingTotalBilledAmt1 + Number(body.total_billed_amount);
            const NewTotalTaxAmt1 = existingTotalTaxAmt1 + Number(body.total_tax_amount);
            const NewOverallSubtotalAmt1 = existingOverallSubtotalAmt1 + Number(body.overall_subtotal_amount);
            const updated_data1 = await this.connection.query(`update patient_payment_summary set due_amount = ?,total_billed_amount = ?,total_tax_amount = ?,overall_subtotal_amount = ? where id = ?`, [
                NewDueAmt1,
                NewTotalBilledAmt1,
                NewTotalTaxAmt1,
                NewOverallSubtotalAmt1,
                patient_payment_summary_id,
            ]);
            const [hos_check_patient_payment_summary] = await this.dynamicConnection.query(`select id from patient_payment_summary where patient_id = ?`, [hospital_patient_id]);
            let hos_patient_payment_summary_id;
            if (!hos_check_patient_payment_summary) {
                const insert_ad = await this.dynamicConnection.query(`insert into patient_payment_summary (patient_id, wallet_amount_paid, paid_amount, due_amount, actual_amount_paid,total_online_payments, total_offline_payments, total_billed_amount, total_tax_amount, overall_subtotal_amount) values (?, 0,0,0,0,0,0,0,0,0)`, [hospital_patient_id]);
                hos_patient_payment_summary_id = insert_ad.insertId;
            }
            else {
                hos_patient_payment_summary_id = hos_check_patient_payment_summary.id;
            }
            const updated_data2 = await this.dynamicConnection.query(`update patient_payment_summary set due_amount = ?,total_billed_amount = ?,total_tax_amount = ?,overall_subtotal_amount = ? where id = ?`, [
                NewDueAmt1,
                NewTotalBilledAmt1,
                NewTotalTaxAmt1,
                NewOverallSubtotalAmt1,
                hos_patient_payment_summary_id,
            ]);
            const [check_hospital_payment_summary] = await this.connection.query(`select id from hospital_payment_summary where hospital_id = ?`, [hospital_id]);
            let hos_payment_summary_id;
            if (!check_hospital_payment_summary) {
                const insert_ad = await this.connection.query(`insert into hospital_payment_summary (hospital_id, wallet_amount_paid, paid_amount, due_amount, actual_amount_paid,total_online_payments, total_offline_payments, total_billed_amount, total_tax_amount, overall_subtotal_amount) values (?, 0,0,0,0,0,0,0,0,0)`, [hospital_id]);
                hos_payment_summary_id = insert_ad.insertId;
            }
            else {
                hos_payment_summary_id = check_hospital_payment_summary.id;
            }
            const [getExistingPaymentid] = await this.connection.query(`select * from hospital_payment_summary where id = ?`, [hos_payment_summary_id]);
            const hosexistingDueAmt1 = Number(getExistingPaymentid.due_amount) || 0;
            const hosexistingTotalBilledAmt1 = Number(getExistingPaymentid.total_billed_amount) || 0;
            const hosexistingTotalTaxAmt1 = Number(getExistingPaymentid.total_tax_amount) || 0;
            const hosexistingOverallSubtotalAmt1 = Number(getExistingPaymentid.overall_subtotal_amount) || 0;
            const hosNewDueAmt1 = hosexistingDueAmt1 + Number(body.due_amount);
            const hosNewTotalBilledAmt1 = hosexistingTotalBilledAmt1 + Number(body.total_billed_amount);
            const hosNewTotalTaxAmt1 = hosexistingTotalTaxAmt1 + Number(body.total_tax_amount);
            const hosNewOverallSubtotalAmt1 = hosexistingOverallSubtotalAmt1 + Number(body.overall_subtotal_amount);
            const hos_updated_data1 = await this.connection.query(`update hospital_payment_summary set due_amount = ?,total_billed_amount = ?,total_tax_amount = ?,overall_subtotal_amount = ? where id = ?`, [
                hosNewDueAmt1,
                hosNewTotalBilledAmt1,
                hosNewTotalTaxAmt1,
                hosNewOverallSubtotalAmt1,
                hos_payment_summary_id,
            ]);
            return {
                status: 'success',
                status_code: 200,
                message: 'payment added successfully',
            };
        }
        catch (error) {
            console.log(error, 'err');
            return {
                status: 'failed',
                status_code: 500,
                message: 'API SERVICE UNAVAILABLE TEMPORARYILY',
            };
        }
    }
    async finddepartment_id(patient_id, hospital_id) {
        const appointment = `
    SELECT
      CASE
        WHEN appointment.module = 'appointment' THEN CONCAT('APPN', appointment.id)
        WHEN appointment.module = 'OPD' THEN CONCAT('OPDN', opd_details.id)
      END AS department_id
    FROM appointment
    LEFT JOIN visit_details ON appointment.visit_details_id = visit_details.id
    LEFT JOIN opd_details ON visit_details.opd_details_id = opd_details.id
    LEFT JOIN patients ON appointment.patient_id = patients.id
    WHERE patients.id = ?
      AND appointment.module != 'IPD'
      AND appointment_status NOT IN (4,6)
  `;
        const ipd = `
     SELECT distinct CONCAT('IPDN', ipd_details.id) AS department_id
    FROM ipd_details
    left join patients on ipd_details.patient_id = patients.id
    left join appointment on appointment.patient_id = patients.id
    WHERE patients.id = ? AND appointment_status NOT IN (4,6)
  `;
        const app = await this.dynamicConnection.query(appointment, [patient_id]);
        const many = await this.dynamicConnection.query(ipd, [patient_id]);
        const final_result = [...app, ...many];
        return final_result;
    }
    async update_overall_charges(aayush_unique_id, hospital_id, body) {
        if (!body.wallet_amount_paid) {
            body.wallet_amount_paid = null;
        }
        if (!body.paid_amount) {
            body.paid_amount = null;
        }
        if (!body.actual_amount_paid) {
            body.actual_amount_paid = null;
        }
        if (!body.total_online_payments) {
            body.total_online_payments = null;
        }
        if (!body.total_offline_payments) {
            body.total_offline_payments = null;
        }
        try {
            const [hos_pat_id] = await this.dynamicConnection.query(`select id from patients where aayush_unique_id= ?`, [aayush_unique_id]);
            const [admin_pat_id] = await this.connection.query(`select id, mobileno from patients where aayush_unique_id = ?`, [aayush_unique_id]);
            const [admin_user_id] = await this.connection.query(`select id from users where username = ?`, [91 + admin_pat_id.mobileno]);
            console.log(admin_user_id, 'admin_user_id');
            let user_id;
            const hospital_patient_id = hos_pat_id.id;
            const admin_patient_id = admin_pat_id.id;
            if (!admin_user_id) {
                console.log('if');
                const user = await this.connection.query(`insert into users (username,role) values (?, ?)`, [91 + admin_pat_id.mobileno, 'patient']);
                user_id = user.insertId;
            }
            else {
                console.log('ifif');
                user_id = admin_user_id.id;
            }
            const [user_coins] = await this.connection.query(`select sum(total_coins_remaining) coinsAvailable from aayush_coins where user_id = ?`, [user_id]);
            if (Number(user_coins.coinsAvailable) < body.wallet_amount_paid) {
                return {
                    status: 'failed',
                    status_code: 400,
                    message: 'Available coins lesser than the given coins.',
                };
            }
            console.log('summa');
            const [check_user_payment_summary] = await this.connection.query(`select id from user_payment_summary where user_id = ?`, [user_id]);
            console.log('sum');
            let user_payment_summary_id;
            if (check_user_payment_summary) {
                user_payment_summary_id = check_user_payment_summary.id;
            }
            else {
                return {
                    status_code: 400,
                    status: 'failed',
                    message: 'Add charges for user to proceed for payment',
                };
            }
            console.log('use', user_payment_summary_id);
            const [getExisting] = await this.connection.query(`select * from user_payment_summary where id = ?`, [user_payment_summary_id]);
            console.log('jjj');
            const due = Number(getExisting.due_amount) || 0;
            console.log(due, 'due');
            const existingDueAmt = Number(getExisting.wallet_amount_paid) || 0;
            console.log(existingDueAmt, 'existingDueAmt');
            const existingTotalBilledAmt = Number(getExisting.paid_amount) || 0;
            console.log(existingTotalBilledAmt, 'existingTotalBilledAmt');
            const existingTotalTaxAmt = Number(getExisting.actual_amount_paid) || 0;
            console.log(existingTotalTaxAmt, 'existingTotalTaxAmt');
            const existingOverallSubtotalAmt = Number(getExisting.total_online_payments) || 0;
            console.log(existingOverallSubtotalAmt, 'existingOverallSubtotalAmt');
            const existingOverallSubtotalAmtoff = Number(getExisting.total_offline_payments) || 0;
            console.log(existingOverallSubtotalAmt, 'existingOverallSubtotalAmt');
            const reducedDue = due - Number(body.paid_amount);
            const NewDueAmt = existingDueAmt + Number(body.wallet_amount_paid);
            console.log(NewDueAmt, 'NewDueAmt');
            const NewTotalBilledAmt = existingTotalBilledAmt + Number(body.paid_amount);
            console.log(NewTotalBilledAmt, 'NewTotalBilledAmt');
            const NewTotalTaxAmt = existingTotalTaxAmt + Number(body.actual_amount_paid);
            console.log(NewTotalTaxAmt, 'NewTotalTaxAmt');
            const NewOverallSubtotalAmt = existingOverallSubtotalAmt + Number(body.total_online_payments);
            console.log(NewOverallSubtotalAmt, 'NewOverallSubtotalAmt');
            const NewOverallSubtotalAmtoff = existingOverallSubtotalAmtoff + Number(body.total_offline_payments);
            console.log(NewOverallSubtotalAmt, 'NewOverallSubtotalAmt');
            const updated_data = await this.connection.query(`update user_payment_summary set wallet_amount_paid = ?,due_amount = ?,paid_amount = ?,actual_amount_paid = ?,total_online_payments = ?, total_offline_payments = ? where id = ?`, [
                NewDueAmt,
                reducedDue,
                NewTotalBilledAmt,
                NewTotalTaxAmt,
                NewOverallSubtotalAmt,
                NewOverallSubtotalAmtoff,
                user_payment_summary_id,
            ]);
            let patient_id = admin_patient_id;
            const [check_patient_payment_summary] = await this.connection.query(`select id from patient_payment_summary where patient_id = ?`, [patient_id]);
            let patient_payment_summary_id;
            if (check_patient_payment_summary) {
                patient_payment_summary_id = check_patient_payment_summary.id;
            }
            const [getExistingPat] = await this.connection.query(`select * from patient_payment_summary where id = ?`, [patient_payment_summary_id]);
            const due1 = Number(getExistingPat.due_amount) || 0;
            const existingDueAmt1 = Number(getExistingPat.wallet_amount_paid) || 0;
            const existingTotalBilledAmt1 = Number(getExistingPat.paid_amount) || 0;
            const existingTotalTaxAmt1 = Number(getExistingPat.actual_amount_paid) || 0;
            const existingOverallSubtotalAmt1 = Number(getExistingPat.total_online_payments) || 0;
            const existingOverallSubtotalAmt1off = Number(getExistingPat.total_offline_payments) || 0;
            const NewDueAmt1 = existingDueAmt1 + Number(body.wallet_amount_paid);
            const reducedDue1 = due1 - Number(body.paid_amount);
            const NewTotalBilledAmt1 = existingTotalBilledAmt1 + Number(body.paid_amount);
            const NewTotalTaxAmt1 = existingTotalTaxAmt1 + Number(body.actual_amount_paid);
            const NewOverallSubtotalAmt1 = existingOverallSubtotalAmt1 + Number(body.total_online_payments);
            const NewOverallSubtotalAmt1off = existingOverallSubtotalAmt1off + Number(body.total_offline_payments);
            const updated_data1 = await this.connection.query(`update patient_payment_summary set wallet_amount_paid = ?,due_amount = ?,paid_amount = ?,actual_amount_paid = ?,total_online_payments = ?, total_offline_payments = ? where id = ?`, [
                NewDueAmt1,
                reducedDue1,
                NewTotalBilledAmt1,
                NewTotalTaxAmt1,
                NewOverallSubtotalAmt1,
                NewOverallSubtotalAmt1off,
                patient_payment_summary_id,
            ]);
            const [hos_check_patient_payment_summary] = await this.dynamicConnection.query(`select id from patient_payment_summary where patient_id = ?`, [hospital_patient_id]);
            let hos_patient_payment_summary_id;
            if (hos_check_patient_payment_summary) {
                hos_patient_payment_summary_id = hos_check_patient_payment_summary.id;
            }
            const updated_data2 = await this.dynamicConnection.query(`update patient_payment_summary set wallet_amount_paid = ?,due_amount = ?,paid_amount = ?,actual_amount_paid = ?,total_online_payments = ?, total_offline_payments = ? where id = ?`, [
                NewDueAmt1,
                reducedDue1,
                NewTotalBilledAmt1,
                NewTotalTaxAmt1,
                NewOverallSubtotalAmt1,
                NewOverallSubtotalAmt1off,
                hos_patient_payment_summary_id,
            ]);
            const [check_hos_payment_summary] = await this.connection.query(`select id from hospital_payment_summary where hospital_id = ?`, [hospital_id]);
            let Hospital_payment_summary_id;
            if (check_hos_payment_summary) {
                Hospital_payment_summary_id = check_hos_payment_summary.id;
            }
            const [getExistinghos] = await this.connection.query(`select * from hospital_payment_summary where id = ?`, [Hospital_payment_summary_id]);
            const hosdue1 = Number(getExistinghos.due_amount) || 0;
            const hosexistingDueAmt1 = Number(getExistinghos.wallet_amount_paid) || 0;
            const hosexistingTotalBilledAmt1 = Number(getExistinghos.paid_amount) || 0;
            const hosexistingTotalTaxAmt1 = Number(getExistinghos.actual_amount_paid) || 0;
            const hosexistingOverallSubtotalAmt1 = Number(getExistinghos.total_online_payments) || 0;
            const hosexistingOverallSubtotalAmt1off = Number(getExistinghos.total_offline_payments) || 0;
            const hosNewDueAmt1 = hosexistingDueAmt1 + Number(body.wallet_amount_paid);
            const hosreducedDue1 = hosdue1 - Number(body.paid_amount);
            const hosNewTotalBilledAmt1 = hosexistingTotalBilledAmt1 + Number(body.paid_amount);
            const hosNewTotalTaxAmt1 = hosexistingTotalTaxAmt1 + Number(body.actual_amount_paid);
            const hosNewOverallSubtotalAmt1 = hosexistingOverallSubtotalAmt1 + Number(body.total_online_payments);
            const hosNewOverallSubtotalAmt1off = hosexistingOverallSubtotalAmt1off + Number(body.total_offline_payments);
            const hos_updated_data1 = await this.connection.query(`update hospital_payment_summary set wallet_amount_paid = ?,due_amount = ?,paid_amount = ?,actual_amount_paid = ?,total_online_payments = ?, total_offline_payments = ? where id = ?`, [
                hosNewDueAmt1,
                hosreducedDue1,
                hosNewTotalBilledAmt1,
                hosNewTotalTaxAmt1,
                hosNewOverallSubtotalAmt1,
                hosNewOverallSubtotalAmt1off,
                Hospital_payment_summary_id,
            ]);
            return {
                status: 'success',
                status_code: 200,
                message: 'payment updated successfully',
            };
        }
        catch (error) {
            return {
                status: 'failed',
                status_code: 500,
                message: 'API SERVICE UNAVAILABLE TEMPORARYILY',
            };
        }
    }
    async overall_dashboard_data(limit, page, payment_status, search) {
        const offset = limit * (page - 1);
        const statusCase = `
    CASE 
      WHEN pps.total_billed_amount <= COALESCE(pps.paid_amount, 0) THEN 'paid'
      WHEN pps.total_billed_amount > COALESCE(pps.paid_amount, 0) AND COALESCE(pps.paid_amount, 0) > 0 THEN 'partially_paid'
      WHEN pps.total_billed_amount > COALESCE(pps.paid_amount, 0) AND COALESCE(pps.paid_amount, 0) = 0 THEN 'due'
      ELSE null
    END
  `;
        const filters = [];
        const params = [];
        if (payment_status) {
            filters.push(`${statusCase} = ?`);
            params.push(payment_status);
        }
        if (search) {
            filters.push(`(p.patient_name LIKE ? OR p.mobileno LIKE ?)`);
            params.push(`%${search}%`, `%${search}%`);
        }
        const whereClause = filters.length ? `WHERE ${filters.join(' AND ')}` : '';
        const query = `
    SELECT 
      p.patient_name,
      p.aayush_unique_id,
      p.dial_code,
      p.mobileno,
      pps.total_tax_amount,
      pps.overall_subtotal_amount,
      pps.total_billed_amount,
      ${statusCase} AS status,
      COALESCE(pps.paid_amount, 0) AS paid_amount,
      COALESCE(pps.due_amount, 0) AS due_amount
    FROM patients p
    LEFT JOIN patient_payment_summary pps ON pps.patient_id = p.id
    ${whereClause}
    ORDER BY p.id DESC
    LIMIT ? OFFSET ?;
  `;
        const dashboard_data = await this.dynamicConnection.query(query, [
            ...params,
            limit,
            offset,
        ]);
        let totalCount;
        if (payment_status) {
            const countQuery = `
      SELECT COUNT(*) as count
      FROM patients p
      LEFT JOIN patient_payment_summary pps ON pps.patient_id = p.id
      ${whereClause};
    `;
            const [countResult] = await this.dynamicConnection.query(countQuery, params);
            totalCount = Number(countResult?.count || 0);
        }
        else {
            const countQuery = `
      SELECT status, COUNT(*) as count 
      FROM (
        SELECT ${statusCase} AS status
        FROM patients p
        LEFT JOIN patient_payment_summary pps ON pps.patient_id = p.id
        ${whereClause}
      ) t
      GROUP BY status;
    `;
            const countResults = await this.dynamicConnection.query(countQuery, params);
            totalCount = countResults.reduce((sum, item) => sum + Number(item.count), 0);
        }
        return {
            status: 'success',
            status_code: 200,
            message: 'data fetched successfully',
            data: dashboard_data,
            count: totalCount,
        };
    }
    async dashboard_mongo_data(limit, page, search, start_date, end_date) {
        try {
            const offset = limit * (page - 1);
            const query = {};
            if (search) {
                if (mongoose_2.Types.ObjectId.isValid(search)) {
                    query.$or = [
                        { _id: new mongoose_2.Types.ObjectId(search) },
                        {
                            'patient_details.patient_name': { $regex: search, $options: 'i' },
                        },
                        { 'patient_details.id': { $regex: search, $options: 'i' } },
                    ];
                }
                else {
                    query.$or = [
                        {
                            'patient_details.patient_name': { $regex: search, $options: 'i' },
                        },
                        { 'patient_details.id': { $regex: search, $options: 'i' } },
                    ];
                }
            }
            if (start_date && end_date) {
                const start = new Date(start_date);
                start.setHours(0, 0, 0, 0);
                const end = new Date(end_date);
                end.setHours(23, 59, 59, 999);
                query.created_at = { $gte: start, $lte: end };
            }
            else if (start_date) {
                const start = new Date(start_date);
                start.setHours(0, 0, 0, 0);
                query.created_at = { $gte: start };
            }
            else if (end_date) {
                const end = new Date(end_date);
                end.setHours(23, 59, 59, 999);
                query.created_at = { $lte: end };
            }
            const [data, overallCount] = await Promise.all([
                this.ServiceModel.find(query).skip(offset).limit(limit),
                this.ServiceModel.countDocuments(query),
            ]);
            console.log(overallCount, 'overallCount');
            return {
                status: 'success',
                status_code: 200,
                message: 'data fetched successfully',
                data: data,
                count: overallCount,
            };
        }
        catch (error) {
            return {
                status: 'failed',
                status_code: 500,
                message: 'API SERVICE UNAVAILABLE TEMPORARYILY',
            };
        }
    }
    async dashboard_count(hospital_id) {
        const [getPatientCount] = await this.dynamicConnection.query(`select count(id) as patient_count from patients`);
        const [data] = await this.connection.query(`select * from hospital_payment_summary where hospital_id = ?
`, [hospital_id]);
        data.patient_count = getPatientCount.patient_count;
        return {
            status: 'success',
            status_code: 200,
            message: 'data fetched successfully',
            data: data,
        };
    }
    async balance_by_patient(aayush_unique_id) {
        const [admin_pat_id] = await this.dynamicConnection.query(`select id from patients where aayush_unique_id = ?`, [aayush_unique_id]);
        const [adminnn_pat_id] = await this.connection.query(`select id, mobileno from patients where aayush_unique_id = ?`, [aayush_unique_id]);
        console.log(adminnn_pat_id, 'adminnn_pat_id');
        let [admin_user_id] = await this.connection.query(`select id from users where username = ?`, [91 + adminnn_pat_id.mobileno]);
        console.log(admin_user_id, 'admin_user_id');
        if (!admin_user_id) {
            let a = await this.connection.query(`insert into users (username,role) values (?, ?)`, [91 + adminnn_pat_id.mobileno, 'patient']);
            admin_user_id = await a.insertId;
        }
        const [aayush_coins] = await this.connection.query(`select coalesce(sum(total_coins_remaining), 0) coins_remaining from aayush_coins where user_id = ${admin_user_id.id} and coins_usage <> 'fully_used'  and is_expired = 0`);
        const query = `select total_billed_amount, total_tax_amount, overall_subtotal_amount, paid_amount, due_amount,  CASE 
            WHEN patient_payment_summary.total_billed_amount <= patient_payment_summary.paid_amount THEN "paid"
            WHEN patient_payment_summary.total_billed_amount > patient_payment_summary.paid_amount 
                 AND patient_payment_summary.paid_amount > 0 THEN "partially_paid"
            WHEN patient_payment_summary.total_billed_amount > patient_payment_summary.paid_amount 
                 AND patient_payment_summary.paid_amount = 0 THEN "due"
        END AS status from patient_payment_summary where patient_id = ?`;
        console.log(admin_pat_id.id, 'admin_pat_id.id');
        const [result] = await this.dynamicConnection.query(query, [
            admin_pat_id.id,
        ]);
        console.log(result, 'result');
        return {
            status: 'success',
            status_code: 200,
            message: 'data fetched successfully',
            data: result || {},
            coin_balance: aayush_coins || {},
        };
    }
    async phr_patient_wallet(aayush_unique_id) {
        const [existing_user] = await this.connection.query(`select id from patients where aayush_unique_id = ?`, [aayush_unique_id]);
        const [value_per_coin] = await this.connection.query(`select * from coin_value order by created_at desc limit 1`);
        if (existing_user) {
            const aayush_coins = await this.connection.query(`select coalesce(sum(total_coins_remaining), 0) coins_remaining from aayush_coins where user_id = ${existing_user.id} and coins_usage <> 'fully_used'  and is_expired = 0`);
            aayush_coins[0].value_per_coin_details = value_per_coin;
            console.log(aayush_coins, 'aayush_coins');
            if (aayush_coins.length === 0) {
                return {
                    status: 'failed',
                    status_code: 201,
                    message: 'No Aayush coins available for the patient',
                };
            }
            return aayush_coins;
        }
        else {
            return {
                status: 'failed',
                status_code: 400,
                message: 'No user found',
            };
        }
    }
    async phr_coins_used(aayush_unique_id, coins_used) {
        coins_used = Number(coins_used);
        const [existing_user] = await this.connection.query(`select id from patients where aayush_unique_id = ?`, [aayush_unique_id]);
        if (existing_user) {
            const [total_aayush_coins] = await this.connection.query(`select coalesce(sum(total_coins_remaining), 0) coins_remaining from aayush_coins where user_id = ${existing_user.id} and coins_usage <> 'fully_used'  and is_expired = 0`);
            console.log(total_aayush_coins.coins_remaining, coins_used);
            if (Number(total_aayush_coins.coins_remaining) < coins_used) {
                return {
                    status: 'failed',
                    status_code: 400,
                    message: 'coins_used must be lesser than or equal to available coins',
                };
            }
            const aayush_coins = await this.connection.query(`select * from aayush_coins where user_id = ${existing_user.id} and coins_usage <> 'fully_used'  and is_expired = 0 order by created_at asc`);
            console.log(aayush_coins, 'aayush_coins');
            if (aayush_coins.length === 0) {
                return {
                    status: 'failed',
                    status_code: 201,
                    message: 'No Aayush coins available for the patient',
                };
            }
            console.log(typeof coins_used), 'coins_used';
            for (const a of aayush_coins) {
                if (coins_used > 0) {
                    if (Number(a.total_coins_remaining) <= coins_used) {
                        let total_coins_used = Number(a.total_coins_used) + Number(a.total_coins_remaining);
                        const query = await this.connection.query(`update aayush_coins set total_coins_remaining = 0, total_coins_used = ${total_coins_used}, coins_usage= 'fully_used' where id = ?`, [Number(a.id)]);
                        coins_used = coins_used - Number(a.total_coins_remaining);
                    }
                    else {
                        let total_coins_remaining = Number(a.total_coins_remaining) - coins_used;
                        let total_coins_used = Number(a.total_coins_used) + Number(coins_used);
                        const query = await this.connection.query(`update aayush_coins set total_coins_remaining = ${total_coins_remaining}, total_coins_used = ${total_coins_used}, coins_usage= 'partially_used' where id = ?`, [Number(a.id)]);
                        coins_used = coins_used - Number(a.total_coins_remaining);
                    }
                }
            }
            return aayush_coins;
        }
        else {
            return {
                status: 'failed',
                status_code: 400,
                message: 'No user found',
            };
        }
    }
    async phr_findtransactiondetails(aayush_unique_id, payment_module, limit, page) {
        try {
            const offset = limit * (page - 1);
            const [getAdminPatientId] = await this.connection.query(`select id from patients where aayush_unique_id = ?`, [aayush_unique_id]);
            console.log(getAdminPatientId.id, 'getHosPatientId');
            let query = `select
  date(patient_charges.date) as billed_date,
  time(patient_charges.date) as billed_time,
    patient_charges.id as patient_charge_id,
date(transactions.payment_date) paid_date,
time(transactions.payment_date) paid_time,
            concat(COALESCE(transactions.net_banking_transaction_id,""),COALESCE(transactions.card_transaction_id,""),COALESCE(transactions.upi_transaction_id,""),
            COALESCE(transactions.payment_reference_number,""),
            COALESCE(transactions.cash_transaction_id,"")) payment_transaction_id,
            transactions.id plenome_transaction_id,
            transactions.hos_transaction_id hos_transaction_id,
            transactions.payment_mode,
            transactions.amount amount_paid
            from appointment
left join visit_details on visit_details.id = appointment.visit_details_id
left join opd_details on opd_details.id = visit_details.opd_details_id
left join ipd_details on ipd_details.case_reference_id = appointment.case_reference_id
left join patient_charges on (patient_charges.opd_id = opd_details.id or patient_charges.ipd_id = ipd_details.id)
left join transactions on transactions.id = patient_charges.transaction_id where transactions.patient_id = ${getAdminPatientId.id} `;
            let countquery = `select count(appointment.id) total from appointment
       left join visit_details on visit_details.id = appointment.visit_details_id
left join opd_details on opd_details.id = visit_details.opd_details_id
left join ipd_details on ipd_details.case_reference_id = appointment.case_reference_id
left join patient_charges on (patient_charges.opd_id = opd_details.id or patient_charges.ipd_id = ipd_details.id)
left join transactions on transactions.id = patient_charges.transaction_id where transactions.patient_id = ${getAdminPatientId.id}`;
            if (payment_module) {
                switch (payment_module) {
                    case 'opd':
                        query += ` and appointment.module = 'OPD'`;
                        countquery += ` and appointment.module = 'OPD'`;
                        break;
                    case 'ipd':
                        query += ` and appointment.module = 'IPD'`;
                        countquery += ` and appointment.module = 'IPD'`;
                        break;
                    case 'appointment':
                        query += ` and appointment.module = 'APPOINTMENT'`;
                        countquery += ` and appointment.module = 'APPOINTMENT'`;
                        break;
                    default:
                        query += ` and appointment.module = 'ABCD'`;
                        countquery += ` and appointment.module = 'ABCD'`;
                        break;
                }
            }
            console.log('lkjhgfdsa');
            let [count] = await this.connection.query(countquery);
            const transaction_data = await this.connection.query(query + `limit ${limit} offset ${offset}`);
            return {
                status: 'success',
                status_code: 200,
                message: 'data fetched successfully',
                data: transaction_data,
                count: count.total,
            };
        }
        catch (error) {
            console.log(error, 'lkjhgfd');
        }
    }
    async phr_findAll(aayush_unique_id, payment_module, bill_type, limit, page, search_text) {
        const sanitizedLimit = Number(limit);
        const sanitizedPage = Number(page);
        const offset = sanitizedLimit * (sanitizedPage - 1);
        const [patient_data] = await this.dynamicConnection.query(`
    SELECT 
      p.id, p.image, p.patient_name, p.gender, p.age, p.dob, p.mobileno, 
      p.guardian_name, p.emergency_mobile_no, p.marital_status, 
      p.aayush_unique_id, p.ABHA_number, p.email, 
      p.employer_name, p.employer_id, p.employee_id, 
      p.insurance_provider, bbp.name AS blood_bank_product_name, 
      p.communication_address, p.address 
    FROM patients p
    LEFT JOIN blood_bank_products bbp 
      ON bbp.id = p.blood_bank_product_id
    WHERE p.id = ?
    `, [aayush_unique_id]);
        let patient_id = await patient_data.id;
        const [abhaResult] = await this.connection.query(`
    SELECT abhaAddress 
    FROM patient_abha_address 
    WHERE patient_id = ? 
    ORDER BY created_at DESC 
    LIMIT 1
    `, [patient_id]);
        patient_data.pat_abha_address = abhaResult?.abhaAddress ?? '';
        const baseBillingQuery = `
    FROM appointment a
    LEFT JOIN visit_details vd ON vd.id = a.visit_details_id
    LEFT JOIN opd_details opd ON opd.id = vd.opd_details_id
    LEFT JOIN ipd_details ipd ON ipd.case_reference_id = a.case_reference_id
    LEFT JOIN staff s ON s.id = a.doctor
    LEFT JOIN patient_charges pc ON (
      pc.opd_id = opd.id OR pc.ipd_id = ipd.id
    )
    LEFT JOIN transactions ON transactions.patient_charges_id = pc.id
    LEFT JOIN charges c ON c.id = pc.charge_id
    LEFT JOIN charge_categories cc ON cc.id = c.charge_category_id
    LEFT JOIN charge_type_master ctm ON ctm.id = cc.charge_type_id
    WHERE pc.patient_id = ?
  `;
        const queryParams = [patient_id];
        const countParams = [patient_id];
        const filters = [];
        if (bill_type === 'due') {
            filters.push(`pc.payment_status <> 'paid'`);
        }
        else if (bill_type === 'paid') {
            filters.push(`pc.payment_status = 'paid'`);
        }
        if (payment_module) {
            const module = payment_module.toUpperCase();
            if (['OPD', 'IPD', 'APPOINTMENT'].includes(module)) {
                filters.push(`a.module = '${module}'`);
            }
            else {
                filters.push(`a.module = 'ABCD'`);
            }
        }
        if (search_text && search_text.trim() !== '') {
            const search = `%${search_text.trim()}%`;
            filters.push(`
      (
        CONCAT('APPN', a.id) LIKE ?
        OR s.name LIKE ?
        OR s.surname LIKE ?
      )
    `);
            queryParams.push(search, search, search);
            countParams.push(search, search, search);
        }
        const whereClause = filters.length ? ` AND ${filters.join(' AND ')}` : '';
        const billingQuery = `
    SELECT 
      CONCAT('APPN', a.id) AS appointment_id,
      a.module,
      CASE 
        WHEN a.module = 'OPD' THEN CONCAT('OPDN', opd.id)
        WHEN a.module = 'IPD' THEN CONCAT('IPDN', ipd.id)
        WHEN a.module = 'APPOINTMENT' THEN CONCAT('APPN', a.id)
        ELSE '-' 
      END AS department_id,
      ctm.charge_type,
      cc.name AS charge_category,
      s.name,
      s.surname,
      s.id AS doctor_id,
      a.case_reference_id AS case_id,
      pc.id AS patient_charge_id,
      DATE(pc.date) AS billed_date,
      TIME(pc.date) AS billed_time,
       pc.qty as Qty,
pc.standard_charge as standard, 
pc.apply_charge as Apply,
pc.discount_amount as Discount,
pc.discount_percentage,
pc.amount as sub_total,
pc.tax as TAX,
pc.total as Billed,
transactions.amount as paid,
(pc.total - transactions.amount) as Due
    ${baseBillingQuery}
    ${whereClause}
    ORDER BY pc.date DESC
    LIMIT ? OFFSET ?
  `;
        const countQuery = `
    SELECT COUNT(pc.id) AS totalcount
    ${baseBillingQuery}
    ${whereClause}
  `;
        queryParams.push(sanitizedLimit);
        queryParams.push(offset);
        const billing_summary = await this.dynamicConnection.query(billingQuery, queryParams);
        const [count] = await this.dynamicConnection.query(countQuery, countParams);
        return {
            status: 'success',
            status_code: 200,
            message: 'data fetched successfully',
            data: {
                patient_data,
                billing_summary,
            },
            count: count.totalcount,
        };
    }
    async phr_wallet_credit_transactions(aayush_unique_id, transaction_status) {
        const [patient_data] = await this.connection.query(`select id, mobileno from patients where aayush_unique_id = ?`, [aayush_unique_id]);
        let num = patient_data.mobileno;
        if (num.length === 10) {
            num = `91${num}`;
        }
        const [user_id] = await this.connection.query(`select user_id from users where username = ?`, [num]);
        console.log(user_id, 1);
        const [coin_amt] = await this.connection.query(`select * from coin_value order by created_at desc limit 1`);
        const coin_value = await coin_amt.coin_amount;
        const debit_transaction = await this.connection.query(`select id, payment_date, (wallet_paid_amount/${coin_value}) as coins_used from transactions where patient_id = ? and wallet_paid_amount > 0`, [patient_data.id]);
        const user_aayush_coins = await this.connection.query(`select total_coins_issued, created_at as issued_date, module from aayush_coins where user_id = ${user_id.user_id}`);
        if (transaction_status == 'credited') {
            return {
                status: 'success',
                status_code: 200,
                message: 'data fetched successfully',
                credited_coins: user_aayush_coins,
            };
        }
        if (transaction_status == 'debited') {
            return {
                status: 'success',
                status_code: 200,
                message: 'data fetched successfully',
                debited_coins: debit_transaction,
            };
        }
        return {
            status: 'success',
            status_code: 200,
            message: 'data fetched successfully',
            debited_coins: debit_transaction,
            credited_coins: user_aayush_coins,
        };
    }
};
exports.NewBillingService = NewBillingService;
exports.NewBillingService = NewBillingService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectDataSource)('AdminConnection')),
    __param(2, (0, mongoose_1.InjectModel)('transaction_details')),
    __metadata("design:paramtypes", [typeorm_1.DataSource,
        typeorm_1.DataSource,
        mongoose_2.Model])
], NewBillingService);
//# sourceMappingURL=new-billing.service.js.map