import { CreateNewBillingDto } from './dto/create-new-billing.dto';
import { DataSource } from 'typeorm';
import { makepaymentV3 } from './entities/new-billing.entity';
import { Model, Types } from 'mongoose';
import { transaction_details } from './entities/new-billing.entity';
export declare class NewBillingService {
    private readonly connection;
    private readonly dynamicConnection;
    private readonly ServiceModel;
    constructor(connection: DataSource, dynamicConnection: DataSource, ServiceModel: Model<transaction_details>);
    create(createNewBillingDto: CreateNewBillingDto[], patient_id: number): Promise<{
        status: string;
        message: string;
    }>;
    findAll(patient_id: string, payment_module: string, bill_type: string, limit: number, page: number, search_text?: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: {
            patient_data: any;
            billing_summary: any;
        };
        count: any;
    }>;
    findtransactiondetails(patient_id: number, payment_module: string, limit: number, page: number): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        count: any;
    }>;
    patient_wallet(patient_id: string): Promise<any>;
    coins_used(patient_id: number, coins_used: number): Promise<any>;
    mongodata(Entity: transaction_details): Promise<import("mongoose").Document<unknown, {}, transaction_details, {}, {}> & transaction_details & {
        _id: Types.ObjectId;
    } & {
        __v: number;
    }>;
    makePaymentV3(Entity: makepaymentV3): Promise<any>;
    get_transaction_details(hospital_id: number, hos_transaction_id: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: (import("mongoose").Document<unknown, {}, transaction_details, {}, {}> & transaction_details & {
            _id: Types.ObjectId;
        } & {
            __v: number;
        })[];
    } | {
        status: string;
        status_code: number;
        message: string;
        data?: undefined;
    }>;
    add_overall_charges(aayush_unique_id: string, hospital_id: number, body: any): Promise<{
        status: string;
        status_code: number;
        message: string;
    }>;
    finddepartment_id(patient_id: number, hospital_id: number): Promise<any[]>;
    update_overall_charges(aayush_unique_id: string, hospital_id: number, body: any): Promise<{
        status: string;
        status_code: number;
        message: string;
    }>;
    overall_dashboard_data(limit: number, page: number, payment_status?: string, search?: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        count: number;
    }>;
    dashboard_mongo_data(limit: number, page: number, search: string, start_date: any, end_date: any): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: (import("mongoose").Document<unknown, {}, transaction_details, {}, {}> & transaction_details & {
            _id: Types.ObjectId;
        } & {
            __v: number;
        })[];
        count: number;
    } | {
        status: string;
        status_code: number;
        message: string;
        data?: undefined;
        count?: undefined;
    }>;
    dashboard_count(hospital_id: number): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
    }>;
    balance_by_patient(aayush_unique_id: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        coin_balance: any;
    }>;
    phr_patient_wallet(aayush_unique_id: string): Promise<any>;
    phr_coins_used(aayush_unique_id: string, coins_used: number): Promise<any>;
    phr_findtransactiondetails(aayush_unique_id: number, payment_module: string, limit: number, page: number): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        count: any;
    }>;
    phr_findAll(aayush_unique_id: string, payment_module: string, bill_type: string, limit: number, page: number, search_text?: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: {
            patient_data: any;
            billing_summary: any;
        };
        count: any;
    }>;
    phr_wallet_credit_transactions(aayush_unique_id: string, transaction_status: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        credited_coins: any;
        debited_coins?: undefined;
    } | {
        status: string;
        status_code: number;
        message: string;
        debited_coins: any;
        credited_coins?: undefined;
    } | {
        status: string;
        status_code: number;
        message: string;
        debited_coins: any;
        credited_coins: any;
    }>;
}
