"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewBillingController = void 0;
const common_1 = require("@nestjs/common");
const new_billing_service_1 = require("./new-billing.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_status_controller_1 = require("../op-hub-appointment-status/op-hub-appointment-status.controller");
const op_hub_appointment_entity_1 = require("../op-hub-appointment/entities/op-hub-appointment.entity");
const new_billing_entity_1 = require("./entities/new-billing.entity");
let NewBillingController = class NewBillingController {
    constructor(newBillingService) {
        this.newBillingService = newBillingService;
    }
    create(createNewBillingDto, patient_id) {
        if (!patient_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'patient_id is required',
            };
        }
        if (createNewBillingDto.some((c) => !c.department_id || c.department_id.trim() === '')) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'department_id is required for all charges',
            };
        }
        return this.newBillingService.create(createNewBillingDto, patient_id);
    }
    async findAll(patient_id, payment_mode, bill_type, limit, page, searchText) {
        if (!patient_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'Patient ID is required',
            };
        }
        if (bill_type && bill_type !== 'due' && bill_type !== 'paid') {
            return {
                status: 'failed',
                status_code: 400,
                message: 'Bill_Type must be due or paid',
            };
        }
        return this.newBillingService.findAll(patient_id, payment_mode, bill_type, limit || 10, page || 1, searchText);
    }
    async findOne(patient_id, payment_module, limit, page) {
        if (!patient_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'patient_id is required',
            };
        }
        return this.newBillingService.findtransactiondetails(patient_id, payment_module, limit || 10, page || 1);
    }
    update(patient_id) {
        return this.newBillingService.patient_wallet(patient_id);
    }
    coins_used(patient_id, coins_used) {
        if (!patient_id || !coins_used) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'Patient ID and coins_used is required',
            };
        }
        return this.newBillingService.coins_used(patient_id, coins_used);
    }
    makePaymentV3(createBillingDto) {
        if (Number(createBillingDto.amount_from_coins) +
            Number(createBillingDto.actual_amount_paid) !=
            Number(createBillingDto.totalDue)) {
            return {
                status_code: 400,
                status: 'failed',
                message: 'sum of amount_from_coins and actual_amount_paid must be equal to totaldue',
            };
        }
        if (!createBillingDto.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING + 'received_by_name',
            };
        }
        if (!createBillingDto.paymentDetails) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING + 'paymentDetails',
            };
        }
        if (!createBillingDto.patient_details) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING + 'patient_details',
            };
        }
        if (!createBillingDto.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING + 'payment_method',
            };
        }
        if (createBillingDto.payment_mode.toLocaleLowerCase() == 'card' &&
            !createBillingDto.card_division &&
            !createBillingDto.card_bank_name &&
            !createBillingDto.card_type &&
            !createBillingDto.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING + 'card details',
            };
        }
        if (createBillingDto.payment_mode.toLocaleLowerCase() == 'net_banking' &&
            !createBillingDto.net_banking_division &&
            !createBillingDto.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING + 'net banking details',
            };
        }
        if (createBillingDto.payment_mode.toLocaleLowerCase() == 'upi' &&
            !createBillingDto.upi_id &&
            !createBillingDto.upi_transaction_id &&
            !createBillingDto.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING + 'upi details',
            };
        }
        return this.newBillingService.makePaymentV3(createBillingDto);
    }
    gettransactiondata(hospital_id, hos_transaction_id) {
        if (!hospital_id || !hos_transaction_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'Hospital ID and Hos_Transaction ID is required',
            };
        }
        return this.newBillingService.get_transaction_details(hospital_id, hos_transaction_id);
    }
    Addchargedata(aayush_unique_id, hospital_id, body) {
        if (!aayush_unique_id || !hospital_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'aayush_unique_id, hospital_id are required',
            };
        }
        if (Number(body.total_tax_amount) + Number(body.overall_subtotal_amount) !=
            Number(body.total_billed_amount)) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'sum of subtotal and tax amount must be equal to billed amount',
            };
        }
        return this.newBillingService.add_overall_charges(aayush_unique_id, hospital_id, body);
    }
    Updatechargedata(aayush_unique_id, hospital_id, body) {
        if (!aayush_unique_id || !hospital_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'aayush_unique_id, hospital_id are required',
            };
        }
        return this.newBillingService.update_overall_charges(aayush_unique_id, hospital_id, body);
    }
    async findApp(patient_id, hospital_id) {
        if (!patient_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'patient_id is required',
            };
        }
        if (!hospital_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'hospital_id is required',
            };
        }
        return this.newBillingService.finddepartment_id(patient_id, hospital_id);
    }
    async dashboard(limit, page, payment_status, searchText) {
        if (payment_status &&
            payment_status !== 'paid' &&
            payment_status !== 'partially_paid' &&
            payment_status !== 'due') {
            console.log(payment_status &&
                payment_status !== 'paid' &&
                payment_status !== 'partially_paid' &&
                payment_status !== 'due', 'check', payment_status);
            return {
                status: 'failed',
                status_code: 400,
                message: 'payment_status must be due or paid or partially_paid',
            };
        }
        return this.newBillingService.overall_dashboard_data(limit || 10, page || 1, payment_status, searchText);
    }
    dashboardtransactiondata(limit, page, search, start_date, end_date) {
        return this.newBillingService.dashboard_mongo_data(limit || 10, page || 1, search, start_date, end_date);
    }
    dashboardcount(hospital_id) {
        if (!hospital_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'hospital_id is required',
            };
        }
        return this.newBillingService.dashboard_count(hospital_id);
    }
    balance(aayush_unique_id) {
        if (!aayush_unique_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'aayush_unique_id is required',
            };
        }
        return this.newBillingService.balance_by_patient(aayush_unique_id);
    }
    phrwallet(aayush_unique_id) {
        return this.newBillingService.phr_patient_wallet(aayush_unique_id);
    }
    phr_coins_used(aayush_unique_id, coins_used) {
        if (!aayush_unique_id || !coins_used) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'aayush_unique_id and coins_used is required',
            };
        }
        return this.newBillingService.phr_coins_used(aayush_unique_id, coins_used);
    }
    async phrfindOne(aayush_unique_id, payment_module, limit, page) {
        if (!aayush_unique_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'aayush_unique_id is required',
            };
        }
        return this.newBillingService.phr_findtransactiondetails(aayush_unique_id, payment_module, limit || 10, page || 1);
    }
    async phrfindAll(aayush_unique_id, payment_mode, bill_type, limit, page, searchText) {
        if (!aayush_unique_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'aayush_unique_id is required',
            };
        }
        if (bill_type && bill_type !== 'due' && bill_type !== 'paid') {
            return {
                status: 'failed',
                status_code: 400,
                message: 'Bill_Type must be due or paid',
            };
        }
        return this.newBillingService.findAll(aayush_unique_id, payment_mode, bill_type, limit || 10, page || 1, searchText);
    }
    async phr_wallet_transactions(aayush_unique_id, transaction_status) {
        if (!aayush_unique_id) {
            return {
                status: 'failed',
                status_code: 400,
                message: 'aayush_unique_id is required',
            };
        }
        return this.newBillingService.phr_wallet_credit_transactions(aayush_unique_id, transaction_status);
    }
};
exports.NewBillingController = NewBillingController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Number]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('billing-summary-bills'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('payment_module')),
    __param(2, (0, common_1.Query)('bill_type')),
    __param(3, (0, common_1.Query)('limit')),
    __param(4, (0, common_1.Query)('page')),
    __param(5, (0, common_1.Query)('searchText')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, Number, Number, String]),
    __metadata("design:returntype", Promise)
], NewBillingController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('transaction-list'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('payment_module')),
    __param(2, (0, common_1.Query)('limit')),
    __param(3, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], NewBillingController.prototype, "findOne", null);
__decorate([
    (0, common_1.Post)('patient-wallet'),
    __param(0, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "update", null);
__decorate([
    (0, common_1.Post)('coins-used'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('coins_used')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "coins_used", null);
__decorate([
    (0, common_1.Post)('/makePayment'),
    (0, swagger_1.ApiOperation)({ summary: 'Make a payment for a patient' }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: 'Payment made successfully.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500,
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [new_billing_entity_1.makepaymentV3]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "makePaymentV3", null);
__decorate([
    (0, common_1.Get)('get-transaction-details'),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('hos_transaction_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "gettransactiondata", null);
__decorate([
    (0, common_1.Post)('add-in-overallcharge'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Object]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "Addchargedata", null);
__decorate([
    (0, common_1.Post)('update-in-overallcharge'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Object]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "Updatechargedata", null);
__decorate([
    (0, common_1.Get)('/app'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], NewBillingController.prototype, "findApp", null);
__decorate([
    (0, common_1.Get)('dashboard'),
    __param(0, (0, common_1.Query)('limit', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Query)('page', common_1.ParseIntPipe)),
    __param(2, (0, common_1.Query)('payment_status')),
    __param(3, (0, common_1.Query)('searchText')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], NewBillingController.prototype, "dashboard", null);
__decorate([
    (0, common_1.Get)('dashboard-mongo-data'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('start_date')),
    __param(4, (0, common_1.Query)('end_date')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, Object, Object]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "dashboardtransactiondata", null);
__decorate([
    (0, common_1.Get)('dashboard-count'),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "dashboardcount", null);
__decorate([
    (0, common_1.Get)('patient-balance'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "balance", null);
__decorate([
    (0, common_1.Post)('phr-patient-wallet'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "phrwallet", null);
__decorate([
    (0, common_1.Post)('phr-coins-used'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __param(1, (0, common_1.Query)('coins_used')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], NewBillingController.prototype, "phr_coins_used", null);
__decorate([
    (0, common_1.Get)('phr-transaction-list'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __param(1, (0, common_1.Query)('payment_module')),
    __param(2, (0, common_1.Query)('limit')),
    __param(3, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], NewBillingController.prototype, "phrfindOne", null);
__decorate([
    (0, common_1.Get)('phr-billing-summary-bills'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __param(1, (0, common_1.Query)('payment_module')),
    __param(2, (0, common_1.Query)('bill_type')),
    __param(3, (0, common_1.Query)('limit')),
    __param(4, (0, common_1.Query)('page')),
    __param(5, (0, common_1.Query)('searchText')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, Number, Number, String]),
    __metadata("design:returntype", Promise)
], NewBillingController.prototype, "phrfindAll", null);
__decorate([
    (0, common_1.Get)('phr-wallet-transactions'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __param(1, (0, common_1.Query)('transaction_status')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], NewBillingController.prototype, "phr_wallet_transactions", null);
exports.NewBillingController = NewBillingController = __decorate([
    (0, common_1.Controller)('new-billing'),
    __metadata("design:paramtypes", [new_billing_service_1.NewBillingService])
], NewBillingController);
//# sourceMappingURL=new-billing.controller.js.map