import { NewBillingService } from './new-billing.service';
import { CreateNewBillingDto } from './dto/create-new-billing.dto';
import { makepaymentV3 } from './entities/new-billing.entity';
export declare class NewBillingController {
    private readonly newBillingService;
    constructor(newBillingService: NewBillingService);
    create(createNewBillingDto: CreateNewBillingDto[], patient_id: number): Promise<{
        status: string;
        message: string;
    }> | {
        status: string;
        status_code: number;
        message: string;
    };
    findAll(patient_id: string, payment_mode: string, bill_type: string, limit: number, page: number, searchText: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: {
            patient_data: any;
            billing_summary: any;
        };
        count: any;
    } | {
        status: string;
        status_code: number;
        message: string;
    }>;
    findOne(patient_id: number, payment_module: string, limit: number, page: number): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        count: any;
    } | {
        status: string;
        status_code: number;
        message: string;
    }>;
    update(patient_id: string): Promise<any>;
    coins_used(patient_id: number, coins_used: number): Promise<any> | {
        status: string;
        status_code: number;
        message: string;
    };
    makePaymentV3(createBillingDto: makepaymentV3): Promise<any> | {
        status_code: number;
        status: string;
        message: string;
    } | {
        status_code: string;
        status: string;
        message: string;
    };
    gettransactiondata(hospital_id: number, hos_transaction_id: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: (import("mongoose").Document<unknown, {}, import("./entities/new-billing.entity").transaction_details, {}, {}> & import("./entities/new-billing.entity").transaction_details & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        })[];
    } | {
        status: string;
        status_code: number;
        message: string;
        data?: undefined;
    }> | {
        status: string;
        status_code: number;
        message: string;
    };
    Addchargedata(aayush_unique_id: string, hospital_id: number, body: any): Promise<{
        status: string;
        status_code: number;
        message: string;
    }> | {
        status: string;
        status_code: number;
        message: string;
    };
    Updatechargedata(aayush_unique_id: string, hospital_id: number, body: any): Promise<{
        status: string;
        status_code: number;
        message: string;
    }> | {
        status: string;
        status_code: number;
        message: string;
    };
    findApp(patient_id: number, hospital_id: number): Promise<any[] | {
        status: string;
        status_code: number;
        message: string;
    }>;
    dashboard(limit: number, page: number, payment_status: string, searchText: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        count: number;
    } | {
        status: string;
        status_code: number;
        message: string;
    }>;
    dashboardtransactiondata(limit: number, page: number, search: string, start_date: any, end_date: any): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: (import("mongoose").Document<unknown, {}, import("./entities/new-billing.entity").transaction_details, {}, {}> & import("./entities/new-billing.entity").transaction_details & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        })[];
        count: number;
    } | {
        status: string;
        status_code: number;
        message: string;
        data?: undefined;
        count?: undefined;
    }>;
    dashboardcount(hospital_id: number): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
    }> | {
        status: string;
        status_code: number;
        message: string;
    };
    balance(aayush_unique_id: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        coin_balance: any;
    }> | {
        status: string;
        status_code: number;
        message: string;
    };
    phrwallet(aayush_unique_id: string): Promise<any>;
    phr_coins_used(aayush_unique_id: string, coins_used: number): Promise<any> | {
        status: string;
        status_code: number;
        message: string;
    };
    phrfindOne(aayush_unique_id: number, payment_module: string, limit: number, page: number): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: any;
        count: any;
    } | {
        status: string;
        status_code: number;
        message: string;
    }>;
    phrfindAll(aayush_unique_id: string, payment_mode: string, bill_type: string, limit: number, page: number, searchText: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        data: {
            patient_data: any;
            billing_summary: any;
        };
        count: any;
    } | {
        status: string;
        status_code: number;
        message: string;
    }>;
    phr_wallet_transactions(aayush_unique_id: string, transaction_status: string): Promise<{
        status: string;
        status_code: number;
        message: string;
        credited_coins: any;
        debited_coins?: undefined;
    } | {
        status: string;
        status_code: number;
        message: string;
        debited_coins: any;
        credited_coins?: undefined;
    } | {
        status: string;
        status_code: number;
        message: string;
        debited_coins: any;
        credited_coins: any;
    } | {
        status: string;
        status_code: number;
        message: string;
    }>;
}
