"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MqttService = void 0;
const common_1 = require("@nestjs/common");
const mqtt = require("mqtt");
let MqttService = class MqttService {
    constructor() {
        this.mqttClient = mqtt.connect('mqtt://3.108.145.57:7889', {
            username: 'plenome',
            password: 'cloud@PT2023',
        });
        this.mqttClient.on('error', (error) => {
            console.error('MQTT connection error:', error);
        });
        this.mqttClient.on('connect', () => {
            console.log('Connected to MQTT server');
        });
    }
    onModuleInit() {
        console.log('The module has been initialized.');
    }
    onModuleDestroy() {
        this.mqttClient.end();
        console.log('MQTT client disconnected');
    }
    publish(topic, message) {
        this.mqttClient.publish(topic, message, (err) => {
            if (err) {
                console.error('MQTT publish error:', err);
            }
            else {
                console.log('Published payload to MQTT successfully');
            }
        });
    }
    subscribe(topic) {
        this.mqttClient.subscribe(topic);
    }
    handleMessage(callback) {
        this.mqttClient.on('message', callback);
    }
};
exports.MqttService = MqttService;
exports.MqttService = MqttService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], MqttService);
//# sourceMappingURL=mqtt.service.js.map