"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MedicationIpdController = void 0;
const common_1 = require("@nestjs/common");
const medication_ipd_service_1 = require("./medication_ipd.service");
const medication_ipd_entity_1 = require("./entities/medication_ipd.entity");
const auth_guard_1 = require("../auth/auth.guard");
let MedicationIpdController = class MedicationIpdController {
    constructor(medicationIpdService) {
        this.medicationIpdService = medicationIpdService;
    }
    create(createMedicationIpd) {
        return this.medicationIpdService.create(createMedicationIpd);
    }
    findMedication(id) {
        return this.medicationIpdService.findMedication(id);
    }
    update(id, createMedicationIpd) {
        return this.medicationIpdService.update(id, createMedicationIpd);
    }
    async removeMedication(id, Hospital_id) {
        await this.medicationIpdService.removeMedication(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.MedicationIpdController = MedicationIpdController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [medication_ipd_entity_1.MedicationIpd]),
    __metadata("design:returntype", void 0)
], MedicationIpdController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], MedicationIpdController.prototype, "findMedication", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, medication_ipd_entity_1.MedicationIpd]),
    __metadata("design:returntype", void 0)
], MedicationIpdController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], MedicationIpdController.prototype, "removeMedication", null);
exports.MedicationIpdController = MedicationIpdController = __decorate([
    (0, common_1.Controller)('medication-ipd'),
    __metadata("design:paramtypes", [medication_ipd_service_1.MedicationIpdService])
], MedicationIpdController);
//# sourceMappingURL=medication_ipd.controller.js.map