"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaManagerService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let MediaManagerService = class MediaManagerService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createMediaManager) {
        try {
            let front_cms_media_manager_id;
            const frontcmsmediaManager = await this.connection.query(`INSERT into front_cms_media_gallery (
    image,
    thumb_path,
    dir_path,
    img_name,
    thumb_name,
    file_type,
    file_size,
    vid_url,
    vid_title
           ) VALUES (?,?,?,?,?,?,?,?,?)`, [createMediaManager.image,
                createMediaManager.thumb_path,
                createMediaManager.dir_path,
                createMediaManager.img_name,
                createMediaManager.thumb_name,
                createMediaManager.file_type,
                createMediaManager.file_size,
                createMediaManager.vid_url,
                createMediaManager.vid_title
            ]);
            front_cms_media_manager_id = frontcmsmediaManager.insertId;
            await this.dynamicConnection.query(`INSERT into front_cms_media_gallery (
    image,
    thumb_path,
    dir_path,
    img_name,
    thumb_name,
    file_type,
    file_size,
    vid_url,
    vid_title,
    hospital_id,
    hos_front_cms_media_gallery_id
           ) VALUES (?,?,?,?,?,?,?,?,?,?,?)`, [createMediaManager.image,
                createMediaManager.thumb_path,
                createMediaManager.dir_path,
                createMediaManager.img_name,
                createMediaManager.thumb_name,
                createMediaManager.file_type,
                createMediaManager.file_size,
                createMediaManager.vid_url,
                createMediaManager.vid_title,
                createMediaManager.hospital_id,
                front_cms_media_manager_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS media manager details added successfully ",
                        "media_values": await this.connection.query('SELECT * FROM front_cms_media_gallery WHERE id = ?', [front_cms_media_manager_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async removeFrontCMSMediaManager(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM front_cms_media_gallery WHERE id = ?', [id]);
            await this.dynamicConnection.query('DELETE FROM front_cms_media_gallery WHERE hospital_id = ? and hos_front_cms_media_gallery_id=?', [hospital_id, id]);
            return [
                {
                    status: 'success',
                    message: `Front CMS media manager with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.MediaManagerService = MediaManagerService;
exports.MediaManagerService = MediaManagerService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], MediaManagerService);
//# sourceMappingURL=media_manager.service.js.map