"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const swagger_1 = require("@nestjs/swagger");
const cors = require("cors");
const dotenv = require("dotenv");
dotenv.config({ path: '.env.success' });
dotenv.config({ path: '.env.error' });
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    app.enableCors();
    app.use(cors({
        origin: '*',
        methods: ['GET', 'POST', 'PATCH', 'DELETE'],
        allowedHeaders: ['Content-Type'],
    }));
    const config = new swagger_1.DocumentBuilder()
        .setTitle('HMS API DOCUMENTATION')
        .setDescription('API SWAGGER DOCUMENTATION CREATED BY BACKEND DEVELOPERS')
        .setVersion('v1')
        .addTag(`hms-appointment`)
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('swagger-api/document', app, document);
    await app.listen(3102);
    console.log("connected", "3102");
}
bootstrap();
//# sourceMappingURL=main.js.map