"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpdTreatmentHistoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let IpdTreatmentHistoryService = class IpdTreatmentHistoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async findTreatmentHistorySearch(id, search) {
        const [existingRecord] = await this.connection.query('SELECT id FROM patients WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.VALIDATION_NOT_FOUND,
                message: `${process.env.VALIDATION_CHECK} ${id} ${process.env.VALIDATION_DUPLICATE_CHECK} `,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            let query = `SELECT concat('IPDN',"",ipd_details.id) AS IPD_No,
    ipd_details.symptoms AS Symptoms,
    CONCAT(staff.name, ' ', staff.surname,"(",staff.employee_id,")") AS Consultant,
    concat(bed.name,"-",bed_group.name,"-",floor.name) AS Bed_name,
    patients.id,
    ipd_details.discharged
    FROM ipd_details
    LEFT JOIN staff ON ipd_details.cons_doctor = staff.id
    LEFT JOIN bed ON ipd_details.bed = bed.id
    LEFT JOIN bed_group ON ipd_details.bed_group_id = bed_group.id
    LEFT JOIN floor ON bed_group.floor = floor.id
    LEFT JOIN patients ON ipd_details.patient_id = patients.id
    WHERE patients.id = ? AND ipd_details.discharged = 'yes'`;
            let values = [];
            values.push(id);
            if (search) {
                query += `  and (concat('IPDN',"",ipd_details.id) like ? or ipd_details.symptoms like ? or CONCAT(staff.name, ' ', staff.surname,"(",staff.employee_id,")") like ? or concat(bed.name,"-",bed_group.name,"-",floor.name) like ? )  `;
                values.push('%' + search + '%');
                values.push('%' + search + '%');
                values.push('%' + search + '%');
                values.push('%' + search + '%');
            }
            const getTreatmentHistorysch = await this.connection.query(query, values);
            return getTreatmentHistorysch;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findIpdTreatmentHistory(id, search, limit, page) {
        const offset = limit * (page - 1);
        let values = [id];
        let searchValues = [];
        try {
            let baseQuery = `
        SELECT concat('IPDN',"",ipd_details.id) AS IPD_No,
    ipd_details.symptoms AS Symptoms,
    CONCAT(staff.name, ' ', staff.surname,"(",staff.employee_id,")") AS Consultant,
    concat(bed.name,"-",bed_group.name,"-",floor.name) AS Bed_name,
    patients.id,
    ipd_details.discharged,
    discharge_card.id AS DichargeCardId,
    discharge_card.discharge_date
    FROM ipd_details
    LEFT JOIN staff ON ipd_details.cons_doctor = staff.id
    LEFT JOIN bed ON ipd_details.bed = bed.id
    LEFT JOIN discharge_card ON ipd_details.id = discharge_card.ipd_details_id
    LEFT JOIN bed_group ON ipd_details.bed_group_id = bed_group.id
    LEFT JOIN floor ON bed_group.floor = floor.id
    LEFT JOIN patients ON ipd_details.patient_id = patients.id
    WHERE patients.id = ? AND ipd_details.discharged = 'yes'`;
            let countQuery = `
        SELECT COUNT(ipd_details.id) AS total
        FROM ipd_details
    LEFT JOIN staff ON ipd_details.cons_doctor = staff.id
    LEFT JOIN bed ON ipd_details.bed = bed.id
    LEFT JOIN bed_group ON ipd_details.bed_group_id = bed_group.id
    LEFT JOIN floor ON bed_group.floor = floor.id
    LEFT JOIN patients ON ipd_details.patient_id = patients.id
    WHERE patients.id = ? AND ipd_details.discharged = 'yes'`;
            if (search) {
                const condition = `
          and (concat('IPDN',"",ipd_details.id) like ? or ipd_details.symptoms like ? or CONCAT(staff.name, ' ', staff.surname,"(",staff.employee_id,")") like ? or concat(bed.name,"-",bed_group.name,"-",floor.name) like ? )`;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                searchValues = Array(4).fill(pattern);
                values = [id, ...searchValues];
            }
            baseQuery += ` ORDER BY discharge_card.id DESC LIMIT ? OFFSET ?`;
            const paginatedValues = [...values, limit, offset];
            const ipdTreatmentHistory = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ipdTreatmentHistory,
                total: countResult?.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findIPDTreatmentHistory(id, search, limit, page) {
        const offset = limit * (page - 1);
        let values = [id];
        let searchValues = [];
        try {
            let baseQuery = `
        SELECT concat('IPDN',"",ipd_details.id) AS IPD_No,
    ipd_details.symptoms AS Symptoms,
    CONCAT(staff.name, ' ', staff.surname,"(",staff.employee_id,")") AS Consultant,
    concat(bed.name,"-",bed_group.name,"-",floor.name) AS Bed_name,
    patients.id,
    ipd_details.discharged,
    discharge_card.id AS DichargeCardId,
    discharge_card.discharge_date
    FROM ipd_details
    LEFT JOIN staff ON ipd_details.cons_doctor = staff.id
    LEFT JOIN bed ON ipd_details.bed = bed.id
    LEFT JOIN discharge_card ON ipd_details.id = discharge_card.ipd_details_id
    LEFT JOIN bed_group ON ipd_details.bed_group_id = bed_group.id
    LEFT JOIN floor ON bed_group.floor = floor.id
    LEFT JOIN patients ON ipd_details.patient_id = patients.id
    WHERE patients.id = ? AND ipd_details.discharged = 'yes'`;
            let countQuery = `
        SELECT COUNT(ipd_details.id) AS total
        FROM ipd_details
    LEFT JOIN staff ON ipd_details.cons_doctor = staff.id
    LEFT JOIN bed ON ipd_details.bed = bed.id
    LEFT JOIN bed_group ON ipd_details.bed_group_id = bed_group.id
    LEFT JOIN floor ON bed_group.floor = floor.id
    LEFT JOIN patients ON ipd_details.patient_id = patients.id
    WHERE patients.id = ? AND ipd_details.discharged = 'yes'`;
            if (search) {
                const condition = `
          and (concat('IPDN',"",ipd_details.id) like ? or ipd_details.symptoms like ? or CONCAT(staff.name, ' ', staff.surname,"(",staff.employee_id,")") like ? or concat(bed.name,"-",bed_group.name,"-",floor.name) like ? )`;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                searchValues = Array(4).fill(pattern);
                values = [id, ...searchValues];
            }
            baseQuery += ` ORDER BY discharge_card.id DESC LIMIT ? OFFSET ?`;
            const paginatedValues = [...values, limit, offset];
            const ipdTreatmentHistory = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ipdTreatmentHistory,
                total: countResult?.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.IpdTreatmentHistoryService = IpdTreatmentHistoryService;
exports.IpdTreatmentHistoryService = IpdTreatmentHistoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], IpdTreatmentHistoryService);
//# sourceMappingURL=ipd_treatment_history.service.js.map