"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpdTreatmentHistoryController = void 0;
const common_1 = require("@nestjs/common");
const ipd_treatment_history_service_1 = require("./ipd_treatment_history.service");
const auth_guard_1 = require("../auth/auth.guard");
let IpdTreatmentHistoryController = class IpdTreatmentHistoryController {
    constructor(ipdTreatmentHistoryService) {
        this.ipdTreatmentHistoryService = ipdTreatmentHistoryService;
    }
    findTreatmentHistorySearch(id, search) {
        return this.ipdTreatmentHistoryService.findTreatmentHistorySearch(id, search);
    }
    async findIpdTreatmentHistory(id, search, limit, page) {
        try {
            if (!id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'patient ID is required',
                };
            }
            const final_out = await this.ipdTreatmentHistoryService.findIpdTreatmentHistory(id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findIPDTreatmentHistory(id, search, limit, page) {
        try {
            if (!id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'patient ID is required',
                };
            }
            const final_out = await this.ipdTreatmentHistoryService.findIPDTreatmentHistory(id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.IpdTreatmentHistoryController = IpdTreatmentHistoryController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/TreatmentHistory/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], IpdTreatmentHistoryController.prototype, "findTreatmentHistorySearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_ipd_treatment_history'),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], IpdTreatmentHistoryController.prototype, "findIpdTreatmentHistory", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v3/get_ipd_treatment_history'),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], IpdTreatmentHistoryController.prototype, "findIPDTreatmentHistory", null);
exports.IpdTreatmentHistoryController = IpdTreatmentHistoryController = __decorate([
    (0, common_1.Controller)('ipd-treatment-history'),
    __metadata("design:paramtypes", [ipd_treatment_history_service_1.IpdTreatmentHistoryService])
], IpdTreatmentHistoryController);
//# sourceMappingURL=ipd_treatment_history.controller.js.map