import { AddAppointmentService } from 'src/add-appointment/add-appointment.service';
import { DataSource } from 'typeorm';
import { IpdMainModule } from './entities/ipd_main_module.entity';
import { CountDto } from './dto/ipd_main_module.dto';
export declare class IpdMainModuleService {
    private readonly connection;
    private readonly dynamicConnection;
    private readonly addAppointmentService;
    constructor(connection: DataSource, dynamicConnection: DataSource, addAppointmentService: AddAppointmentService);
    emailExists(email: string): Promise<boolean>;
    create(ipdEntity: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            IPD_values: any;
        };
    }[]>;
    create_appt_ipd(ipdEntity: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            IPD_values: any;
        };
    }[] | {
        status: string;
        message: string;
    }>;
    findAll(): Promise<IpdMainModule[]>;
    findOne(id: string): Promise<IpdMainModule | null>;
    findTitleByType(id: number): Promise<IpdMainModule | null>;
    findDescByOne(id: number): Promise<IpdMainModule | null>;
    findBedByBedgroup(id: number): Promise<IpdMainModule | null>;
    findByIPDIdByAll(search: string): Promise<IpdMainModule[]>;
    update(id: number, ipdEntity: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            updated_values: any;
        };
    }[]>;
    remove(id: number, hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    updateIsIpdMoved(id: number, ipdEntity: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            IPD_values: any;
        };
    }[]>;
    findIpdDetailsSearch(search: string, limit: number, page: number): Promise<CountDto>;
    findIpdDetailSearch(search: string, limit: number, page: number): Promise<{
        details: any;
        count: any;
    }>;
}
