"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpdMainModuleController = void 0;
const common_1 = require("@nestjs/common");
const ipd_main_module_service_1 = require("./ipd_main_module.service");
const ipd_main_module_entity_1 = require("./entities/ipd_main_module.entity");
const auth_guard_1 = require("../auth/auth.guard");
let IpdMainModuleController = class IpdMainModuleController {
    constructor(ipdMainModuleService) {
        this.ipdMainModuleService = ipdMainModuleService;
    }
    create(ipdMainEntity) {
        return this.ipdMainModuleService.create(ipdMainEntity);
    }
    create_appt_ipd(ipdMainEntity) {
        return this.ipdMainModuleService.create_appt_ipd(ipdMainEntity);
    }
    findAll() {
        return this.ipdMainModuleService.findAll();
    }
    findOne(id) {
        return this.ipdMainModuleService.findOne(id);
    }
    findTitleByType(id) {
        return this.ipdMainModuleService.findTitleByType(id);
    }
    findDescriptionbytitle(id) {
        return this.ipdMainModuleService.findDescByOne(id);
    }
    findBedByBedgroup(id) {
        return this.ipdMainModuleService.findBedByBedgroup(id);
    }
    findByIPDIdByAll(search) {
        return this.ipdMainModuleService.findByIPDIdByAll(search);
    }
    update(id, IPDENTITY) {
        return this.ipdMainModuleService.update(id, IPDENTITY);
    }
    async removeIpd(id, hospital_id) {
        await this.ipdMainModuleService.remove(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    updateIsIpdMoved(id, IPDENTITY) {
        return this.ipdMainModuleService.updateIsIpdMoved(id, IPDENTITY);
    }
    async findIpdDetailsSearch(search, limit, page) {
        try {
            let final_out = await this.ipdMainModuleService.findIpdDetailsSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findIpdDetailSearch(search, limit, page) {
        try {
            let final_out = await this.ipdMainModuleService.findIpdDetailSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
            return final_out;
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.IpdMainModuleController = IpdMainModuleController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [ipd_main_module_entity_1.IpdMainModule]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/appointmentIPD'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [ipd_main_module_entity_1.IpdMainModule]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "create_appt_ipd", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/symptoms/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "findTitleByType", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/symptomDescription/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "findDescriptionbytitle", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/internal/bedName/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "findBedByBedgroup", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "findByIPDIdByAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, ipd_main_module_entity_1.IpdMainModule]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], IpdMainModuleController.prototype, "removeIpd", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/isIPDMoved/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, ipd_main_module_entity_1.IpdMainModule]),
    __metadata("design:returntype", void 0)
], IpdMainModuleController.prototype, "updateIsIpdMoved", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/ipd_details'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], IpdMainModuleController.prototype, "findIpdDetailsSearch", null);
__decorate([
    (0, common_1.Get)('/v3/ipd_details'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], IpdMainModuleController.prototype, "findIpdDetailSearch", null);
exports.IpdMainModuleController = IpdMainModuleController = __decorate([
    (0, common_1.Controller)('ipd-main-module'),
    __metadata("design:paramtypes", [ipd_main_module_service_1.IpdMainModuleService])
], IpdMainModuleController);
//# sourceMappingURL=ipd_main_module.controller.js.map