import { IpdMainModuleService } from './ipd_main_module.service';
import { IpdMainModule } from './entities/ipd_main_module.entity';
export declare class IpdMainModuleController {
    private readonly ipdMainModuleService;
    constructor(ipdMainModuleService: IpdMainModuleService);
    create(ipdMainEntity: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            IPD_values: any;
        };
    }[]>;
    create_appt_ipd(ipdMainEntity: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            IPD_values: any;
        };
    }[] | {
        status: string;
        message: string;
    }>;
    findAll(): Promise<IpdMainModule[]>;
    findOne(id: string): Promise<IpdMainModule>;
    findTitleByType(id: number): Promise<IpdMainModule>;
    findDescriptionbytitle(id: number): Promise<IpdMainModule>;
    findBedByBedgroup(id: number): Promise<IpdMainModule>;
    findByIPDIdByAll(search: string): Promise<IpdMainModule[]>;
    update(id: number, IPDENTITY: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            updated_values: any;
        };
    }[]>;
    removeIpd(id: number, hospital_id: number): Promise<{
        status: string;
        message: string;
    }>;
    updateIsIpdMoved(id: number, IPDENTITY: IpdMainModule): Promise<{
        'data ': {
            status: string;
            messege: string;
            IPD_values: any;
        };
    }[]>;
    findIpdDetailsSearch(search?: string, limit?: number, page?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/ipd_main_module.dto").IPDMainModuleDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    findIpdDetailSearch(search?: string, limit?: number, page?: number): Promise<{
        details: any;
        count: any;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: any;
        total: any;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
}
