"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpdDoctorsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let IpdDoctorsService = class IpdDoctorsService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createIpdDoctor) {
        try {
            const [staffId] = await this.connection.query('SELECT email FROM staff WHERE id = ?', [createIpdDoctor.consult_doctor]);
            if (!staffId || staffId.length === 0) {
                throw new Error(`Staff with id: ${createIpdDoctor.consult_doctor} not found.`);
            }
            const docemail = staffId.email;
            const addIpdDoctors = await this.connection.query(`INSERT into ipd_doctors(
   ipd_id,
   consult_doctor
        ) VALUES (?,?)`, [createIpdDoctor.ipd_id, createIpdDoctor.consult_doctor]);
            const addIpdDoctorsID = addIpdDoctors.insertId;
            const dynamicUpdateStaff = await this.dynamicConnection.query('SELECT id FROM staff WHERE email = ?', [docemail]);
            const dynamicUPTDStaffId = dynamicUpdateStaff[0].id;
            const dynamicipd = await this.dynamicConnection.query('SELECT id FROM ipd_details WHERE hospital_id = ? and hospital_ipd_details_id = ?', [createIpdDoctor.hospital_id, createIpdDoctor.ipd_id]);
            const dynamicipdID = dynamicipd[0].id;
            await this.dynamicConnection.query(`INSERT into ipd_doctors(
    ipd_id,
    consult_doctor,
    hospital_id,
    hos_ipd_doctors_id
        ) VALUES (?,?,?,?)`, [
                dynamicipdID,
                dynamicUPTDStaffId,
                createIpdDoctor.hospital_id,
                addIpdDoctorsID,
            ]);
            return [
                {
                    'data ': {
                        status: 'success',
                        messege: 'ipd doctors added successfully ',
                        ipd_doctors_value: await this.connection.query('SELECT * FROM ipd_doctors WHERE id = ?', [addIpdDoctorsID]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async removeipdDoctors(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM ipd_doctors WHERE id = ?', [id]);
            const dynamicDeleteipddoc = await this.dynamicConnection.query('SELECT id FROM ipd_doctors WHERE hos_ipd_doctors_id= ? and hospital_id', [id, hospital_id]);
            const dynamicDeleteipddocId = dynamicDeleteipddoc[0].id;
            await this.dynamicConnection.query('DELETE FROM ipd_doctors WHERE id = ? and hospital_id = ?', [dynamicDeleteipddocId, hospital_id]);
            return [
                {
                    status: 'success',
                    message: `Ipd doctors with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.NOT_FOUND,
                message: error.message,
            }, common_1.HttpStatus.NOT_FOUND);
        }
    }
};
exports.IpdDoctorsService = IpdDoctorsService;
exports.IpdDoctorsService = IpdDoctorsService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], IpdDoctorsService);
//# sourceMappingURL=ipd_doctors.service.js.map