"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpdDoctorsController = void 0;
const common_1 = require("@nestjs/common");
const ipd_doctors_service_1 = require("./ipd_doctors.service");
const ipd_doctor_entity_1 = require("./entities/ipd_doctor.entity");
const auth_guard_1 = require("../auth/auth.guard");
let IpdDoctorsController = class IpdDoctorsController {
    constructor(ipdDoctorsService) {
        this.ipdDoctorsService = ipdDoctorsService;
    }
    create(createIpdDoctor) {
        return this.ipdDoctorsService.create(createIpdDoctor);
    }
    async removeipdDoctors(id, hospital_id) {
        await this.ipdDoctorsService.removeipdDoctors(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.IpdDoctorsController = IpdDoctorsController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [ipd_doctor_entity_1.IpdDoctor]),
    __metadata("design:returntype", void 0)
], IpdDoctorsController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], IpdDoctorsController.prototype, "removeipdDoctors", null);
exports.IpdDoctorsController = IpdDoctorsController = __decorate([
    (0, common_1.Controller)('ipd-doctors'),
    __metadata("design:paramtypes", [ipd_doctors_service_1.IpdDoctorsService])
], IpdDoctorsController);
//# sourceMappingURL=ipd_doctors.controller.js.map