"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdTreatmentHistoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalOpdTreatmentHistoryService = class InternalOpdTreatmentHistoryService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(patient_id) {
        try {
            const treatment_history = await this.connection.query(`
    select patients.id as patient_id,
    opd_details.case_reference_id as case_id,
    visit_details.appointment_date,
    visit_details.symptoms,
    CONCAT('OPDN', visit_details.opd_details_id) AS OPD_ID,
    patients.patient_name,
    visit_details.case_type ,
    opd_details.discharged,
     concat(staff.name," ",staff.surname," ","(",staff.employee_id,")") as consultant_doctor ,
     visit_details.refference from visit_details
    left join opd_details on visit_details.opd_details_id = opd_details.id
    left join patients on opd_details.patient_id = patients.id
    left join organisation on visit_details.organisation_id = organisation.id
    left join staff on visit_details.cons_doctor = staff.id 
    where patients.id = ? and opd_details.discharged = 'yes'`, [patient_id]);
            return treatment_history;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(patient_id, opd_details_id) {
        try {
            const treatment_his = await this.connection.query(`select patients.id as patient_id,visit_details.id as OPDcheckupID,opd_details.case_reference_id as case_id,
    visit_details.patient_old as old_patient,patients.gender,patients.mobileno as phone,
    patients.address,
    concat(patients.age,"years"," ",patients.month,"month"," " ,patients.day,"days") as age,
    visit_details.weight,visit_details.pulse,visit_details.respiration,visit_details.appointment_date,
    visit_details.casualty,organisation.organisation_name as TPA,visit_details.note,visit_details.symptoms,
    CONCAT('OPDN', visit_details.opd_details_id) AS OPD_ID,patients.patient_name,patients.guardian_name,patients.marital_status,patients.email,
    visit_details.height,visit_details.bp,visit_details.temperature,visit_details.known_allergies,visit_details.case_type ,
    staff.name as consultant_doctor ,visit_details.refference from visit_details
    left join opd_details on visit_details.opd_details_id = opd_details.id
    left join patients on opd_details.patient_id = patients.id
    left join organisation on visit_details.organisation_id = organisation.id
    left join staff on visit_details.cons_doctor = staff.id 
    where  opd_details.id = ? and patients.id = ?`, [opd_details_id, patient_id]);
            return treatment_his;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findTreatmentHistorySearch(patientId, search) {
        let query = ` select patients.id as patient_id,
    opd_details.case_reference_id as case_id,
    visit_details.appointment_date,
    visit_details.symptoms,
    CONCAT('OPDN', visit_details.opd_details_id) AS OPD_ID,
    patients.patient_name,
    visit_details.case_type ,
    opd_details.discharged,
     concat(staff.name," ",staff.surname," ","(",staff.employee_id,")") as consultant_doctor ,visit_details.refference from visit_details
    left join opd_details on visit_details.opd_details_id = opd_details.id
    left join patients on opd_details.patient_id = patients.id
    left join organisation on visit_details.organisation_id = organisation.id
    left join staff on visit_details.cons_doctor = staff.id 
    where patients.id = ? and opd_details.discharged = 'yes' `;
        let values = [patientId];
        if (search) {
            query += ` AND (CONCAT('OPDN', visit_details.opd_details_id) LIKE ? 
                      OR opd_details.case_reference_id LIKE ? 
                      OR visit_details.appointment_date LIKE ? 
                      OR visit_details.symptoms LIKE ? 
                      OR concat(staff.name," ",staff.surname," ","(",staff.employee_id,")") LIKE ? ) `;
            const searchValue = `%${search}%`;
            values.push(searchValue, searchValue, searchValue, searchValue, searchValue);
        }
        try {
            const rows = await this.connection.query(query, values);
            return rows;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async treatmentfindall(limit, page, patient_id, search) {
        try {
            const offset = limit * (page - 1);
            let dateCondition = '';
            let searchClause = '';
            if (search) {
                const searchClause = `(
    visit_details.opd_details_id LIKE '%${search}%' OR
    opd_details.case_reference_id LIKE '%${search}%' OR
    visit_details.appointment_date LIKE '%${search}%' OR
    visit_details.symptoms LIKE '%${search}%' OR
    staff.name LIKE '%${search}%' OR
    staff.surname LIKE '%${search}%' OR
    staff.id LIKE '%${search}%'

    )`;
                dateCondition = ` AND ${searchClause}`;
            }
            const treatment_history = await this.connection.query(`
    select patients.id as patient_id,
    opd_details.case_reference_id as case_id,
    visit_details.appointment_date,
    visit_details.symptoms,
    CONCAT('OPDN', visit_details.opd_details_id) AS OPD_ID,
    patients.patient_name,
    visit_details.case_type ,
    opd_details.discharged,
     concat(staff.name," ",staff.surname," ","(",staff.employee_id,")") as consultant_doctor ,
     visit_details.refference from visit_details
    left join opd_details on visit_details.opd_details_id = opd_details.id
    left join patients on opd_details.patient_id = patients.id
    left join organisation on visit_details.organisation_id = organisation.id
    left join staff on visit_details.cons_doctor = staff.id 
    where patients.id = ? and opd_details.discharged = 'yes' ${dateCondition} LIMIT ? OFFSET ?`, [patient_id, Number(limit), Number(offset)]);
            let [totallist] = await this.connection.query(`SELECT count(visit_details.id) as total from visit_details
          left join opd_details on visit_details.opd_details_id = opd_details.id
    left join patients on opd_details.patient_id = patients.id
    left join organisation on visit_details.organisation_id = organisation.id
    left join staff on visit_details.cons_doctor = staff.id 
    where patients.id = ? and opd_details.discharged = 'yes' ${dateCondition} `, [patient_id]);
            let variable = {
                details: treatment_history,
                total: totallist.total,
                page: page,
                limit: limit
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalOpdTreatmentHistoryService = InternalOpdTreatmentHistoryService;
exports.InternalOpdTreatmentHistoryService = InternalOpdTreatmentHistoryService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalOpdTreatmentHistoryService);
//# sourceMappingURL=internal-opd-treatment-history.service.js.map