"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdTreatmentHistoryController = void 0;
const common_1 = require("@nestjs/common");
const internal_opd_treatment_history_service_1 = require("./internal-opd-treatment-history.service");
const auth_guard_1 = require("../auth/auth.guard");
let InternalOpdTreatmentHistoryController = class InternalOpdTreatmentHistoryController {
    constructor(internalOpdTreatmentHistoryService) {
        this.internalOpdTreatmentHistoryService = internalOpdTreatmentHistoryService;
    }
    findAll(patient_id) {
        return this.internalOpdTreatmentHistoryService.findAll(patient_id);
    }
    findOne(patient_id, opd_details_id) {
        return this.internalOpdTreatmentHistoryService.findOne(patient_id, opd_details_id);
    }
    async findTreatmentHistorySearch(patientId, search) {
        try {
            return await this.internalOpdTreatmentHistoryService.findTreatmentHistorySearch(patientId, search);
        }
        catch (error) {
            console.error('Error fetching payment details:', error);
            throw new Error('Failed to fetch treatment history details');
        }
    }
    async findalltreatment(patient_id, limit, page, search) {
        try {
            let final_output = await this.internalOpdTreatmentHistoryService.treatmentfindall(limit || 10, page || 1, patient_id, search || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit)
                };
            }
            return this.internalOpdTreatmentHistoryService.treatmentfindall(patient_id, limit, page, search);
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.InternalOpdTreatmentHistoryController = InternalOpdTreatmentHistoryController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], InternalOpdTreatmentHistoryController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('id'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('opd_details_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], InternalOpdTreatmentHistoryController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/Search'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdTreatmentHistoryController.prototype, "findTreatmentHistorySearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAlltreatment'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdTreatmentHistoryController.prototype, "findalltreatment", null);
exports.InternalOpdTreatmentHistoryController = InternalOpdTreatmentHistoryController = __decorate([
    (0, common_1.Controller)('internal-opd-treatment-history'),
    __metadata("design:paramtypes", [internal_opd_treatment_history_service_1.InternalOpdTreatmentHistoryService])
], InternalOpdTreatmentHistoryController);
//# sourceMappingURL=internal-opd-treatment-history.controller.js.map