"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdTimelineService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let InternalOpdTimelineService = class InternalOpdTimelineService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(opd_timeline) {
        try {
            const HOSpatient = await this.connection.query('select * from patients where id =?', [opd_timeline.patient_id]);
            const [AdminPatEmail] = await this.dynamicConnection.query(`select id from patients where aayush_unique_id = ?`, [HOSpatient[0].aayush_unique_id]);
            let currentDate = new Date();
            let year = currentDate.getFullYear();
            let month = currentDate.getMonth() + 1;
            let day = currentDate.getDate();
            let formattedDate = year + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;
            const result = await this.connection.query(`insert into patient_timeline
   (patient_id,
    title,
    timeline_date,
    description,
    document,
    status,
    date,
    generated_users_type,
    generated_users_id
    )
    values (?,?,?,?,?,?,?,?,?)`, [
                opd_timeline.patient_id,
                opd_timeline.title,
                opd_timeline.timeline_date,
                opd_timeline.description,
                opd_timeline.document,
                opd_timeline.status,
                formattedDate,
                opd_timeline.generated_users_type,
                opd_timeline.generated_users_id
            ]);
            await this.dynamicConnection.query(`insert into patient_timeline (patient_id,title,timeline_date,description,document,status,date,generated_users_type,generated_users_id,hospital_id,hospital_patient_timeline_id) values (?,?,?,?,?,?,?,?,?,?,?)`, [
                AdminPatEmail.id,
                opd_timeline.title,
                opd_timeline.timeline_date,
                opd_timeline.description,
                opd_timeline.document,
                opd_timeline.status,
                formattedDate,
                opd_timeline.generated_users_type,
                opd_timeline.generated_users_id,
                opd_timeline.hospital_id,
                result.insertId
            ]);
            return [{
                    "data": {
                        "id ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.PATIENT_TIMELINE,
                        "inserted_data": await this.connection.query('SELECT * FROM patient_timeline WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll(patient_id) {
        try {
            const opd_timeline = await this.connection.query(`SELECT patient_timeline.id,patient_timeline.patient_id,patient_timeline.title,patient_timeline.timeline_date,
    patient_timeline.description,patient_timeline.document from patient_timeline
    where patient_id = ?`, [patient_id]);
            return opd_timeline;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, opd_timeline) {
        try {
            await this.connection.query(`update patient_timeline SET title = ?, timeline_date = ?, description =?, document= ?, status= ? where id = ?`, [
                opd_timeline.title,
                opd_timeline.timeline_date,
                opd_timeline.description,
                opd_timeline.document,
                opd_timeline.status,
                id
            ]);
            await this.dynamicConnection.query('update patient_timeline SET  title = ?, timeline_date = ?, description =?, document= ?, status= ? where hospital_patient_timeline_id = ? and hospital_id = ?', [
                opd_timeline.title,
                opd_timeline.timeline_date,
                opd_timeline.description,
                opd_timeline.document,
                opd_timeline.status,
                id,
                opd_timeline.hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.PATIENT_TIMELINE_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM patient_timeline WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, hosId) {
        try {
            await this.connection.query('delete from patient_timeline WHERE id = ?', [id]);
            await this.dynamicConnection.query(`select id from patient_timeline where
 hospital_id = ? and hospital_patient_timeline_id = ?`, [
                hosId,
                id
            ]);
            await this.dynamicConnection.query(`delete from patient_timeline
     where hospital_patient_timeline_id = ?
      and hospital_id = ?`, [
                id,
                hosId
            ]);
            return [{
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalOpdTimelineService = InternalOpdTimelineService;
exports.InternalOpdTimelineService = InternalOpdTimelineService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], InternalOpdTimelineService);
//# sourceMappingURL=internal-opd-timeline.service.js.map