"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdPaymentService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const common_2 = require("@nestjs/common");
let InternalOpdPaymentService = class InternalOpdPaymentService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(InternalOpdPayment) {
        if (!InternalOpdPayment.received_by_name ||
            InternalOpdPayment.received_by_name.trim() === '') {
            throw new common_2.BadRequestException('Missing required field: received_by_name');
        }
        try {
            const [case_id] = await this.connection.query(`select case_reference_id,patient_id from opd_details where id = ?`, [InternalOpdPayment.opd_id]);
            const [app_id] = await this.connection.query(`select id from appointment where case_reference_id = ?`, [case_id.case_reference_id]);
            const HOSaddRow = await this.connection.query(`INSERT INTO transactions(type,section, case_reference_id,patient_id, opd_id,appointment_id,
         payment_date, amount, payment_mode, note,
         payment_gateway,payment_reference_number,payment_id,received_by_name,  actual_paid_amount,
  wallet_paid_amount) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?)`, [
                'Payment',
                'OPD',
                case_id.case_reference_id,
                case_id.patient_id,
                InternalOpdPayment.opd_id,
                app_id.id,
                InternalOpdPayment.payment_date,
                InternalOpdPayment.amount,
                InternalOpdPayment.payment_mode,
                InternalOpdPayment.note,
                InternalOpdPayment.payment_gateway,
                InternalOpdPayment.payment_reference_number,
                InternalOpdPayment.payment_id,
                InternalOpdPayment.received_by_name,
                InternalOpdPayment.actual_amount_paid,
                InternalOpdPayment.wallet_amount_paid
            ]);
            const dev_amounts = await this.connection.query(`select id,amount from patient_charges where opd_id = ? and payment_status = "unpaid"`, [InternalOpdPayment.opd_id]);
            try {
                for (const patient_charges of dev_amounts) {
                    await this.connection.query(`update patient_charges SET payment_status = ?, balance = ?, total = ?,  
     transaction_id = ? where opd_id = ? and payment_status = "unpaid" and id = ?`, [
                        'paid',
                        '0',
                        patient_charges.amount,
                        HOSaddRow.insertId,
                        InternalOpdPayment.opd_id,
                        patient_charges.id,
                    ]);
                }
                let AdminCaseRef;
                let AdminOpd;
                const [opd_payment] = await this.dynamicConnection.query(`select id,case_reference_id,patient_id from opd_details where Hospital_id = ?
         and hos_opd_id = ?`, [InternalOpdPayment.Hospital_id, InternalOpdPayment.opd_id]);
                AdminCaseRef = opd_payment.case_reference_id;
                AdminOpd = opd_payment.id;
                const [admin_appt_id] = await this.dynamicConnection.query(`select id from appointment where Hospital_id = ? and hos_appointment_id = ?`, [InternalOpdPayment.Hospital_id, app_id.id]);
                const AdminaddRow = await this.dynamicConnection.query(`INSERT INTO transactions(type,section, case_reference_id,
           patient_id, opd_id,appointment_id, payment_date, amount,
           Payment_mode, note,Hospital_id,hos_transaction_id,payment_gateway,payment_reference_number,payment_id,received_by_name,  actual_paid_amount,
  wallet_paid_amount)
          VALUES (?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)`, [
                    'Payment',
                    'OPD',
                    AdminCaseRef,
                    opd_payment.patient_id,
                    AdminOpd,
                    admin_appt_id.id,
                    InternalOpdPayment.payment_date,
                    InternalOpdPayment.amount,
                    InternalOpdPayment.payment_mode,
                    InternalOpdPayment.note,
                    InternalOpdPayment.Hospital_id,
                    HOSaddRow.insertId,
                    InternalOpdPayment.payment_gateway,
                    InternalOpdPayment.payment_reference_number,
                    InternalOpdPayment.payment_id,
                    InternalOpdPayment.received_by_name,
                    InternalOpdPayment.actual_amount_paid,
                    InternalOpdPayment.wallet_amount_paid
                ]);
                const admin_amount = await this.dynamicConnection.query(`select id,amount from patient_charges where opd_id = ? and payment_status = "unpaid";`, [AdminOpd]);
                for (const admin_patient_charges of admin_amount) {
                    await this.dynamicConnection.query(`update patient_charges SET payment_status = ?, balance = ?, total = ?, transaction_id = ?
       where Hospital_id = ? and opd_id = ? and payment_status = "unpaid" and id = ?`, [
                        'paid',
                        '0',
                        admin_patient_charges.amount,
                        AdminaddRow.insertId,
                        InternalOpdPayment.Hospital_id,
                        AdminOpd,
                        admin_patient_charges.id,
                    ]);
                }
            }
            catch (error) {
                throw new common_1.HttpException({
                    statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                    message: process.env.ERROR_MESSAGE,
                }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return [
                {
                    data: {
                        'id ': HOSaddRow.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.PAYMENT,
                        inserted_data: await this.connection.query('SELECT * FROM transactions WHERE id = ?', [HOSaddRow.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findALL(patient_id, opd_id) {
        try {
            const opd_payments = await this.connection.query(` SELECT 
      CONCAT("TRID", transactions.id) AS transaction_ID,
      transactions.payment_date,
      transactions.note,
      transactions.payment_mode,
      transactions.amount,
      transactions.transaction_id,
      transactions.net_banking_transaction_id,
      transactions.upi_transaction_id,
      transactions.payment_id,
      transactions.payment_reference_number
    FROM transactions
    left join appointment on appointment.id = transactions.appointment_id
    left join visit_details on visit_details.id = appointment.visit_details_id
    WHERE 
      transactions.patient_id = ? AND 
      (
          visit_details.opd_details_id = ? OR 
      transactions.opd_id = ?
      )`, [patient_id, opd_id, opd_id]);
            return opd_payments;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, hos_id) {
        try {
            await this.dynamicConnection.query(`
      update transactions set is_deleted = 1
      where Hospital_id = ? and hos_transaction_id = ?`, [hos_id, id]);
            await this.connection.query(`delete from transactions where id = ?`, [
                id,
            ]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED,
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOpdPaymentDetailsSearch(patientId, opdDetailsId, search) {
        let query = ` select concat("TRID",transactions.id) as transaction_ID,transactions.payment_date,transactions.note,
    transactions.payment_mode,transactions.amount from transactions where patient_id = ? and opd_id = ?  `;
        let values = [patientId, opdDetailsId];
        if (search) {
            query += ` AND (concat("TRID",transactions.id) LIKE ?
                      OR transactions.payment_date LIKE ?
                      OR transactions.note LIKE ?
                      OR transactions.payment_mode LIKE ?
                      OR transactions.amount LIKE ? ) `;
            const searchValue = `%${search}%`;
            values.push(searchValue, searchValue, searchValue, searchValue, searchValue);
        }
        try {
            const rows = await this.connection.query(query, values);
            return rows;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findopdpayment(limit, page, patient_id, opdDetailsId, hospital_id, search) {
        try {
            const offset = limit * (page - 1);
            let dateCondition = '';
            let searchClause = '';
            if (search) {
                const searchClause = `
      (
      transactions.id LIKE '%${search}%' OR
      transactions.payment_date LIKE '%${search}%' OR
      transactions.note LIKE '%${search}%' OR
      transactions.payment_mode LIKE '%${search}%' OR
      transactions.amount LIKE '%${search}%'
    )`;
                dateCondition += ` AND ${searchClause}`;
            }
            const opd_payment = await this.connection.query(`select appointment.id,concat("TRID",transactions.id) as transaction_ID,transactions.payment_date,transactions.note,
    transactions.payment_mode,
     CASE 
      WHEN COALESCE(transactions.amount, 0) THEN transactions.amount 
      ELSE COALESCE(transactions.temp_appt_amount, 0) 
    END AS amount,
    transactions.card_transaction_id,
      transactions.net_banking_transaction_id,
      transactions.upi_transaction_id,
      transactions.payment_id,
      transactions.payment_reference_number
     from transactions 
    left join appointment on appointment.id = transactions.appointment_id
    left join visit_details on visit_details.id = appointment.visit_details_id
    WHERE 
      transactions.patient_id = ? AND 
      (transactions.opd_id = ?  
        OR
        visit_details.opd_details_id = ?) ${dateCondition} LIMIT ? OFFSET ?`, [patient_id, opdDetailsId, opdDetailsId, Number(limit), Number(offset)]);
            const [total_count] = await this.connection.query(`
  SELECT COUNT(*) AS total_count
  FROM transactions
  LEFT JOIN appointment ON appointment.id = transactions.appointment_id
  LEFT JOIN visit_details ON visit_details.id = appointment.visit_details_id
  WHERE 
    transactions.patient_id = ? AND 
    (
      visit_details.opd_details_id = ? OR 
      transactions.opd_id = ?
    ) ${dateCondition}`, [patient_id, opdDetailsId, opdDetailsId]);
            const [getHosTimings] = await this.dynamicConnection.query(`select hospital_opening_timing,hospital_closing_timing from hospitals where plenome_id = ?`, [hospital_id]);
            let a = opd_payment[0];
            for (const a of opd_payment) {
                if (a.transaction_ID) {
                    const trnID = a.transaction_ID.replace(/[a-zA-Z]/g, '');
                    const [getPlenomeTransactionId] = await this.dynamicConnection.query(`select id from transactions where Hospital_id = ? and hos_transaction_id = ?`, [hospital_id, trnID]);
                    if (getPlenomeTransactionId) {
                        a.plenome_transaction_id = getPlenomeTransactionId.id;
                    }
                }
            }
            opd_payment.forEach((a) => {
                if (!a.doctor_id) {
                    a.slot =
                        getHosTimings.hospital_opening_timing +
                            ' - ' +
                            getHosTimings.hospital_closing_timing;
                }
            });
            let variable = {
                details: opd_payment,
                total: total_count.total_count,
                page: page,
                limit: limit,
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async createv2(InternalOpdPayment) {
        if (!InternalOpdPayment.received_by_name ||
            InternalOpdPayment.received_by_name.trim() === '') {
            throw new common_2.BadRequestException('Missing required field: received_by_name');
        }
        try {
            const [case_id] = await this.connection.query(`select case_reference_id,patient_id from opd_details where id = ?`, [InternalOpdPayment.opd_id]);
            const HOSaddRow = await this.connection.query(`INSERT INTO transactions(type,section, case_reference_id,patient_id, opd_id,
         payment_date, amount, payment_mode, note,
         payment_gateway,payment_reference_number,payment_id,received_by_name,
        payment_method,
        card_division,
        card_type,
        card_transaction_id,
        card_bank_name,
        net_banking_division,
        net_banking_transaction_id,
        upi_id,
        upi_bank_name,
        upi_transaction_id,  actual_paid_amount,
  wallet_paid_amount) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?, ?, ?,?, ?, ?,?, ?, ?, ?,?,?)`, [
                'Payment',
                'OPD',
                case_id.case_reference_id,
                case_id.patient_id,
                InternalOpdPayment.opd_id,
                InternalOpdPayment.payment_date,
                InternalOpdPayment.amount,
                InternalOpdPayment.payment_mode,
                InternalOpdPayment.note,
                InternalOpdPayment.payment_gateway,
                InternalOpdPayment.payment_reference_number,
                InternalOpdPayment.payment_id,
                InternalOpdPayment.received_by_name,
                InternalOpdPayment.payment_method,
                InternalOpdPayment.card_division,
                InternalOpdPayment.card_type,
                InternalOpdPayment.card_transaction_id,
                InternalOpdPayment.card_bank_name,
                InternalOpdPayment.net_banking_division,
                InternalOpdPayment.net_banking_transaction_id,
                InternalOpdPayment.upi_id,
                InternalOpdPayment.upi_bank_name,
                InternalOpdPayment.upi_transaction_id,
                InternalOpdPayment.actual_amount_paid,
                InternalOpdPayment.wallet_amount_paid
            ]);
            const dev_amounts = await this.connection.query(`select id,amount from patient_charges where opd_id = ? and payment_status = "unpaid"`, [InternalOpdPayment.opd_id]);
            try {
                for (const patient_charges of dev_amounts) {
                    await this.connection.query(`update patient_charges SET payment_status = ?, balance = ?, total = ?,  
     transaction_id = ? where opd_id = ? and payment_status = "unpaid" and id = ?`, [
                        'paid',
                        '0',
                        patient_charges.amount,
                        HOSaddRow.insertId,
                        InternalOpdPayment.opd_id,
                        patient_charges.id,
                    ]);
                }
                let AdminCaseRef;
                let AdminOpd;
                const [opd_payment] = await this.dynamicConnection.query(`select id,case_reference_id,patient_id from opd_details where Hospital_id = ?
         and hos_opd_id = ?`, [InternalOpdPayment.Hospital_id, InternalOpdPayment.opd_id]);
                AdminCaseRef = opd_payment.case_reference_id;
                AdminOpd = opd_payment.id;
                const AdminaddRow = await this.dynamicConnection.query(`INSERT INTO transactions(type,section, case_reference_id,
           patient_id, opd_id, payment_date, amount,
           Payment_mode, note,Hospital_id,hos_transaction_id,payment_gateway,payment_reference_number,payment_id,
           received_by_name,
        payment_method,
        card_division,
        card_type,
        card_transaction_id,
        card_bank_name,
        net_banking_division,
        net_banking_transaction_id,
        upi_id,
        upi_bank_name,
        upi_transaction_id,  actual_paid_amount,
  wallet_paid_amount)
          VALUES (?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?, ?, ?,?, ?, ?,?, ?, ?,?,?,?)`, [
                    'Payment',
                    'OPD',
                    AdminCaseRef,
                    opd_payment.patient_id,
                    AdminOpd,
                    InternalOpdPayment.payment_date,
                    InternalOpdPayment.amount,
                    InternalOpdPayment.payment_mode,
                    InternalOpdPayment.note,
                    InternalOpdPayment.Hospital_id,
                    HOSaddRow.insertId,
                    InternalOpdPayment.payment_gateway,
                    InternalOpdPayment.payment_reference_number,
                    InternalOpdPayment.payment_id,
                    InternalOpdPayment.received_by_name,
                    InternalOpdPayment.payment_method,
                    InternalOpdPayment.card_division,
                    InternalOpdPayment.card_type,
                    InternalOpdPayment.card_transaction_id,
                    InternalOpdPayment.card_bank_name,
                    InternalOpdPayment.net_banking_division,
                    InternalOpdPayment.net_banking_transaction_id,
                    InternalOpdPayment.upi_id,
                    InternalOpdPayment.upi_bank_name,
                    InternalOpdPayment.upi_transaction_id,
                    InternalOpdPayment.actual_amount_paid,
                    InternalOpdPayment.wallet_amount_paid
                ]);
                const admin_amount = await this.dynamicConnection.query(`select id,amount from patient_charges where opd_id = ? and payment_status = "unpaid";`, [AdminOpd]);
                for (const admin_patient_charges of admin_amount) {
                    await this.dynamicConnection.query(`update patient_charges SET payment_status = ?, balance = ?, total = ?, transaction_id = ?
       where Hospital_id = ? and opd_id = ? and payment_status = "unpaid" and id = ?`, [
                        'paid',
                        '0',
                        admin_patient_charges.amount,
                        AdminaddRow.insertId,
                        InternalOpdPayment.Hospital_id,
                        AdminOpd,
                        admin_patient_charges.id,
                    ]);
                }
            }
            catch (error) {
                throw new common_1.HttpException({
                    statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                    message: process.env.ERROR_MESSAGE,
                }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return [
                {
                    data: {
                        'id ': HOSaddRow.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.PAYMENT,
                        inserted_data: await this.connection.query('SELECT * FROM transactions WHERE id = ?', [HOSaddRow.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async getOpdBalance(opd_id) {
        try {
            const [appointment_id] = await this.connection.query(`select appointment.id from appointment 
left join visit_details on  appointment.visit_details_id = visit_details.id
left join opd_details on visit_details.opd_details_id = opd_details.id
where opd_details.id = ?`, [opd_id]);
            console.log('appointment_id', appointment_id.id);
            const [result] = await this.connection.query(`
     SELECT 
          IFNULL((
            SELECT SUM(total) 
            FROM patient_charges
            WHERE opd_id = ?
          ), 0) AS total_charges,
  
            IFNULL((
            SELECT IFNULL(SUM(amount), 0) + IFNULL(SUM(temp_appt_amount), 0)
            FROM transactions
            WHERE opd_id = ? OR appointment_id = ?
             ), 0) AS total_payments,

  
          FORMAT(
            IFNULL((
              SELECT SUM(total) 
              FROM patient_charges
              WHERE opd_id = ?
            ), 0) -
             IFNULL((
            SELECT IFNULL(SUM(amount), 0) + IFNULL(SUM(temp_appt_amount), 0)
            FROM transactions
            WHERE opd_id = ? OR appointment_id = ?
             ), 0),
            2
          ) AS balance
        `, [opd_id, opd_id, appointment_id.id, opd_id, opd_id, appointment_id.id]);
            return {
                balance: result.balance ?? '0.00',
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalOpdPaymentService = InternalOpdPaymentService;
exports.InternalOpdPaymentService = InternalOpdPaymentService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], InternalOpdPaymentService);
//# sourceMappingURL=internal-opd-payment.service.js.map