import { DataSource } from 'typeorm';
import { InternalOpdPayment, InternalOpdPaymentv3 } from './entities/internal-opd-payment.entity';
import { CountDto } from './internal-opd-payment.dto';
export declare class InternalOpdPaymentService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    create(InternalOpdPayment: InternalOpdPayment): Promise<{
        data: {
            'id ': any;
            status: string;
            messege: string;
            inserted_data: any;
        };
    }[]>;
    findALL(patient_id: number, opd_id: number): Promise<any>;
    remove(id: string, hos_id: number): Promise<{
        status: string;
        message: string;
    }[]>;
    findOpdPaymentDetailsSearch(patientId: number, opdDetailsId: number, search: string): Promise<InternalOpdPayment[]>;
    findopdpayment(limit: number, page: number, patient_id: number, opdDetailsId: number, hospital_id: number, search: string): Promise<CountDto>;
    createv2(InternalOpdPayment: InternalOpdPaymentv3): Promise<{
        data: {
            'id ': any;
            status: string;
            messege: string;
            inserted_data: any;
        };
    }[]>;
    getOpdBalance(opd_id: number): Promise<{
        balance: string;
    }>;
}
