"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdPaymentController = void 0;
const common_1 = require("@nestjs/common");
const internal_opd_payment_service_1 = require("./internal-opd-payment.service");
const internal_opd_payment_entity_1 = require("./entities/internal-opd-payment.entity");
const auth_guard_1 = require("../auth/auth.guard");
let InternalOpdPaymentController = class InternalOpdPaymentController {
    constructor(internalOpdPaymentService) {
        this.internalOpdPaymentService = internalOpdPaymentService;
    }
    create(InternalOpdPayment) {
        return this.internalOpdPaymentService.create(InternalOpdPayment);
    }
    findAll(patient_id, opd_id) {
        return this.internalOpdPaymentService.findALL(patient_id, opd_id);
    }
    remove(id, hos_id) {
        return this.internalOpdPaymentService.remove(id, hos_id);
    }
    async findOpdPaymentDetailsSearch(patientId, opdDetailsId, search) {
        try {
            return await this.internalOpdPaymentService.findOpdPaymentDetailsSearch(patientId, opdDetailsId, search);
        }
        catch (error) {
            console.error('Error fetching payment details:', error);
            throw new Error('Failed to fetch opd payment details');
        }
    }
    async findAlldesigopd_payment(patient_id, opdDetailsId, hospital_id, limit, page, search) {
        try {
            const final_output = await this.internalOpdPaymentService.findopdpayment(limit || 10, page || 1, patient_id, opdDetailsId, hospital_id, search || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit),
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No opd found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                };
            }
        }
        catch (error) {
            console.error('Error fetching visit details:', error);
            throw new Error('Failed to fetch ocid visit details');
        }
    }
    createv3(createOpdBilling) {
        if (createOpdBilling.payment_mode.toLocaleLowerCase() != 'cash' &&
            createOpdBilling.payment_mode.toLocaleLowerCase() != 'card' &&
            createOpdBilling.payment_mode.toLocaleLowerCase() != 'net_banking' &&
            createOpdBilling.payment_mode.toLocaleLowerCase() != 'upi') {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Enter Correct Payment Method',
            };
        }
        if (!createOpdBilling.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
            };
        }
        if (!createOpdBilling.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'card' &&
            !createOpdBilling.card_division &&
            !createOpdBilling.card_bank_name &&
            !createOpdBilling.card_type &&
            !createOpdBilling.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'net_banking' &&
            !createOpdBilling.net_banking_division &&
            !createOpdBilling.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'upi' &&
            !createOpdBilling.upi_id &&
            !createOpdBilling.upi_transaction_id &&
            !createOpdBilling.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.internalOpdPaymentService.createv2(createOpdBilling);
    }
    async getOpdBalance(opd_id) {
        try {
            if (!opd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: process.env.OPD_VALIDATE_MESSAGE,
                };
            }
            const balanceData = await this.internalOpdPaymentService.getOpdBalance(opd_id);
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: process.env.BALANCE_FETCH_MESSAGE,
                balance_amount: balanceData.balance,
            };
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.InternalOpdPaymentController = InternalOpdPaymentController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [internal_opd_payment_entity_1.InternalOpdPayment]),
    __metadata("design:returntype", void 0)
], InternalOpdPaymentController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('opd_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], InternalOpdPaymentController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hos_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], InternalOpdPaymentController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/Search'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Query)('opdDetailsId')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdPaymentController.prototype, "findOpdPaymentDetailsSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllopdpayment'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('opdDetailsId')),
    __param(2, (0, common_1.Query)('hospital_id')),
    __param(3, (0, common_1.Query)('limit')),
    __param(4, (0, common_1.Query)('page')),
    __param(5, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number, Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdPaymentController.prototype, "findAlldesigopd_payment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/v2'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [internal_opd_payment_entity_1.InternalOpdPaymentv3]),
    __metadata("design:returntype", void 0)
], InternalOpdPaymentController.prototype, "createv3", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_opd_balance'),
    __param(0, (0, common_1.Query)('opd_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], InternalOpdPaymentController.prototype, "getOpdBalance", null);
exports.InternalOpdPaymentController = InternalOpdPaymentController = __decorate([
    (0, common_1.Controller)('internal-opd-payment'),
    __metadata("design:paramtypes", [internal_opd_payment_service_1.InternalOpdPaymentService])
], InternalOpdPaymentController);
//# sourceMappingURL=internal-opd-payment.controller.js.map