"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdOverviewService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalOpdOverviewService = class InternalOpdOverviewService {
    constructor(connection) {
        this.connection = connection;
    }
    async findALL(patient_id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM patients WHERE id = ?`, [patient_id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const overview = await this.connection.query(` select distinct concat(patients.patient_name," ","(",patients.id,")") as name,patients.gender,concat(patients.age,"year"," " ,patients.month,"months"," " , patients.day,"days") as age,
   patients.guardian_name,patients.mobileno as phone ,patients.known_allergies, visit_details.symptoms, opd_details.id as OPD_ID from visit_details
   join opd_details ON visit_details.opd_details_id = opd_details.id  
    join patients ON patients.id = opd_details.patient_id  where patients.id = ?`, [patient_id]);
            return overview;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalOpdOverviewService = InternalOpdOverviewService;
exports.InternalOpdOverviewService = InternalOpdOverviewService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalOpdOverviewService);
//# sourceMappingURL=internal-opd-overview.service.js.map