"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdOverviewVisitsController = void 0;
const common_1 = require("@nestjs/common");
const internal_opd_overview_visits_service_1 = require("./internal-opd-overview-visits.service");
const internal_opd_overview_visit_entity_1 = require("./entities/internal-opd-overview-visit.entity");
const auth_guard_1 = require("../auth/auth.guard");
let InternalOpdOverviewVisitsController = class InternalOpdOverviewVisitsController {
    constructor(internalOpdOverviewVisitsService) {
        this.internalOpdOverviewVisitsService = internalOpdOverviewVisitsService;
    }
    create(InternalOpdOverviewVisit) {
        return this.internalOpdOverviewVisitsService.create(InternalOpdOverviewVisit);
    }
    findAll(patient_id, opd_details_id) {
        return this.internalOpdOverviewVisitsService.findAll(patient_id, opd_details_id);
    }
    findOne(id) {
        return this.internalOpdOverviewVisitsService.findone(id);
    }
    update(id, InternalOpdOverviewVisit) {
        return this.internalOpdOverviewVisitsService.update(+id, InternalOpdOverviewVisit);
    }
    async remove(id, Hospital_id) {
        const deletevisit = await this.internalOpdOverviewVisitsService.remove(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async findVisitDetailsSearch(patientId, opdDetailsId, search) {
        try {
            return await this.internalOpdOverviewVisitsService.findVisitDetailsSearch(patientId, opdDetailsId, search);
        }
        catch (error) {
            console.error('Error fetching visit details:', error);
            throw new Error('Failed to fetch visit details');
        }
    }
    async findAllDesig(patient_id, limit, page, search) {
        try {
            const final_output = await this.internalOpdOverviewVisitsService.opd_visit(patient_id, limit || 10, page || 1, search);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalPages: Math.ceil(final_output.total / final_output.limit)
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No opd found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                };
            }
        }
        catch (error) {
            throw new Error('Failed to fetch visit details');
        }
    }
    async findAllDesigById(patient_id, opd_details_id, limit, page, search) {
        try {
            const final_output = await this.internalOpdOverviewVisitsService.opd_OCID(patient_id, opd_details_id, limit || 10, page || 1, search);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit)
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No opd found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                };
            }
        }
        catch (error) {
            throw new Error('Failed to fetch ocid visit details');
        }
    }
    findOnes(opd_details_id) {
        return this.internalOpdOverviewVisitsService.opd_visit_info(opd_details_id);
    }
    findonesById(id) {
        return this.internalOpdOverviewVisitsService.checkup_id_ocid(id);
    }
};
exports.InternalOpdOverviewVisitsController = InternalOpdOverviewVisitsController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [internal_opd_overview_visit_entity_1.InternalOpdOverviewVisit]),
    __metadata("design:returntype", void 0)
], InternalOpdOverviewVisitsController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('opd_details_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], InternalOpdOverviewVisitsController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], InternalOpdOverviewVisitsController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, internal_opd_overview_visit_entity_1.InternalOpdOverviewVisit]),
    __metadata("design:returntype", void 0)
], InternalOpdOverviewVisitsController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], InternalOpdOverviewVisitsController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/Search'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Query)('opdDetailsId')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdOverviewVisitsController.prototype, "findVisitDetailsSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpage'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdOverviewVisitsController.prototype, "findAllDesig", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpagess'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('opd_details_id')),
    __param(2, (0, common_1.Query)('limit')),
    __param(3, (0, common_1.Query)('page')),
    __param(4, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdOverviewVisitsController.prototype, "findAllDesigById", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], InternalOpdOverviewVisitsController.prototype, "findOnes", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('ocid/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], InternalOpdOverviewVisitsController.prototype, "findonesById", null);
exports.InternalOpdOverviewVisitsController = InternalOpdOverviewVisitsController = __decorate([
    (0, common_1.Controller)('internal-opd-overview-visits'),
    __metadata("design:paramtypes", [internal_opd_overview_visits_service_1.InternalOpdOverviewVisitsService])
], InternalOpdOverviewVisitsController);
//# sourceMappingURL=internal-opd-overview-visits.controller.js.map