"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdOverviewConsultantDoctorService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalOpdOverviewConsultantDoctorService = class InternalOpdOverviewConsultantDoctorService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(patient_id) {
        try {
            const consultant_doctor = await this.connection.query(`select distinct patients.patient_name as name,opd_details.patient_id ,group_concat(distinct concat( staff.name, ' ', staff.surname,staff.employee_id) separator',') AS consultant_doctor
    from visit_details
     join opd_details ON visit_details.opd_details_id = opd_details.id   
      join patients ON patients.id = opd_details.patient_id
      join staff ON staff.id = visit_details.cons_doctor where opd_details.patient_id = ?`, [patient_id]);
            return consultant_doctor;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalOpdOverviewConsultantDoctorService = InternalOpdOverviewConsultantDoctorService;
exports.InternalOpdOverviewConsultantDoctorService = InternalOpdOverviewConsultantDoctorService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalOpdOverviewConsultantDoctorService);
//# sourceMappingURL=internal-opd-overview-consultant_doctor.service.js.map