"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdMedicationMedicationNameService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalOpdMedicationMedicationNameService = class InternalOpdMedicationMedicationNameService {
    constructor(connection) {
        this.connection = connection;
    }
    async findall(medicine_category_id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM pharmacy WHERE medicine_category_id = ?`, [medicine_category_id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const medication_name = await this.connection.query(`select pharmacy.id, pharmacy.medicine_name from pharmacy where pharmacy.medicine_category_id = ?`, [medicine_category_id]);
            return medication_name;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalOpdMedicationMedicationNameService = InternalOpdMedicationMedicationNameService;
exports.InternalOpdMedicationMedicationNameService = InternalOpdMedicationMedicationNameService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalOpdMedicationMedicationNameService);
//# sourceMappingURL=internal-opd-medication-medication_name.service.js.map