"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOpdChargesController = void 0;
const common_1 = require("@nestjs/common");
const internal_opd_charges_service_1 = require("./internal-opd-charges.service");
const internal_opd_charge_entity_1 = require("./entities/internal-opd-charge.entity");
const auth_guard_1 = require("../auth/auth.guard");
let InternalOpdChargesController = class InternalOpdChargesController {
    constructor(internalOpdChargesService) {
        this.internalOpdChargesService = internalOpdChargesService;
    }
    create(InternalOpdChargeentity) {
        return this.internalOpdChargesService.create(InternalOpdChargeentity);
    }
    findAll(opd_id, patient_id) {
        return this.internalOpdChargesService.findAll(opd_id, patient_id);
    }
    update(id, InternalOpdChargeentity) {
        return this.internalOpdChargesService.update(id, InternalOpdChargeentity);
    }
    remove(id, Hospital_id) {
        return this.internalOpdChargesService.remove(id, Hospital_id);
    }
    findcharges(id) {
        return this.internalOpdChargesService.findcharges(id);
    }
    findAmount(id) {
        return this.internalOpdChargesService.findAmount(id);
    }
    async findOpdChargesDetailsSearch(patientId, opdDetailsId, search) {
        try {
            return await this.internalOpdChargesService.findOpdChargesDetailsSearch(patientId, opdDetailsId, search);
        }
        catch (error) {
            console.error('Error fetching charges details:', error);
            throw new Error('Failed to fetch opd charge details');
        }
    }
    async findAllDesigById(patient_id, opdDetailsId, limit, page, search) {
        try {
            const final_output = await this.internalOpdChargesService.findOpdChargesDetailsSearchCount(limit || 10, page || 1, opdDetailsId, search || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit)
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No opd found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                };
            }
        }
        catch (error) {
            throw new Error('Failed to fetch ocid visit details');
        }
    }
};
exports.InternalOpdChargesController = InternalOpdChargesController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], InternalOpdChargesController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)("opd_id")),
    __param(1, (0, common_1.Query)("patient_id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], InternalOpdChargesController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, internal_opd_charge_entity_1.InternalOpdCharge]),
    __metadata("design:returntype", void 0)
], InternalOpdChargesController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], InternalOpdChargesController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/charges/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], InternalOpdChargesController.prototype, "findcharges", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/amount/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], InternalOpdChargesController.prototype, "findAmount", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/Search'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Query)('opdDetailsId')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdChargesController.prototype, "findOpdChargesDetailsSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllcharges'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('opdDetailsId')),
    __param(2, (0, common_1.Query)('limit')),
    __param(3, (0, common_1.Query)('page')),
    __param(4, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalOpdChargesController.prototype, "findAllDesigById", null);
exports.InternalOpdChargesController = InternalOpdChargesController = __decorate([
    (0, common_1.Controller)('internal-opd-charges'),
    __metadata("design:paramtypes", [internal_opd_charges_service_1.InternalOpdChargesService])
], InternalOpdChargesController);
//# sourceMappingURL=internal-opd-charges.controller.js.map