import { DataSource } from 'typeorm';
import { InternalIpdPayment, InternalIpdPaymentV2 } from './entities/internal-ipd-payment.entity';
import { CountDto } from './dto/internal-ipd-payment.dto';
export declare class InternalIpdPaymentService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    create(createInternalIpdPayment: InternalIpdPayment): Promise<{
        data: {
            'id ': any;
            status: string;
            messege: string;
            inserted_data: any;
        };
    }[]>;
    findALL(patient_id: number, ipd_id: number): Promise<any>;
    update(id: string, createInternalIpdPayment: InternalIpdPayment): Promise<{
        data: {
            status: string;
            message: string;
            updated_values: any;
        };
    }[]>;
    remove(id: string, hos_id: number): Promise<{
        status: string;
        message: string;
    }[]>;
    findIpdPaymentDetailsSearch(patientId: number, ipdDetailsId: number, search: string): Promise<InternalIpdPayment[]>;
    findIpdPaymentDetails(ipd_id: number, patient_id: number, hospital_id: number, search: string, limit: number, page: number): Promise<CountDto>;
    findIpdPaymentDetail(ipd_id: number, patient_id: number, search: string, limit: number, page: number): Promise<CountDto>;
    V2create(createInternalIpdPayment: InternalIpdPaymentV2): Promise<{
        data: {
            'id ': any;
            status: string;
            messege: string;
            inserted_data: any;
        };
    }[]>;
    getIpdBalanceAmount(ipd_id: number): Promise<{
        balance: string;
    }>;
}
